/* Copyright (c) 1995,1996 NEC Corporation.  All rights reserved.            */
/*                                                                           */
/* The redistribution, use and modification in source or binary forms of     */
/* this software is subject to the conditions set forth in the copyright     */
/* document ("COPYRIGHT") included with this distribution.                   */
#ifndef __WRAP_H__
#define __WRAP_H__

/* status */
#define CON_NOTESTABLISHED	1
#define	CON_INPROGRESS		2
#define	CON_ESTABLISHED		3
#define	CON_BINDING		4
#define	CON_BINDED		5
#define	CON_LISTENING		6
#define CON_ACCEPTING           7
#define CON_ACCEPTED            8
#define	CON_ESTABLISHEDSEND	9
#define	CON_SENDTO		10
#define	CON_RECV		11

#ifndef MAXNAMELEN
#define MAXNAMELEN 256
#endif

struct proxyinfo {
    S5NetAddr prxyin;				 /* proxy in  intfc address  */
    S5NetAddr prxyout;				 /* proxy out intfc address  */
    S5IOInfo cinfo;			         /* generic control info     */
    u_char how;                                  /* version #                */
    u_char reserved;                             /* reserved                 */
    int refcount;                                /* # of socksinfo's use us  */ 

    struct proxyinfo *next;
};

typedef struct proxyinfo lsProxyInfo;

struct socksinfo {
    S5IOHandle fd;	            /* socket descriptor                     */
    S5IOHandle afd;		    /* backup socket 			     */
    u_char cmd, status;             /* how we connected, proto, status       */
    u_short myport;
    lsProxyInfo *pri, *cur;         /* proxies we used...                    */
    S5NetAddr peer;		    /* bound address or connect...           */
    int serrno;                     /* stored error (from nbconnect)         */
    
    struct socksinfo *next;	    /* next structure...                     */
};

typedef struct socksinfo lsSocksInfo;

#endif
