/* Copyright (c) 1995,1996 NEC Corporation.  All rights reserved.            */
/*                                                                           */
/* The redistribution, use and modification in source or binary forms of     */
/* this software is subject to the conditions set forth in the copyright     */
/* document ("COPYRIGHT") included with this distribution.                   */
#define HIDEORIG
#include "socks5p.h"
#include "protocol.h"
#include "buffer.h"
#include "addr.h"
#include "wrap.h"
#include "wrap_tcp.h"
#include "wrap_udp.h"
#include "confutil.h"
#include "cache.h"
#include "hostname.h"
#include "log.h"

int lsInRLDFunctions = 0;

/* This macro (w/o do...while(0)) scares me, but it gets rid of a lot of     */
/* warnings with Solaris's cc.                                               */
#define DLRETURN(var, rval, exp) (rval) = (exp); (var) = 0; return (rval)

static int lsSocketType(S5IOHandle fd, const ss *name) {
    int optval, optlen = sizeof(int), slen = sizeof(S5NetAddr), eno = GETERRNO();
    S5NetAddr na;

    memset(&na, 0, sizeof(na));

    if (REAL(getsockname)(fd, &na.sa, &slen) < 0) {
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(0), 0, "lsSocketType: getsockname returned %m");
	return -1;
    }

    if (!ISINET(&na.sa) && !(ISUNSPEC(&na.sa) && name && ISINET(name))) {
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(0), 0, "lsSocketType: Not AF_INET: %d", na.sa.sa_family);
	return -1;
    }
                                      
    if (getsockopt(fd, SOL_SOCKET, SO_TYPE, (char *)&optval, &optlen) < 0) {
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(0), 0, "lsSocketType: getsockopt returned %m");
	return -1;
    }

    SETERRNO(eno);
    return optval;
}

/* wrapper around the shutdown system call.  This could be kind of tricky:   */
/* may be we should keep track of SHUTDOWN status as read or write may be    */
/* still allowed even after shutdown, depending on the value of howto XXX    */
int LIBPREFIX(shutdown)(S5IOHandle fd, int howto) {
    LIBPREFIX2(init)("libsocks5");
    S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS shutdown: FAKE");

    if (lsInRLDFunctions) return REAL(shutdown)(fd, howto);

    lsConnectionDel(fd);
    return REAL(shutdown)(fd, howto);
}

/* wrapper around the connect system call.                                   */
int LIBPREFIX(connect)(S5IOHandle sd, CONST ss *name, int namelen) {
    LIBPREFIX2(init)("libsocks5");

    if (lsInRLDFunctions) return REAL(connect)(sd, name, namelen);

    switch (lsSocketType(sd, name)) {
    case SOCK_DGRAM:
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS connect: FAKE");
	return lsUdpConnect(sd, name, namelen);
    case SOCK_STREAM:
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS connect: FAKE");
	return lsTcpConnect(sd, name, namelen);
    default:
        S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS connect: REAL");
	return REAL(connect)(sd, name, namelen);
    }
}

/* wrapper around the bind system call.                                      */
int LIBPREFIX(bind)(S5IOHandle sd, CONST ss *name, int namelen) {
    LIBPREFIX2(init)("libsocks5");

    if (lsInRLDFunctions) return REAL(bind)(sd, name, namelen);

    switch (lsSocketType(sd, name)) {
    case SOCK_STREAM:
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS bind: FAKE");
	return lsTcpBind(sd, name, namelen);
    case SOCK_DGRAM:
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS bind: FAKE");
	return lsUdpBind(sd, name, namelen);
    default:
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS bind: REAL");
	return REAL(bind)(sd, name, namelen);
    }
}

/* wrapper around the getsockname system call.                               */
int LIBPREFIX(getsockname)(S5IOHandle sd, struct sockaddr *name, int *namelen) {
    LIBPREFIX2(init)("libsocks5");

    if (lsInRLDFunctions) return REAL(getsockname)(sd, name, namelen);

    switch (lsSocketType(sd, NULL)) {
    case SOCK_STREAM:
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS getsockname: FAKE");
	return lsTcpGetsockname(sd, name, namelen);
    case SOCK_DGRAM:
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS getsockname: FAKE");
	return lsUdpGetsockname(sd, name, namelen);
    default:
        S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS getsockname: REAL");
	return REAL(getsockname)(sd, name, namelen);
    }
}

/* wrapper around the getpeername system call.                               */
int LIBPREFIX(getpeername)(S5IOHandle sd, struct sockaddr *name, int *namelen) {
    LIBPREFIX2(init)("libsocks5");

    if (lsInRLDFunctions) return REAL(getpeername)(sd, name, namelen);

    switch (lsSocketType(sd, NULL)) {
    case SOCK_DGRAM:
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS getpeername: FAKE");
	return lsUdpGetpeername(sd, name, namelen); 
    case SOCK_STREAM:
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS getpeername: FAKE");
	return lsTcpGetpeername(sd, name, namelen);
    default:
        S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS getpeername: REAL");
	return REAL(getpeername)(sd, name, namelen);
    }
}

/* wrapper around the send system call.                                      */
IORETTYPE LIBPREFIX(send)(S5IOHandle sd, const IOPTRTYPE msg, IOLENTYPE len, int flags) {
    static int DontLoop = 0;
    int rval;

    LIBPREFIX2(init)("libsocks5");

    if (lsInRLDFunctions || DontLoop) {
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS send: REAL: Looping");
	return REAL(send)(sd, msg, len, flags);
    }

    DontLoop = 1;

    switch (lsSocketType(sd, NULL)) {
    case SOCK_DGRAM:
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS write: FAKE: Udp");
	DLRETURN(DontLoop, rval, lsUdpSend(sd, msg, len, flags));
    case SOCK_STREAM:
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS write: FAKE: Tcp");
	DLRETURN(DontLoop, rval, lsTcpSend(sd, msg, len, flags));
    default:
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS send: REAL: Wrong type");	
	DLRETURN(DontLoop, rval, -1);
    }
}

/* wrapper around the sendto system call.                                    */
IORETTYPE LIBPREFIX(sendto)(S5IOHandle sd, const IOPTRTYPE msg, IOLENTYPE len, int flags, struct sockaddr *to, int tolen) {
    static int DontLoop = 0;
    int rval;

    LIBPREFIX2(init)("libsocks5");

    if (lsInRLDFunctions || DontLoop) {
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS sendto: REAL: Looping");
	return REAL(sendto)(sd, msg, len, flags, to, tolen);
    }

    DontLoop = 1;

    switch (lsSocketType(sd, NULL)) {
    case SOCK_DGRAM:
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS sendto: FAKE: Udp");
	DLRETURN(DontLoop, rval, lsUdpSendto(sd, msg, len, flags, to, tolen));
    case SOCK_STREAM:
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS sendto: FAKE: Tcp");
	DLRETURN(DontLoop, rval, lsTcpSend(sd, msg, len, flags));
    default:
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS sendto: REAL: Wrong type");	
	DLRETURN(DontLoop, rval, -1);
    }
}

/* wrapper around the recv system call.                                      */
IORETTYPE LIBPREFIX(recv)(S5IOHandle sd, IOPTRTYPE msg, IOLENTYPE len, int flags) {
    static int DontLoop = 0;
    int rval;
    
    LIBPREFIX2(init)("libsocks5");

    if (lsInRLDFunctions || DontLoop) {
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS recv: REAL: Looping");
	return REAL(recv)(sd, msg, len, flags);
    }

    DontLoop = 1;

    switch (lsSocketType(sd, NULL)) {
    case SOCK_DGRAM:
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS recv: FAKE: Udp");
	DLRETURN(DontLoop, rval, lsUdpRecvfrom(sd, msg, len, flags, NULL, NULL, 1));
    case SOCK_STREAM:
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS recv: FAKE: Tcp");
	DLRETURN(DontLoop, rval, lsTcpRecv(sd, msg, len, flags));
    default:
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS recv: REAL: Wrong type");	
	DLRETURN(DontLoop, rval, -1);
    }
}

/* wrapper around the recvfrom system call.                                  */
IORETTYPE LIBPREFIX(recvfrom)(S5IOHandle sd, IOPTRTYPE msg, IOLENTYPE len, int flags, ss *from, int *fromlen) {
    static int DontLoop = 0;
    int rval;

    LIBPREFIX2(init)("libsocks5");

    if (lsInRLDFunctions || DontLoop) {
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS recvfrom: REAL: Looping");
    	return REAL(recvfrom)(sd, msg, len, flags, from, fromlen);
    }

    DontLoop = 1;

    switch (lsSocketType(sd, NULL)) {
    case SOCK_DGRAM:
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS recv: FAKE: Udp");
	DLRETURN(DontLoop, rval, lsUdpRecvfrom(sd, msg, len, flags, from, fromlen, 0));
    default:
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS recv: REAL: Wrong type");	
	SETSOCKETERROR(EBADF);
	DLRETURN(DontLoop, rval, -1);
    }
}


/* wrapper around the close system call.  Not strictly necessary, but it     */
/* cleans up some things, so it is kind of nice to call...                   */
int LIBPREFIX(close)(S5IOHandle fd) {
    LIBPREFIX2(init)("libsocks5");
    S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS close: FAKE");

    if (lsInRLDFunctions) return REAL(close)(fd);
    if (getenv("SOCKS5_PRESERVE_STDERR") && fd == STDERR_FILENO) return 0;

    lsConnectionDel(fd);
    return REAL(close)(fd);
}

/* wrapper around the fclose stdio library function...See comment for close. */
int LIBPREFIX(fclose)(FILE *fp) {
    LIBPREFIX2(init)("libsocks5");
    S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS fclose: FAKE");

    if (lsInRLDFunctions || fp == NULL) return REAL(fclose)(fp);
    if (getenv("SOCKS5_PRESERVE_STDERR") && fileno(fp) == STDERR_FILENO) return 0;

    lsConnectionDel(fileno(fp));
    return REAL(fclose)(fp);
}

IORETTYPE LIBPREFIX(write)(S5IOHandle sd, const IOPTRTYPE buf, IOLENTYPE buflen) {
    static int DontLoop = 0;
    int rval;

    LIBPREFIX2(init)("libsocks5");

    if (lsInRLDFunctions || DontLoop) {
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS write: REAL: Looping");
	return REAL(write)(sd, buf, buflen);
    }

    DontLoop = 1;

    switch (lsSocketType(sd, NULL)) {
    case SOCK_DGRAM:
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS write: FAKE: Udp");
	DLRETURN(DontLoop, rval, lsUdpSend(sd, buf, buflen, 0));
    case SOCK_STREAM:
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS write: FAKE: Tcp");
	DLRETURN(DontLoop, rval, lsTcpSend(sd, buf, buflen, 0));
    default:
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS write: REAL: Wrong type");	
	DLRETURN(DontLoop, rval, REAL(write)(sd, buf, buflen));
    }
}

IORETTYPE LIBPREFIX(read)(S5IOHandle sd, IOPTRTYPE buf, IOLENTYPE buflen) {
    static int DontLoop = 0;
    int rval;
    
    LIBPREFIX2(init)("libsocks5");

    if (lsInRLDFunctions || DontLoop) {
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS read: REAL: Looping");
	return REAL(read)(sd, buf, buflen);
    }

    DontLoop = 1;

    switch (lsSocketType(sd, NULL)) {
    case SOCK_DGRAM:
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS read: FAKE: Udp");
	DLRETURN(DontLoop, rval, lsUdpRecvfrom(sd, buf, buflen, 0, NULL, NULL, 1));
    case SOCK_STREAM:
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS read: FAKE: Tcp");
	DLRETURN(DontLoop, rval, lsTcpRecv(sd, buf, buflen, 0));
    default:
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS read: REAL: Wrong type");	
	DLRETURN(DontLoop, rval, REAL(read)(sd, buf, buflen));
    }
}

S5IOHandle LIBPREFIX(dup)(S5IOHandle sd) {
    int i;
    S5IOHandle tmpsd[10];
    S5IOHandle s2 = S5InvalidIOHandle;
    lsSocksInfo *pcon, *ncon, *q;
    lsProxyInfo *pri;

    LIBPREFIX2(init)("libsocks5");

#if defined(sun) && defined(__svr4__)
    for (i = 0; i < 10; i++) {
	int type = lsSocketType(sd, NULL);

    	if ((tmpsd[i] = REAL(dup)(sd)) == S5InvalidIOHandle) {
	    S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS dup: dup failed");
	    break;
	}

	if (lsSocketType(tmpsd[i], NULL) != type) continue;
	s2 = tmpsd[i];
	break;
    }

    if (s2 == S5InvalidIOHandle) {
    	while (i-- >= 0) CLOSESOCKET(tmpsd[i]);
	return s2;
    }

    while (--i >= 0) CLOSESOCKET(tmpsd[i]);
#else
    if ((s2 = REAL(dup)(sd)) == S5InvalidIOHandle) {
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS dup: dup failed");
	return S5InvalidIOHandle;
    }
#endif
    
    if ((pcon = lsConnectionFind(sd)) == NULL) {
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS dup: no connection found");
	return s2;
    }

    if ((ncon = lsConnectionFind(s2)) != NULL) {
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS dup: deleting invalid connection found");
	lsConnectionDel(s2);
    }

    if ((ncon = lsConnectionAdd(s2)) == NULL) {
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS dup: couldn't add connection");
	REAL(close)(s2);
	SETSOCKETERROR(EMFILE);
	return S5InvalidIOHandle;
    }

    q = ncon->next;
    *ncon = *pcon;
    ncon->fd = s2;
    ncon->next = q;

    for (pri = ncon->pri; pri; pri = pri->next) pri->refcount++;
    S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS dup: done");
    return s2;
}


S5IOHandle LIBPREFIX(dup2)(S5IOHandle sd, S5IOHandle s2) {
    lsSocksInfo *pcon, *ncon, *q;
    lsProxyInfo *pri;

    LIBPREFIX2(init)("libsocks5");

    if (getenv("SOCKS5_PRESERVE_STDERR") && s2 == STDERR_FILENO) {
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS dup2: leaving stderr alone (by request)");	
	return s2;
    }

    if ((s2 = REAL(dup2)(sd, s2)) == S5InvalidIOHandle) {
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS dup2: dup2 failed");	
	return S5InvalidIOHandle;
    }
    
    if ((pcon = lsConnectionFind(sd)) == NULL) {
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS dup2: no connection found");	
	return s2;
    }

    if ((ncon = lsConnectionFind(s2)) != NULL) {
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS dup2: deleting invalid connection found");
	lsConnectionDel(s2);
    }

    if ((ncon = lsConnectionAdd(s2)) == NULL) {
	S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS dup2: couldn't add connection");
	REAL(close)(s2);
	SETSOCKETERROR(EMFILE);
	return S5InvalidIOHandle;
    }

    q = ncon->next;
    *ncon = *pcon;
    ncon->fd = s2;
    ncon->next = q;

    for (pri = ncon->pri; pri; pri = pri->next) pri->refcount++;
    S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS dup2: done");
    return s2;
}

struct tm *LIBPREFIX(localtime)(const time_t *clock) {
    LIBPREFIX2(init)("libsocks5");
    S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(12), 0, "SOCKS localtime: FAKE");

    return REAL(localtime)(clock);
}

#ifndef FOR_SHARED_LIBRARY
#ifdef HAVE_STDARG_H
#include <stdarg.h>
#define VA_START(a, b) va_start((a), (b))
#define va_alist ...
#define va_dcl
#else
#include <varargs.h>
#define VA_START(a, b) va_start((a))
#endif

int LIBPREFIX(fprintf)(FILE *fp, const char *format, va_alist) va_dcl {
    char buf[2048];
    va_list pvar;
    int retval, optval;
    int optlen = sizeof(int);
    S5IOHandle sd = fileno(fp);

    VA_START(pvar, format);
    if (getsockopt(fileno(fp), SOL_SOCKET, SO_TYPE, (char *)&optval, &optlen) < 0)
	retval = REAL(vfprintf)(fp, format, pvar);
    else {
	vsprintf(buf, format, pvar);
	retval = LIBPREFIX(write)(sd, buf, strlen(buf));
    }

    va_end(pvar);
    return retval;
}

int LIBPREFIX(vfprintf)(FILE *fp, const char *format, va_list pvar) {
    char buf[2048];
    int optval;
    int optlen = sizeof(int);
    S5IOHandle sd = fileno(fp);

    if (getsockopt(fileno(fp), SOL_SOCKET, SO_TYPE, (char *)&optval, &optlen) < 0)
	return REAL(vfprintf)(fp, format, pvar);
    else {
	vsprintf(buf, format, pvar);
	return LIBPREFIX(write)(sd, buf, strlen(buf));
    }
}

int LIBPREFIX(getc)(FILE *fp) {
    char c;
    int optval;
    int optlen = sizeof(int);
    S5IOHandle sd = fileno(fp);

    if (getsockopt(fileno(fp), SOL_SOCKET, SO_TYPE, (char *)&optval, &optlen) < 0)
	return REAL(getc)(fp);
    else {
	if (LIBPREFIX(read)(sd, &c, 1) != 1) return EOF;
	return (int)c;
    }
}
#endif /* FOR_SHARED_LIBRARY */

