/* Copyright (c) 1996 NEC Corporation.  All rights reserved.                 */
/*                                                                           */
/* The redistribution, use and modification in source or binary forms of     */
/* this software is subject to the conditions set forth in the copyright     */
/* document ("COPYRIGHT") included with this distribution.                   */
#include "socks5p.h"
#include "threads.h"
#include "addr.h"
#include "log.h"

int lsNullSrvAuth(S5IOHandle fd, S5AuthInfo *ainfo, char *name) {
    extern int IdentQuery P((int, char *));
    char *ev = NULL;
    int ival = 0;

#ifndef IN_LIBRARY
    IFTHREADED(extern MUTEX_T env_mutex;)
    ival = IdentQuery(fd, name);

    MUTEX_LOCK(env_mutex);
    ev = getenv("SOCKS5_DEMAND_IDENT");
    MUTEX_UNLOCK(env_mutex);
#endif

    if (ev && ival < 0) return AUTH_FAIL;
    return AUTH_OK;
}

int lsNullCliAuth(S5IOHandle fd, S5AuthInfo *ainfo, char *name) {
    return AUTH_OK;
}
