#ifndef PROTOS_H
#define PROTOS_H

#if defined(sun) && !defined(__svr4__)

extern int sigblock   P((int));
extern int sigsetmask P((int));
    
extern char *inet_ntoa P((struct in_addr));

extern int select      P((int, fd_set *, fd_set *, fd_set *, struct timeval *));

extern IORETTYPE sendto   P((int, const IOPTRTYPE, IOLENTYPE, int, struct sockaddr *, int));
extern IORETTYPE recvfrom P((int,       IOPTRTYPE, IOLENTYPE, int, struct sockaddr *, int *));
extern IORETTYPE send     P((int, const IOPTRTYPE, IOLENTYPE, int));
extern IORETTYPE recv     P((int,       IOPTRTYPE, IOLENTYPE, int));

extern int getdomainname P((char *, int));
extern int getpeername   P((int, struct sockaddr *, int *));
extern int getsockname   P((int, struct sockaddr *, int *));
extern int accept        P((int, struct sockaddr *, int *));

extern int connect P((int, const struct sockaddr *, int));
extern int bind    P((int, const struct sockaddr *, int));

extern int getsockopt P((int, int, int, char *, int *));
extern int setsockopt P((int, int, int, char *, int));

extern int ioctl     P((int, int, ...));
extern int socket    P((int, int, int));
extern int listen    P((int, int));
extern int shutdown  P((int, int));
extern int rresvport P((int *));

extern time_t time   P((time_t *));

extern int openlog   P((char *, int, int));
extern void syslog   P((int, char *, ...));
extern void closelog P(());

extern int gettimeofday P((struct timeval *, struct timezone *));
extern int strncasecmp  P((const char *, const char *, size_t));
extern int ftruncate    P((int, off_t));
extern int bzero        P((char *, int));

extern char **environ;
extern int errno;

#endif
#endif
