/* version.c
   display version information for Xgopher */

     /*---------------------------------------------------------------*/
     /* Xgopher        version 1.3     08 April 1993                  */
     /*                version 1.2     20 November 1992               */
     /*                version 1.1     20 April 1992                  */
     /*                version 1.0     04 March 1992                  */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /* Allan Tuchman, University of Illinois at Urbana-Champaign     */
     /*                Computing and Communications Services Office   */
     /* Copyright 1992, 1993 by                                       */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/


#include <stdio.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Label.h>

#include "osdep.h"
#include "version.h"
#include "gui.h"
#include "xglobals.h"
#include "popres.h"

#define VERSION_SHELL_TITLE	"Xgopher Version Information"


static	Widget		topLevel;
static	Widget		versionShell;
static	Boolean		versionPanelCreated = False;

#define THIS_POPUP_NAME		"versionPopup"

				/* default values */
static popupPosResources	placement = {

	/* position at the top of the main panel, centered across */
	from_main, 50, 0, justify_center, justify_top_left, True, True
	};


void makeVersionPanel();



/* doneProc
   Pop down the version information panel. */

static void
doneProc(w, client_data, call_data)
Widget          w;
XtPointer       client_data, call_data;
{
        XtPopdown(versionShell);
        return;
}


/* versionDoneAction
   Pop down the version information panel. */

static void
versionDoneAction(w, event, parms, nparms)
Widget          w;
XEvent          *event;
String          *parms;
Cardinal        *nparms;
{
        doneProc(w, NULL, NULL);
        return;
}


/* displayVersionPanel
   display the version info panel */

void
displayVersionPanel(top)
Widget	top;
{
	makeVersionPanel(top);

	positionAPopup(versionShell, topLevel, &placement);

	XtPopup (versionShell, XtGrabExclusive);

	return;
}


/* makeVersionPanel
   create the X panel to display version info */

void
makeVersionPanel(top)
Widget	top;
{
	char		**line;
	Arg		args[10];
	Cardinal	n;
	Widget		versionBox;
	Widget		doneButton, versionLabel;
	Dimension	w, h;
	static char		*versionMessage[] = { VERSION_INFO };
	static XtActionsRec     versionActionsTable[] = {
			{ "versionDismiss", (XtActionProc) versionDoneAction }
					};


	if (versionPanelCreated) return;

	topLevel = top;


	/* create Version shell */

		n=0;
		XtSetArg(args[n], XtNtitle, VERSION_SHELL_TITLE);  n++;
	versionShell = XtCreatePopupShell("versionShell",
				transientShellWidgetClass,
				topLevel, args, n);


	/* create Version main panel box */

		n=0;
		XtSetArg(args[n], XtNorientation, XtorientVertical);  n++;
	versionBox  = XtCreateManagedWidget("versionBox",
				boxWidgetClass,
				versionShell, args, n);
	

	/* create label for each line of text */
		/* in this sections, the n args will be set up as:
		     0. borderWidth
		     1. justify
		     :
		     n-2. width
		     n-1. label
		this makes it easier to add resources later. */

	line = versionMessage;
		n=0;
		XtSetArg(args[n], XtNborderWidth, 0); n++;
		XtSetArg(args[n], XtNjustify, XtJustifyCenter);  n++;
		XtSetArg(args[n], XtNlabel, *line); n++;
	versionLabel = XtCreateManagedWidget("versionInfo",
					labelWidgetClass,
					versionBox, args, n);

		/* beware: changing args[n-1] */

		getTextSize(versionLabel, 55, 1, &w, &h);
		XtSetArg(args[n-1], XtNwidth, w);
		XtSetValues(versionLabel, &(args[n-1]), 1);


	line++;
	n++;
	while (*line != NULL) {		/* set lines 2-N of version */

			/* beware: args[n-1] is reset each time! */

			XtSetArg(args[n-1], XtNlabel, *line); 
		versionLabel = XtCreateManagedWidget("versionInfo",
					labelWidgetClass,
					versionBox, args, n);
		line++;

	}

	/* create DONE button */

		n=0;
	doneButton = XtCreateManagedWidget("versionDone",
				commandWidgetClass,
				versionBox, args, n);
	XtAddCallback(doneButton, XtNcallback, doneProc, NULL);


	XtAppAddActions(appcon, versionActionsTable, XtNumber(versionActionsTable));


        /* for ICCCM window manager protocol complience */

        XtOverrideTranslations (versionShell,
            XtParseTranslationTable ("<Message>WM_PROTOCOLS: versionDismiss()"));
        XtRealizeWidget(versionShell);
        (void) XSetWMProtocols (XtDisplay(versionShell), XtWindow(versionShell),
                                    &wmDeleteAtom, 1);


	/* find the popup placement for this shell */

	{
	popupPosResources *resourcePlacement;

	resourcePlacement = getPopupPosResources(
				THIS_POPUP_NAME, POPUP_POS_CLASS, &placement);
	bcopy( (char *) resourcePlacement, (char *) &placement,
				sizeof(popupPosResources) );
	}

	versionPanelCreated = True;
}
