/*
 * Copyright (c) 1993,1995
 *	Texas A&M University.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Texas A&M University
 *	and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Developers:
 *             David K. Hess, Douglas Lee Schales, David R. Safford
 */
#include "fm.h"

void clientInit(unsigned char *pwd,Key *sessionKey,SyncPacket *sync)
{
	unsigned short spinCount;
	Key tempKey;
	Key randKey;
	Key passKey;
	int i;

	/* fprintf(stderr,"called clientInit\n"); */

	/* Initialize the random number generator from the clock. */
	initFromTime(&randKey);

	/* Get random spinCount and sessionKey */
	spinCount = randLong(&randKey) & 0xFFFF;
	spinCount /= 8;

	tempKey.i1 = randLong(&randKey);
	tempKey.i2 = randLong(&randKey);
	tempKey.i3 = randLong(&randKey);

	/* fprintf(stderr,"my key %08X %08X %08X\n",
		tempKey.i1,
		tempKey.i2,
		tempKey.i3);  */

	/* Return tempKey as my half of session key. */
	*sessionKey = tempKey;

	/* Make a working copy of pass key */
	initFromPass(pwd,&passKey);

	/* Get k(r) to send across to server */
	for (i = 0;i < spinCount;++i)
		(void) randByte(&passKey);

	tempKey.i1 ^= randLong(&passKey);
	tempKey.i2 ^= randLong(&passKey);
	tempKey.i3 ^= randLong(&passKey);

	sync->spinCount = htons(spinCount);

	sync->key.i1 = htonl(tempKey.i1);
	sync->key.i2 = htonl(tempKey.i2);
	sync->key.i3 = htonl(tempKey.i3);

	/* Create init message. note: this produces ascii hex */
	/* fprintf(stderr,"%04X %08lX %08lX %08lX\n",spinCount,tempKey.i1,tempKey.i2,tempKey.i3); 
	*/
}

void serverInit(unsigned char *pwd,Key *sessionKey,SyncPacket *sync)
{
	Key passKey;
	int i;

	/* Get info out of init message. note: compatible char set??? */
	/*fprintf(stderr,"received %04X %08lX %08lX %08lX\n", 
		sync->spinCount,
		sync->key.i1,
		sync->key.i2,
		sync->key.i3);  */
	
	/* Decrypt random session key */
	initFromPass(pwd,&passKey);

	for (i = 0;i < ntohs(sync->spinCount);++i)
		(void) randByte(&passKey);

	/* Return the client's half of session key. */
	sessionKey->i1 = ntohl(sync->key.i1) ^ randLong(&passKey);
	sessionKey->i2 = ntohl(sync->key.i2) ^ randLong(&passKey);
	sessionKey->i3 = ntohl(sync->key.i3) ^ randLong(&passKey);

	/* fprintf(stderr,"three rand longs are (spinCount = %d) %08X %08X %08X\n",sync->spinCount,r1,r2,r3); */

	/*fprintf(stderr,"their key %08X %08X %08X\n",
		sessionKey->i1,
		sessionKey->i2,
		sessionKey->i3);  */
}

void buildNewSessionKey(Key *key1,Key *key2,Key *result)
{
	/* fprintf(stderr,"key1 %08lX %08lX %08lX\n",key1->i1,key1->i2,key1->i3); 
	fprintf(stderr,"key2 %08lX %08lX %08lX\n",key2->i1,key2->i2,key2->i3);  */

	/* XOR the two keys together to get a new unique key. */
	result->i1 = key1->i1 ^ key2->i1;
	result->i2 = key1->i2 ^ key2->i2;
	result->i3 = key1->i3 ^ key2->i3;

	/*fprintf(stderr,"%08lX %08lX %08lX\n",result->i1,result->i2,result->i3);  */
}

/* Encrypt or decrypt operation (direction depends on choice of key, which is updated) 

   Note that this routine is still safe it is an in place encryption. */
void potpEncrypt(unsigned char *plain,unsigned char *cipher,Key *k,unsigned short length)
{
	int i;

	for (i = 0;i < length;++i)
		cipher[i] = randByte(k) ^ plain[i];
}

/* Encrypt or decrypt operation (direction depends on choice of key, which is updated) */
void potpDecrypt(unsigned char *cipher,unsigned char *plain,Key *k,unsigned short length)
{
	int i;

	for (i = 0;i < length;++i)
		plain[i] = randByte(k) ^ cipher[i];
}

/* Initialize a key from the provided password. */
void initFromPass(unsigned char *pwd,Key *key)
{
	unsigned char buf[12];
	int i;
	
	/* fprintf(stdout,"%s\n",pwd); */

	memset(buf,0xAA,12);		/* Default fill for key. */
	strncpy(buf,pwd,strlen(pwd) < 12 ? strlen(pwd) : 12);	/* Add up to 12 bytes of pass. */
	
	key->i1 = ntohl(*(unsigned long *) buf);
	key->i2 = ntohl(*(unsigned long *) (buf + 4));
	key->i3 = ntohl(*(unsigned long *) (buf + 8)); 

	/*fprintf(stdout,"i1 = %08lX\n",key->i1); */
	/*fprintf(stdout,"i2 = %08lX\n",key->i2); */
	/*fprintf(stdout,"i3 = %08lX\n",key->i3); */

	/*fprintf(stdout,"i1 = %08lX\n",key->i1); */
	/*fprintf(stdout,"i2 = %08lX\n",key->i2); */
	/*fprintf(stdout,"i3 = %08lX\n",key->i3); */

	/* randomize things. */
	for (i = 0;i < 125;i++)
		(void) randByte(key);

	/*fprintf(stdout,"i1 = %08lX\n",key->i1);
	fprintf(stdout,"i2 = %08lX\n",key->i2); 
	fprintf(stdout,"i3 = %08lX\n",key->i3);  */
}

/* Initialize a key from the clock. */
void initFromTime(Key *key)
{
	int i;

	/* Don't need to worry about byte order here since it is supposed to be random. */
	key->i1 = (rand() << 16) | rand();
	key->i2 = (rand() << 16) | rand();
	key->i3 = (rand() << 16) | rand();
	
	/* Stir awhile. */
	for(i = 0;i < 125;i++)
		(void) randByte(key);
}

/* Given key, return next random unsigned long.
       Note: modifies key */
unsigned long randLong(Key *k)
{
	int i;
	unsigned long result = 0;

	for (i = 0;i < 32;i += 8) 
		result |= (unsigned long) randByte(k) << i;

	return result;
}

/* Given key, return next random byte (as int 0..255)
       Note: modifies key */
unsigned char randByte(Key *k)
{
	int i;
	unsigned char result = 0;

	for (i = 0;i < 8;++i)
		result = (result << 1) | randBit(k);

	return result;	
}

/* Cryptographically strong random bit generator, based on three lfsr.
     Uses "alternating stop-and-go" generator. */
unsigned char randBit(Key *k)
{
	if (lfsr(&k->i1,MASK1))
		lfsr(&k->i2,MASK2);
	else
		lfsr(&k->i3,MASK3);

	return (k->i2 ^ k->i3) & 1;
}

/* Basic random bit generator, using linear feedback shift register */
unsigned char lfsr(unsigned long *i,unsigned long mask)
{
	if (*i & 1) {
		*i = ((*i ^ mask) >> 1) | 0x80000000;
		return(1);
	}
	else {
		*i >>= 1;
		return(0);
	}
}

void initPotp(void)
{
	time_t currTime;

        /* Initialize the random number generator. */
        currTime = time(NULL);
        srand((unsigned short) currTime);
}

