/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991, 1992         	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#include "ospf.h"

#ifdef	PROTO_OSPF

/*
 * parse packet and put on the nbrs link state req list
 */
int
db_parse(dbh, nbr, intf, len)
struct DB_HDR *dbh;
struct NBR *nbr;
struct INTF *intf;
int len;
{
    struct LS_HDR *dbp;
    struct LSDB *db;
    struct AREA *a = AREA_PTR(intf);
    struct LS_HDRQ *lr;
    u_long32 diff;			/* to calculate db elapsed time */
    time_t sec;
    /* MODIFIED 5/24/92 */
    int hash;

    sec = ospf_get_time();		/* get time to check MaxAge */
    if (!LSReqQueueChk(len / DB_PIECE_SIZE))
	return (FLAG_NO_BUFS);
    dbp = &(dbh->dbp);

    for (; len; len -= DB_PIECE_SIZE) {
	/* if we don't have a copy or if nbrs info is newer */
	if (dbp->ls_type < LS_RTR || dbp->ls_type > LS_ASE) {
	    RX_LOG(0, BAD_LSA_TYPE, intf->ifspfndx, nbr->nbrip_addr);
	    (*(nbr_trans[SEQ_MISMATCH][nbr->state])) (intf, nbr);
	    return (1);
	}
	if ((db = FindLSA(a, dbp->ls_id, dbp->adv_rtr, dbp->ls_type)) != LSDBNULL)
	    diff = sec - DB_TIME(db);
	else
	    diff = 0;
	/* MODIFIED 5/24/92 extra noths */
	if (db == LSDBNULL || MORE_RECENT(dbp, &(DB_RTR(db)->ls_hdr), diff)) {
	    /* 
	     * piece is newer or we don't have it - add to list 
	     */
	    /* MODIFIED 5/24/92 */
	    hash = LS_REQ_HASH(dbp->ls_id);
	    LS_REQ_ALLOC(lr);
	    lr->ls_hdr = (*dbp);	/* struct copy */
#ifdef DBG
	    sprintf(_ospf_prt_buf,"setting type to %d",lr->ls_hdr.ls_type);
	    DBG_LOG(_ospf_prt_buf);
#endif
	    lr->ls_hdr.ls_age = htons(dbp->ls_age);
	    ADD_Q((struct LS_HDRQ *)&(nbr->ls_req[hash]), lr);
	    nbr->reqcnt += 1;
	}
	dbp++;
    }
    return (FLAG_NO_PROBLEM);
}

int
RxDb(dbh, intf, ipsrc, rtrid, olen, mc)
struct DB_HDR *dbh;
struct INTF *intf;
u_long32 ipsrc, rtrid;
int olen;
int mc;					/* multicast rx flag */
{
    int 	sched = 0;
    int 	ret = GOOD_RX;
    int 	reqcnt;
    struct 	NBR *n;
    struct 	NBR *nbr = NBRNULL;
    struct 	DB_HDR *d;
    struct 	LSDB_SUM *nextds;
    struct 	LSDB_LIST *txq = LLNULL;
    struct 	AREA *area = AREA_PTR(intf);	/* area received from */

    /* Locate nbr */
    n = FirstNbr(intf);
    if (intf->type > NONBROADCAST) {
	if (n->nbr_id == rtrid)
	    nbr = n;
    } else
	for (; n != NBRNULL; n = n->next) {
	    if (ipsrc == n->nbrip_addr) {
		nbr = n;
		break;
	    }
	}
    if (nbr == NBRNULL)
	return (CANT_FIND_NBR1);

    if (((dbh->options & OPT_E_bit) && (area->ext_option)) ||
	((!(dbh->options & OPT_E_bit)) && (!area->ext_option)))
	return (BAD_DD_E_bit);

    olen -= (OSPF_HDR_SIZE + DB_HDR_SIZE);
    dbh->seq = ntohl(dbh->seq);
    reqcnt = nbr->reqcnt;

    switch (nbr->state) {
	case NDOWN:
	case NATTEMPT:
	    return (LOW_NBR_STATE1);
	case N2WAY:
	    return (GOOD_RX);
	case NINIT:
	    (*(nbr_trans[TWOWAY][nbr->state])) (intf, nbr);
	    /* 
	     * if nbr didn't make it to NEXTSTART chuckit 
	     */
	    if (nbr->state != NEXSTART)
		goto we_are_through;
	    /* 
	     * if forming adjacency continue processing 
	     */
	case NEXSTART:
	    /* if first exchange pkt and this nbr's id is > than ours  */
	    if (((dbh->I_M_MS & (bit_I | bit_M | bit_MS)) && !olen) &&
		ntohl(nbr->nbr_id) > ntohl(MY_ID)) {	/* We are now in SLAVE mode */
		nbr->mode = SLAVE;
		nbr->I_M_MS = 0;
		nbr->seq = dbh->seq;
		(*(nbr_trans[NEGO_DONE][nbr->state])) (intf, nbr);
		/* did we make it to NEXCHANGE? (out of bufs?) */
		if (nbr->state != NEXCHANGE) {
		    nbr->I_M_MS = (bit_I | bit_M | bit_MS);
		    nbr->mode = 0;
		    goto we_are_through;
		}
		/* Slave will send in response */
		send_dbsum(intf,nbr,NOT_RETRANS);
	    } else if ((~dbh->I_M_MS & (bit_I | bit_MS)) &&
		       (nbr->seq == dbh->seq) &&
		       (ntohl(nbr->nbr_id) < ntohl(MY_ID))) {
		/* check to see if it was an ack (we are master) */
		nbr->mode = MASTER;
		nbr->I_M_MS = bit_MS;	/* set to master */
		(*(nbr_trans[NEGO_DONE][nbr->state])) (intf, nbr);
		/* did we make it to NEXCHANGE? (out of bufs?) */
		if (nbr->state != NEXCHANGE) {
		    nbr->I_M_MS = (bit_I | bit_M | bit_MS);
		    nbr->mode = 0;
		    goto we_are_through;
		}
		if (olen) {
		    if (db_parse(dbh, nbr, intf, olen))	/* out of bufs */
			goto we_are_through;
		}
		nbr->seq += 1;
		send_dbsum(intf, nbr, 0);
	    } else if (nbr->nbr_id == MY_ID) {
		ret = BAD_RTRID;
		goto we_are_through;
	    }
	    break;

	case NEXCHANGE:
	    /* check for master mismatch */
	    /* MODIFIED */
#ifdef DBG
	    sprintf(_ospf_prt_buf,"<<<<>>>> %d %d %d %d %x\n",
	    		(dbh->I_M_MS & bit_MS),
	    		(nbr->mode == MASTER),
	    		((dbh->I_M_MS & bit_MS) == (nbr->mode == MASTER)),
	     		(dbh->I_M_MS & bit_I),dbh->I_M_MS);
	    DBG_LOG(_ospf_prt_buf);
#endif
	    if ((((dbh->I_M_MS & bit_MS) == bit_MS) == (nbr->mode == MASTER)) ||
		(dbh->I_M_MS & bit_I)) {
		DBG_LOG("<<<>>> calling SEQ_MISMATCH!!\n");
		(*(nbr_trans[SEQ_MISMATCH][nbr->state])) (intf, nbr);
		goto we_are_through;
	    }
	    if (nbr->mode == MASTER) {
		if (nbr->seq == dbh->seq) {
		    if (nbr->dbsum == LSDB_SUM_NULL)
			d = (struct DB_HDR *) 0;
		    else
			d = &(nbr->dbsum->dbpkt->un.database);

		    /* if it's SLAVE's last and my last */
		    nbr->seq += 1;
		    /* parse packet and put on the nbrs link state req list */
		    if (olen) {
			if (db_parse(dbh, nbr, intf, olen))
			    goto we_are_through;
		    }
		    if ((~dbh->I_M_MS & bit_M) &&	/* slave's last */
			(d != (struct DB_HDR *) 0) &&	/* pkts left */
			((~(d->I_M_MS) & bit_M))) {
			/* then, we're up to loading state */
			(*(nbr_trans[EXCH_DONE][nbr->state])) (intf, nbr);
			goto we_are_through;
		    }
		    /* free head of list f more bit was set */
		    if ((d != (struct DB_HDR *) 0) &&
			(d->I_M_MS & bit_M)) {
			/* One less dbsum pkt */
			nbr->dbcnt -= nbr->dbsum->cnt;
			nextds = nbr->dbsum->next;
			DB_ZAP_PKT(nbr->dbsum);
			ZAP(nbr->dbsum, OMEM_DBSUM);
			nbr->dbsum = nextds;
		    }
		    send_dbsum(intf, nbr, 0);

		} else if (nbr->seq - 1 != dbh->seq) {
		    (*(nbr_trans[SEQ_MISMATCH][nbr->state])) (intf, nbr);
		}
	    } else {			/* we are in SLAVE mode  */
		if (nbr->seq + 1 == dbh->seq) {
		    nbr->seq = dbh->seq;

		    /* remove last sent */
		    if (nbr->dbsum != (struct LSDB_SUM *) 0) {
			/* One less dbsum pkt */
			nbr->dbcnt -= nbr->dbsum->cnt;
			nextds = nbr->dbsum->next;
			DB_ZAP_PKT(nbr->dbsum);
			ZAP(nbr->dbsum, OMEM_DBSUM);
			nbr->dbsum = nextds;
		    }
		    if (nbr->dbsum != (struct LSDB_SUM *) 0)
			d = &(nbr->dbsum->dbpkt->un.database);
		    else
			d = (struct DB_HDR *) 0;

		    /* 
	 	     * if it's MASTER's last and my last 
		     */
		    if ( (~dbh->I_M_MS & bit_M) &&	  /* master's last */
			 ((d == (struct DB_HDR *) 0) || /* no pkts left */
			 (~d->I_M_MS & bit_M)) )	/* my more bit is off */
			sched++;	/* schedule an exchange done event */

		    if (db_parse(dbh, nbr, intf, olen))	/* run out of bufs */
			goto we_are_through;
		    send_dbsum(intf, nbr, 0);

		    if (sched) {	/* up to loading state */
			(*(nbr_trans[EXCH_DONE][nbr->state])) (intf, nbr);
		    }
		} else if (nbr->seq == dbh->seq)
		    send_dbsum(intf, nbr, 0);
		else {
		    (*(nbr_trans[SEQ_MISMATCH][nbr->state])) (intf, nbr);
		}
	    }
	    break;

	case NLOADING:
	case NFULL:
	    if (nbr->mode == SLAVE_HOLD && nbr->seq == dbh->seq)
		/* haven't timed out yet */
		send_dbsum(intf, nbr, 0);
	    else if ((nbr->mode == MASTER && nbr->seq - 1 == dbh->seq) ||
		     (nbr->mode == SLAVE && nbr->seq == dbh->seq))
		goto we_are_through;
	    else {
		(*(nbr_trans[SEQ_MISMATCH][nbr->state])) (intf, nbr);
	    }

	    break;
    }

  we_are_through:

    if (intf->nbr_change) {
	/* MODIFIED 2/7/92 */
	(*(if_trans[intf->nbr_change][intf->state])) (intf);
    }
    /* build net and rtr lsa if necessary */
    if (intf->build_net) {
	area->spfsched |= build_net_lsa(intf, &txq, 0);
	intf->build_net = FALSE;
    }
    if (area->build_rtr) {
	area->spfsched |= build_rtr_lsa(area, &txq, 0);
	area->build_rtr = FALSE;
    }
    if (txq != LLNULL) {		/* may be locked out */
	self_orig_area_flood(area, txq, LS_RTR);
	ospf_freeq(&txq, OMEM_LL);
    }
    if (area->spfsched)
	RX_RUN_SPF(area);

    /* Can we send req pkt? */
    if ((nbr->state >= NEXCHANGE) &&
	(reqcnt == 0) &&
	(nbr->reqcnt > 0))
	send_req(intf, nbr, 0);

    return (ret);
}

#endif				/* PROTO_OSPF */
