/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991               	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#ifndef OSPF_PORT_H
#define OSPF_PORT_H

#define __OSPF_D

#ifdef __OSPF_D
#include <fcntl.h>
#include <errno.h>
#include <syslog.h>

#include <sys/signal.h>
#include <sys/param.h>
#ifdef TAHOE
#include <machine/endian.h>
#endif
#include <sys/file.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <sys/socket.h>

#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>
#include <net/if.h>
#include <net/route.h>

#ifdef BSD_TEST
#include <sys/kinfo.h>
#endif

extern int errno;
extern int sys_nerr;
extern char *sys_errlist[];

#define	strerror(errno)	((errno < sys_nerr) ? sys_errlist[errno] : "Invalid errno")

#define	PROTO_OSPF
#ifndef UMBC_SIM
#include "ospf_log.h"			/* log macros */
#endif
#include "ospf_mem.h"			/* port specific rtab stuff */
#include "ospf_port_rtab.h"		/* port specific rtab stuff */
#include "../avl/ort_avl.h"		/* AVL tree routing table */
#include "../ospf_timerq.h"		/* timerq defines */
#include "ospf_mib.h"			/* port specific mib stuff */



/* configuration table structure */
struct CONF {
    char *in;
    void (*routine) ();
};


#define ifspfNETNUM(NDX)\
	(IF_NDX[NDX].ifip_addr & IF_NDX[NDX].ifip_mask)

#define NDX_NET_NUM(NDX)\
	ifspfNETNUM(NDX)

#define IntfNETNUM(I)\
	(IF_NDX[(I)->ifspfndx].ifip_addr & IF_NDX[(I)->ifspfndx].ifip_mask)

#define INTF_NETNUM(I)\
	(IF_NDX[(I)->ifspfndx].ifip_addr & IF_NDX[(I)->ifspfndx].ifip_mask)

#define INTF_STATUS_CHANGE(I)\
	(((I)->state != IDOWN) != (ospf_ifchk((I)->ifspfndx)))

/*
 * start time
 */
time_t ospf_start_time;

#endif

#ifndef	__STDC__
#define	const
#endif	/* __STDC__ */

typedef struct ip IP_HDR;

#ifndef UMBC_SIM
#define iologfp ospf.logfp
#define dumpfp 	ospf.dmpfp
#endif

#ifndef IPPROTO_OSPF
#define IPPROTO_OSPF 89
#endif				/* IPPROTO_OSPF */

#ifndef TRUE
#define TRUE	1
#endif
#ifndef FALSE
#define FALSE	0
#endif


/*
 * Structure access
 */
#define ifspfIF(I)\
	ospf.area[IF_NDX[I].area_ndx].intf[IF_NDX[I].if_ndx]

#define ifspfAREA(I)\
	ospf.area[IF_NDX[I].area_ndx]

#define AREA_PTR(I)\
	((I)->type == VIRTUAL_LINK) ? ospf.area : &(ifspfAREA((I)->ifspfndx))


extern char *ospf_ctime;
extern void ospf_bye();
extern void close_socks();

/* A few things to set when porting to non-BSD based systems */
#ifdef NOTDEF
#define htons(X) (X)
#define htonl(X) (X)
#define ntohl(X) (X)
#define ntohs(X) (X)
#define fileno(T)   1
typedef long time_t;

#endif

/*
 * set in tqhandle and rxpkt
 */
time_t ospf_global_tod;

struct timezone _otz;
struct timeval _otv;

char *ospf_ctime;

#define s2c(S)	(ctime(S))		/* secondes to char */

/*
 * Convert global_tod to char string
 */
#define ospf_get_ctime() ospf_ctime

#ifndef UMBC_SIM

#define ospf_get_sys_time() {\
		QueueChkReset;\
		gettimeofday(&_otv,&_otz);\
		ospf_ctime = s2c(&(_otv.tv_sec));\
		ospf_global_tod = ( _otv.tv_sec);\
		sprintf(_ospf_prt_buf,"\nTIME: %d",ospf_global_tod);\
		DBG_LOG(_ospf_prt_buf);}

#define ospf_get_time() ospf_global_tod

#define SEC_SET(T)  	(T)->set
#define SEC_RESET(T)  	(T)->reset

#define TMR_SUB(T1,T2) 	((T1)->set = (T1)->set - (T2)->set)
#define TMR_CMP(T1,T2) 	((T1)->set > (T2)->set)

#define	MASKALRM sigmask(SIGALRM)

/*
 * Set system timer
 */
#define sys_timer_set(T) {\
	struct	itimerval __CLEAR, __SET_TIME;\
	CLEAR_BUF(&__CLEAR,sizeof(struct itimerval));\
	CLEAR_BUF(&__SET_TIME,sizeof(struct itimerval));\
	__SET_TIME.it_value.tv_sec = SEC_SET(T);\
	signal(SIGALRM,tqhandler);\
	setitimer(ITIMER_REAL,&(__SET_TIME),&__CLEAR);}
#endif

#define MAXIF	15			/* maxium number of interfaces less other open files */

/*
 *	OSPF/IP Interface index structure
 */
struct IFSPF {
#ifdef __OSPF_D
    struct sockaddr_in sin;
    struct sockaddr_in mask;
    char ifip_name[IFNAMSIZ];
    int fd;				/* used with FD_* in types.h */
#define	ifip_addr	sin.sin_addr.s_addr	/* interface's addr */
#define	ifip_mask	mask.sin_addr.s_addr
#endif
    /* use indices 'cause realloc may change memory location [conf()] */
    u_short16 area_ndx;			/* area index */
    u_short16 if_ndx;			/* if index */
    int disable;			/* interface administrative disable */
}

#ifndef UMBC_SIM
 ifspf[MAXIF];

#define IF_NDX		ifspf
#endif

/*
 * for now max out, if virtual link have it be something link 512
 */
#define		INTF_MTU(I)	MAXOUT
/*
#define	INTF_MTU(I)\
	(((I)->type == VIRTUAL_LINK) ? MAXOUT :\
		((IF_NDX[(I)->ifspfndx].ifip_mtu) - 60))
*/

#define NDX_IP_ADDR(I) 	IF_NDX[(I)].ifip_addr
#define NDX_IP_MASK(I) 	IF_NDX[(I)].ifip_mask
#define NDX_DISABLE(I)	IF_NDX[(I)].disable

#define TCP_MCONNECT(PORT,SRC) monconnect(PORT,SRC)
#define IP_PROTOCOL(IP) (IP)->ip_p
#define IP_LENGTH(IP) 	(IP)->ip_len
#endif
