/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991               	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#define SUN

#ifndef UMBC_SIM

#include "../ospf.h"

#ifdef	PROTO_OSPF

extern int K;				/* fd for adding and deleting kernel routes */

#ifdef NO_IFF_MULTICAST
extern int M;				/* fd for receiving multicast */

#endif

int vs;					/* socket for checking if intf is up */

extern int errno;


#ifdef NO_IFF_MULTICAST

/*
 * Remove M from groups
 */
void
disable_mcast_rx()
{

    struct ip_mreq mreq;		/* membership request */

    if (!M)
	return;				/* no multicast interfaces configured */
    /* Enable receiving to address AllSpfRouters */
    mreq.imr_multiaddr.s_addr = AllSPFRouters;
    mreq.imr_interface.s_addr = INADDR_ANY;
    if (setsockopt(M, IPPROTO_IP, IP_DROP_MEMBERSHIP,
		   &mreq, sizeof(mreq)) < 0)
	ciao("ospfsock: setsockopt IP_DROP_MEMBERSHIP failed\n");

    mreq.imr_multiaddr.s_addr = AllDRouters;
    if (setsockopt(M, IPPROTO_IP, IP_DROP_MEMBERSHIP, &mreq, sizeof(mreq)) < 0)
	ciao("ospfsock: setsockopt IP_DROP_MEMBERSHIP failed \n");
}

/*
 * Initialize Multicast rx socket
 */
void
enable_mcast_rx()
{

    struct ip_mreq mreq;		/* membership request */

    /* create a raw Multicast socket */
    if ((M = socket(AF_INET, SOCK_RAW, IPPROTO_OSPF)) < 0) {
#ifdef	TEST
	perror("> multicast: socket(AF_INET, SOCK_RAW) fails");
#endif
	exit(1);
    }
    /* Enable receiving to address AllSpfRouters */
    mreq.imr_multiaddr.s_addr = AllSPFRouters;
    mreq.imr_interface.s_addr = INADDR_ANY;
    if (setsockopt(M, IPPROTO_IP, IP_ADD_MEMBERSHIP,
		   &mreq, sizeof(mreq)) < 0)
	ciao("ospfsock: setsockopt IP_ADD_MEMBERSHIP failed\n");

    mreq.imr_multiaddr.s_addr = AllDRouters;
    if (setsockopt(M, IPPROTO_IP, IP_ADD_MEMBERSHIP, &mreq, sizeof(mreq)) < 0)
	ciao("ospfsock: setsockopt IP_ADD_MEMBERSHIP failed \n");
}

void
enable_mcast_tx(ndx)
int ndx;
{
    u_char loop = 0;

    /* enable multicast transmit */
    if (setsockopt(IF_NDX[ndx].fd, IPPROTO_IP, IP_MULTICAST_IF,
	(char *) &(IF_NDX[ndx].ifip_addr), sizeof(struct in_addr)) < 0) {
	sprintf(_ospf_prt_buf, "setsockopt IP_MULTICAST_IF failed %s\n",
		lntoa(IF_NDX[ndx].ifip_addr));
	OSPF_LOG(_ospf_prt_buf);
	exit(1);
    }
    /* turn off loopback */
    if (setsockopt(IF_NDX[ndx].fd, IPPROTO_IP, IP_MULTICAST_LOOP,
		   &loop, sizeof(loop)) < 0) {
	sprintf(_ospf_prt_buf, "setsockopt IP_MULTICAST_LOOP failed %s\n",
		lntoa(IF_NDX[ndx].ifip_addr));
	OSPF_LOG(_ospf_prt_buf);
	exit(1);
    }
}

#endif
#ifdef NOTDEF

/*
 *	printsock: prints the socket configuration information
 */
void
printsock()
{
    int i, cc, val;
    char foo[10];

    sprintf(_ospf_prt_buf,"Sockets created:\n");
    OSPF_LOG(_ospf_prt_buf);
    for (i = 0; i < ospf.nintf; i++) {
	sprintf(_ospf_prt_buf,"     %d: %s fd:%d addr:%s mask:%x ",
	       i, IF_NDX[i].ifip_name, IF_NDX[i].fd,
	       lntoa(IF_NDX[i].ifip_addr),
	       ntohl(IF_NDX[i].ifip_mask));
	OSPF_LOG(_ospf_prt_buf);
	cc = sizeof(val);

#ifdef SUN
	if (getsockopt(ifspf[0].fd, SOL_SOCKET, IP_ALLOWBROADCAST,
		       (char *) &val, &cc)) {
	    perror("getsockopt");
	    exit(1);
	}
#else
	if (getsockopt(IF_NDX[0].fd, SOL_SOCKET, SO_BROADCAST,
		       (char *) &val, &cc)) {
	    perror("getsockopt");
	    exit(1);
	}
#endif
	cc = sizeof(val);
	if (getsockopt(IF_NDX[0].fd, SOL_SOCKET, SO_RCVBUF,
		       (char *) &val, &cc)) {
	    perror("getsockopt");
	    exit(1);
	}
	sprintf(_ospf_prt_buf,"                   sockbuf size:%d ", val);
	OSPF_LOG(_ospf_prt_buf);
	sprintf(_ospf_prt_buf,"area:%d\n", ifspfAREA(i).area_id);
	OSPF_LOG(_ospf_prt_buf);
    }

    for (i = 0; i < ospf.nintf; i++) {
	sprintf(_ospf_prt_buf, "Read fd %d.. ", IF_NDX[i].fd);
	OSPF_LOG(_ospf_prt_buf);
	cc = read(IF_NDX[i].fd, foo, 10);
	sprintf(_ospf_prt_buf, " returns %d ", cc);
	OSPF_LOG(_ospf_prt_buf);
	perror("read errno");
    }
}

#endif

/*
 * check the interface type params to see if everything looks reasonable
 */
void
iftypechk(ifndx, ifreq)
short ifndx;
struct ifreq *ifreq;
{


#ifdef NOTDEF
    if (ifreq->ifr_flags & IFF_LOOPBACK) {
	sprintf(_ospf_prt_buf, "ospf: IF %s is defined by machine to be loopback\n",
		lntoa(IF_NDX[ifndx].ifip_addr));
	OSPF_LOG(_ospf_prt_buf);
#ifndef TEST
	exit(1);
#endif
    }
#endif

    if ((ifspfIF(ifndx).type == POINT_TO_POINT) &&
	(!(ifreq->ifr_flags & IFF_POINTOPOINT))) {
	sprintf(_ospf_prt_buf, "ospf: IF %s not defined by machine to be point-to-point\n",
		lntoa(IF_NDX[ifndx].ifip_addr));
	OSPF_LOG(_ospf_prt_buf);
#ifndef TEST
	exit(1);
#endif
    }
#ifdef NO_IFF_MULTICAST
    if ((ifspfIF(ifndx).type == BROADCAST) &&
	(!(ifreq->ifr_flags & IFF_MULTICAST))) {
	sprintf(_ospf_prt_buf,"ospfsock: IF %s not configured to be multicast\n",
		lntoa(IF_NDX[ifndx].ifip_addr));
	OSPF_LOG(_ospf_prt_buf);
#ifndef TEST
	exit(1);
#endif
    }					/* multicast */
#endif
    if ((ifspfIF(ifndx).type == NONBROADCAST) &&
#ifdef NO_IFF_MULTICAST
	ifreq->ifr_flags & IFF_MULTICAST ||
#endif
	ifreq->ifr_flags & IFF_POINTOPOINT) {
	sprintf(_ospf_prt_buf, "ospf: IF %s is defined by machine to be broadcast or point-to-point\n",
		lntoa(IF_NDX[ifndx].ifip_addr));
	OSPF_LOG(_ospf_prt_buf);
#ifndef TEST
	exit(1);
#endif
    }
}



/*
 *  Grab interface configuration, and create a socket for each machine
 *  interface address and bind them to an ospfigp interface
 *
 */
void
create_sockets()
{
    char buf[1024];
    struct ifconf ifc;
    struct ifreq ifreq, *ifr;
    int n, i;
    int gotcnt = 0;			/* cnt of machine interfaces matching config */
    int ifndx = 0;


    /* Create socket for getting if information */
    if ((vs = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
#ifdef	TEST
	perror("vs=socket(AF_INET, SOCK_DGRAM)");
#endif
	exit(1);
    }
    ifc.ifc_len = sizeof(buf);
    ifc.ifc_buf = buf;
    if (ioctl(vs, SIOCGIFCONF, (char *) &ifc) < 0) {
#ifdef	TEST
	perror("spfconf: ioctl(SIOCGIFCONF) fails");
#endif
	exit(1);
    }
    n = ifc.ifc_len / sizeof(struct ifreq);

    /* Get interface info from ifc */
    for (ifr = ifc.ifc_req; n > 0 && gotcnt != ospf.nintf; n--, ifr++) {
	if (ifr->ifr_addr.sa_family != AF_INET)
	    continue;
	ifreq = *ifr;

	/* first find configured addr that matches machine if */
	if (ioctl(vs, SIOCGIFADDR, (char *) &ifreq) < 0) {
#ifdef	TEST
	    perror("ospf: SIOCGIFADDR fails");
	    sprintf(_ospf_prt_buf, "addr: %s\n",
		    lntoa((*(struct sockaddr_in *) & ifreq.ifr_addr).sin_addr.s_addr));
	    OSPF_LOG(_ospf_prt_buf);
#endif
	    continue;
	}
#ifdef TEST
	else {
#ifdef PRINTCONF
	    sprintf(_ospf_prt_buf,"ospf: SIOCGIFADDR passed if: %s\n",
		   lntoa((*(struct sockaddr_in *) & ifreq.ifr_addr).sin_addr.s_addr));
	    OSPF_LOG(_ospf_prt_buf);
#endif
	}
#endif
	ifndx = 0;
	while (IF_NDX[ifndx].ifip_addr !=
	    (*(struct sockaddr_in *) & ifreq.ifr_addr).sin_addr.s_addr) {
	    if (ifndx == ospf.nintf) {
#ifdef PRINTCONF
		sprintf(_ospf_prt_buf,"ospf: No spf configuration for interface %s\n",
		       lntoa((*(struct sockaddr_in *) & ifreq.ifr_addr).sin_addr.s_addr));
		OSPF_LOG(_ospf_prt_buf);
#endif
		break;
	    } else
		ifndx++;
	}

	/* if we're not configured for or we already have
			 this if continue */
	if (ifndx == ospf.nintf || strlen(IF_NDX[ifndx].ifip_name))
	    continue;
	gotcnt++;
	if (ioctl(vs, SIOCGIFFLAGS, (char *) &ifreq) < 0) {
#ifdef	TEST
	    perror("ospf: SIOCGIFFFLAGS fails");
#endif
	    continue;
	}
	strncpy(IF_NDX[ifndx].ifip_name, ifreq.ifr_name, IFNAMSIZ);
#ifdef PRINTCONF
	sprintf(_ospf_prt_buf,"Name = %s ndx = %d\n", ifreq.ifr_name, ifndx);
	OSPF_LOG(_ospf_prt_buf);
#endif

	if ((ifreq.ifr_flags & IFF_UP) == 0) {	/* IF is down (oh no!) */
	    sprintf(_ospf_prt_buf, "ospf: IF %s is down (oh no!)\n",
		    IF_NDX[ifndx].ifip_name);
	    OSPF_LOG(_ospf_prt_buf);
	}
	iftypechk(ifndx, &ifreq);
	if (ioctl(vs, SIOCGIFNETMASK, (char *) &ifreq) < 0) {
#ifdef	TEST
	    perror("SIOCGIFNETMASK fails");
#endif
	    exit(1);
	}
	IF_NDX[ifndx].mask = *(struct sockaddr_in *) & ifreq.ifr_addr;
    }

    if (gotcnt != ospf.nintf) {
	sprintf(_ospf_prt_buf, "Intfs are not on machine: (ifs %d nintf %d)\n",
		gotcnt, ospf.nintf);
	OSPF_LOG(_ospf_prt_buf);
	exit(1);
    }
    /* Bind the sockets to the interfaces configured in IF_NDX[] */
    for (i = ospf.nintf - 1; i >= 0; i--) {
	/* create a raw ospf socket */
	if ((IF_NDX[i].fd = socket(AF_INET, SOCK_RAW, IPPROTO_OSPF)) < 0) {
	    perror(">OSPF: socket(AF_INET, SOCK_RAW) fails");
	    exit(1);
	}
	/*
         * set non-blocking I/O on the descriptor
         */
	if (fcntl(IF_NDX[i].fd, F_SETFL, FNDELAY) < 0) {
	    perror("fcntl(F_SETFL, FNDELAY) fails");
	    exit(1);
	}
#ifdef NO_IFF_MULTICAST
	if (ifspfIF(i).type == BROADCAST ||
	    ifspfIF(i).type == POINT_TO_POINT) {
	    if (!M)
		enable_mcast_rx();
	    enable_mcast_tx(i);
	}
#endif
	/*
         * finally, bind the local address
         */
	IF_NDX[i].sin.sin_family = AF_INET;
	IF_NDX[i].sin.sin_port = 0;
#ifdef BSD_TEST
	IF_NDX[i].sin.sin_len = sizeof(struct sockaddr_in);
#endif
	bzero(IF_NDX[i].sin.sin_zero, 8);

	if (bind(IF_NDX[i].fd, (struct sockaddr *) & (IF_NDX[i].sin),
		 sizeof(IF_NDX[i].sin)) < 0) {
	    perror("bind fails");
	    sprintf(_ospf_prt_buf, "Failed name: %s errno: %d\n",
		    IF_NDX[i].ifip_name, errno);
	    OSPF_LOG(_ospf_prt_buf);
	    sprintf(_ospf_prt_buf, "family %d port %x addr %s\n",
		    (struct sockaddr_in *) IF_NDX[i].sin.sin_family,
		    (struct sockaddr_in *) IF_NDX[i].sin.sin_port,
		    lntoa(IF_NDX[i].ifip_addr));
	    OSPF_LOG(_ospf_prt_buf);
	    exit(1);
	}
    }

/*
	printsock();
*/
}

#endif				/* PROTO_OSPF */

#endif
