/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991               	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software not be misrepresented, either by          *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Rob Coltun 				          	       *
*		Computer Science Ctr.					       *
*		University Of Maryland					       *
*		College Park, Maryland 20472				       *
*		(301) 405-2990						       *
*		rcoltun@umd5.umd.edu 					       *
*									       *
*******************************************************************************/

#include "../ospf.h"

#ifdef	PROTO_OSPF

extern char *lntoa();
extern char *logtype[];
extern char *IfStates[];
extern char *NbrStates[];

int dump = 10;
u_long32 ospf_log_flags = (DEFAULT_LOG_FLAGS | OSPF_PKT_LOG);


const char *nbr_modes[5] =
{"None  ",
 "Slave ",
 "Master",
 "Null  ",
 "Hold  "};

const char *if_types[] =
{"Bcast",
 "NBMA",
 "PtoP",
 "Virt"};

const char *ls_types[] =
{"STUB",
 "RTR",
 "NET",
 "SUM_NET",
 "SUM_ASB",
 "ASE"};

const char *paths[] =
{"STUB",
 "RTR ",
 "INT ",
 "SUM ",
 "SUM ",
 "EXT"};

const char *con_types[] =
{"Router",
 "Transit net",
 "Stub net",
 "Virtual"};


/*
 * Print the retran list of lsdbs held by all nbrs associated with this intf
 */
void
print_nbr_retrans(intf)
struct INTF *intf;
{
    struct NBR *n;
    struct DBRT_LIST *ll;

    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));

    for (n = FirstNbr(intf); n != NBRNULL; n = n->next) {
	if (n->retrans) {
	    sprintf(_ospf_prt_buf, "Nbr %s retrans list:\n",
		    lntoa(n->nbrip_addr));
	    MON_WRITE(_ospf_prt_buf);
	    /* remove from all nbrs' lists */
	    for (ll = n->retrans; ll != DBRTNULL; ll = ll->ptr[NEXT]) {
		if (NO_GUTS(ll->lsdb))
		    continue;
		sprintf(_ospf_prt_buf, "  type %s  %s %s\n",
			ls_types[LS_TYPE(ll->lsdb)],
			lntoa(ll->lsdb->key[0]),
			lntoa(ll->lsdb->key[1]));
		MON_WRITE(_ospf_prt_buf);
	    }
	}
    }
}

/*
 * Print the retran list of nbrs held by this lsdb structure
 */
void
print_db_retrans(db)
struct LSDB *db;
{
    struct NBR_LIST *nl;

    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
    if (DB_RETRANS(db)) {
	sprintf(_ospf_prt_buf, "retrans list:\n");
	MON_WRITE(_ospf_prt_buf);
	for (nl = DB_RETRANS(db); nl != NLNULL; nl = nl->ptr[NEXT]) {
	    sprintf(_ospf_prt_buf, "       nbr: %-16s\n",
		    lntoa(nl->nbr->nbrip_addr));
	    MON_WRITE(_ospf_prt_buf);
	}
    }
}

/*
 * Show the link-state data base for this area
 */
void
lsdbdump(retrans)
long retrans;
{
    struct AREA *a;
    struct LSDB *e, *hp;
    int type;
    time_t sec;

    sec = ospf_get_time();		/* get time to check MaxAge */
    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
    sprintf(_ospf_prt_buf, "LS Data Base:\n");
    MON_WRITE(_ospf_prt_buf);

    sprintf(_ospf_prt_buf,
	    "Area         LS Type Link ID       Adv Rtr       Age  Len Seq #    Metric\n");
    MON_WRITE(_ospf_prt_buf);

    sprintf(_ospf_prt_buf, 
	    "-------------------------------------------------------------------------------\n");
    MON_WRITE(_ospf_prt_buf);

    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
    for (a = FirstArea; a < &ospf.area[ospf.acnt]; a++) {
	for (type = LS_STUB; type < LS_ASE; type++) {
	    for (hp = a->htbl[type]; hp < &(a->htbl[type][HTBLSIZE]); hp++) {
		for (e = hp; (DB_NEXT(e) != LSDBNULL); e = DB_NEXT(e)) {
		    /* check to see if it is valid */
		    if (NO_GUTS(DB_NEXT(e)))
			continue;
		    sprintf(_ospf_prt_buf, "%-12s %-7s %-13s %-13s %-4d %-3d %-8x %-6d\n",
			    lntoa(a->area_id),
			    ls_types[type],
			    lntoa(DB_NEXT(e)->key[0]),
			    lntoa(DB_NEXT(e)->key[1]),
			    (ADV_AGE(DB_NEXT(e), sec) < MaxAge) ?
			    (ADV_AGE(DB_NEXT(e), sec)) : MaxAge,
			    ntohs(LS_LEN(DB_NEXT(e))),
			    ntohl(LS_SEQ(DB_NEXT(e))),
			    LS_TYPE(DB_NEXT(e)) < LS_SUM_NET ?
			    0 : BIG_METRIC(DB_NEXT(e)));
		    MON_WRITE(_ospf_prt_buf);
		    if (retrans)
			print_db_retrans(DB_NEXT(e));
		    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
		}
	    }
	}
    }
    /* Print AS External LSDB */
    a = FirstArea;
    for (hp = a->htbl[LS_ASE]; hp < &(a->htbl[LS_ASE][HTBLSIZE]); hp++) {
	for (e = hp; (DB_NEXT(e) != LSDBNULL); e = DB_NEXT(e)) {
	    /* check to see if it is valid */
	    if (NO_GUTS(DB_NEXT(e)))
		continue;
	    sprintf(_ospf_prt_buf, "%-12s %-7s %-13s %-13s %-4d %-3d %-8x %-6d\n",
		    lntoa(a->area_id),
		    ls_types[LS_ASE],
		    lntoa(DB_NEXT(e)->key[0]),
		    lntoa(DB_NEXT(e)->key[1]),
		    (ADV_AGE(DB_NEXT(e), sec) < MaxAge) ?
		    (ADV_AGE(DB_NEXT(e), sec)) : MaxAge,
		    ntohs(LS_LEN(DB_NEXT(e))),
		    ntohl(LS_SEQ(DB_NEXT(e))),
		    BIG_METRIC(DB_NEXT(e)));
	    MON_WRITE(_ospf_prt_buf);
	    if (retrans)
		print_db_retrans(DB_NEXT(e));
	}
	CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
    }
}

/*
 * Print configured interfaces and their status
 */
void
showifs()
{
    int i;
    struct AREA *a;
    struct INTF *intf;

    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
    sprintf(_ospf_prt_buf, "Area       IP Address    Type  State    Cost Pri DR            BDR\n");
    MON_WRITE(_ospf_prt_buf);

    sprintf(_ospf_prt_buf, "-------------------------------------------------------------------------------\n");
    MON_WRITE(_ospf_prt_buf);

    for (a = ospf.area; a < &(ospf.area[ospf.acnt]); a++)
	for (i = 0; i < a->ifcnt; i++) {
	    intf = &(a->intf[i]);
	    sprintf(_ospf_prt_buf, "%-10s %-13s %-5s %-8s %-4d %-3d %-13s %-13s\n",
		    lntoa(a->area_id),
		    lntoa(NDX_IP_ADDR(intf->ifspfndx)),
		    if_types[intf->type - 1],
		    IfStates[intf->state],
		    intf->cost,
		    intf->pri,
		    (intf->dr) ? lntoa(intf->dr->nbrip_addr) : "None",
		    (intf->bdr) ? lntoa(intf->bdr->nbrip_addr) : "None");
	    MON_WRITE(_ospf_prt_buf);
	}

    if (ospf.vcnt)	/* print virtual links */
	for (i = 0; i < ospf.vcnt; i++) {
	    sprintf(_ospf_prt_buf, "%-10s %-13s %-5s %-8s %-4d %-3d %-13s %-13s\n",
		    "0.0.0.0",
		    lntoa(NDX_IP_ADDR(ospf.vl[i].ifspfndx)),
		    if_types[ospf.vl[i].type - 1],
		    IfStates[ospf.vl[i].state],
		    ospf.vl[i].cost,
		    "None",
		    "None");
	    MON_WRITE(_ospf_prt_buf);
	}
}

/*
 * Show current neigbors and their status
 */
void
shownbrs(retrans)
int retrans;
{
    int i;
    struct AREA *a;
    struct INTF *intf;
    struct NBR *n;

    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
    sprintf(_ospf_prt_buf, "Area       Interface     Router Id     Nbr IP Addr   State      Mode   Pri\n");
    MON_WRITE(_ospf_prt_buf);

    sprintf(_ospf_prt_buf, "-------------------------------------------------------------------------------\n");
    MON_WRITE(_ospf_prt_buf);

    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
    for (a = ospf.area; a < &(ospf.area[ospf.acnt]); a++)
	for (i = 0; i < a->ifcnt; i++) {
	    intf = &a->intf[i];
	    for (n = FirstNbr(intf); n != NBRNULL; n = n->next) {
		sprintf(_ospf_prt_buf, "%-10s %-13s %-13s %-13s %-10s %-6s %-4d\n",
			lntoa(a->area_id),
			lntoa(NDX_IP_ADDR(intf->ifspfndx)),
			lntoa(n->nbr_id),
			lntoa(n->nbrip_addr),
			NbrStates[n->state],
			nbr_modes[n->mode],
			n->pri);
		MON_WRITE(_ospf_prt_buf);
	    }
	    if (retrans)
		print_nbr_retrans(intf);
	}
    if (IAmBorderRtr && ospf.vcnt)	/* print virtual links */
	for (i = 0; i < ospf.vcnt; i++) {
	    intf = &(ospf.vl[i]);
	    for (n = FirstNbr(intf); n != NBRNULL; n = n->next) {
		sprintf(_ospf_prt_buf, "%-10s %-13s %-13s %-13s %-10s %-6s %-4d\n",
			"0.0.0.0",
			lntoa(NDX_IP_ADDR(intf->ifspfndx)),
			lntoa(n->nbr_id),
			lntoa(n->nbrip_addr),
			NbrStates[n->state],
			nbr_modes[n->mode],
			n->pri);
		MON_WRITE(_ospf_prt_buf);
	    }
	    if (retrans)
		print_nbr_retrans(intf);
	}
}


/*
 * Print the LSA hdr
 */
void
ls_hdr_print(ls_hdr)
struct LS_HDR *ls_hdr;
{
    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
    sprintf(_ospf_prt_buf, "LSA  type: %s ls id: %s adv rtr: %s age: %d\n",
	    ls_types[ls_hdr->ls_type],
	    lntoa(ls_hdr->ls_id),
	    lntoa(ls_hdr->adv_rtr),
	    ls_hdr->ls_age);
    MON_WRITE(_ospf_prt_buf);

    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
    sprintf(_ospf_prt_buf, "     len: %d seq #: %x cksum: 0x%x\n",
	    ntohs(ls_hdr->length),
	    ls_hdr->ls_seq,
	    ls_hdr->ls_chksum);
    MON_WRITE(_ospf_prt_buf);
}

void
lsa_parse_print(lsa)
void *lsa;
{
    int cnt, i;
    struct NET_LA_PIECES *att_rtr;
    struct RTR_LA_PIECES *lnk;
    union LSA_PTR adv;

    adv.rtr = (struct RTR_LA_HDR *) lsa;

    ls_hdr_print(lsa);

    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));

    switch (adv.rtr->ls_hdr.ls_type) {
	case LS_RTR:
	    sprintf(_ospf_prt_buf, "     Capabilities: As Border: %s Area Border: %s\n",
		    (ntohs(adv.rtr->E_B) & bit_E) ? "On" : "Off",
		    (ntohs(adv.rtr->E_B) & bit_B) ? "On" : "Off");
	    MON_WRITE(_ospf_prt_buf);

	    sprintf(_ospf_prt_buf, "     Link count: %d\n", adv.rtr->lnk_cnt);
	    MON_WRITE(_ospf_prt_buf);

	    for (cnt = ntohs(adv.rtr->lnk_cnt),
		 i = 0,
		 lnk = (struct RTR_LA_PIECES *) & (adv.rtr->link);
		 i < cnt;
		 lnk = (struct RTR_LA_PIECES *) ((long) lnk +
						  RTR_LA_PIECES_SIZE +
			      ((lnk->metric_cnt) * RTR_LA_METRIC_SIZE)),
		 i++) {
		CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
		sprintf(_ospf_prt_buf,
			"     link id: %-12s data: %-12s type: %-12s metric: %d\n",
			lntoa(lnk->lnk_id),
			lntoa(lnk->lnk_data),
			con_types[lnk->con_type - 1],
			ntohs(lnk->tos0_metric));
		MON_WRITE(_ospf_prt_buf);
	    }
	    break;

	case LS_NET:
	    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
	    sprintf(_ospf_prt_buf, "     Net mask: %s\n",
		    lntoa(adv.net->net_mask));
	    MON_WRITE(_ospf_prt_buf);

	    cnt = ntohs(adv.net->ls_hdr.length) - NET_LA_HDR_SIZE;
	    for (att_rtr = &(adv.net->att_rtr), i = 0;
		 i < cnt;
		 att_rtr++, i += 4) {
		CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
		sprintf(_ospf_prt_buf, "       Attached router: %s\n",
			lntoa(att_rtr->lnk_id));
		MON_WRITE(_ospf_prt_buf);
	    }
	    break;

	case LS_SUM_NET:
	    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
	    sprintf(_ospf_prt_buf, "    Net mask: %s",
		    lntoa(adv.sum->net_mask));
	    MON_WRITE(_ospf_prt_buf);

	    /* Fall through */
	case LS_SUM_ASB:
	    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
	    sprintf(_ospf_prt_buf, " Tos 0 metric: %d\n",
		    ntohl(adv.sum->tos0.tos_metric));
	    MON_WRITE(_ospf_prt_buf);
	    break;

	case LS_ASE:
	    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
	    sprintf(_ospf_prt_buf,
		    "     Net mask: %s Tos 0 metric: %d E type: %d\n",
		    lntoa(adv.ase->net_mask),
		    ADV_BIG_METRIC(adv.ase),
		    (ADV_ASE_TYPE2(adv.ase) ? 2 : 1));
	    MON_WRITE(_ospf_prt_buf);

	    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
	    sprintf(_ospf_prt_buf, "     Forwarding Address: %s Tag: %x\n",
		    lntoa(adv.ase->tos0.ForwardAddr),
		    ntohl(adv.ase->tos0.ExtRtTag));
	    MON_WRITE(_ospf_prt_buf);
	    break;
    }
}

void
print_lsa(area_id, type, ls_id, adv_rtr)
u_long32 area_id;
int type;
u_long32 ls_id, adv_rtr;
{
    struct LSDB *db;
    struct AREA *a, *area = AREANULL;

#ifdef DBG
    sprintf(_ospf_prt_buf, "print lsa: area: %s type: %d ls_id: %s adv_rtr: %s",
		lntoa(area_id),
		type,
		lntoa(ls_id),
		lntoa(adv_rtr));
    DBG_LOG(_ospf_prt_buf);
#endif

    if (type < 1 || type > 5)
	return;

    for (a = FirstArea; a < &(ospf.area[ospf.acnt]); a++)
	if (a->area_id == area_id) {
	    area = a;
	    break;
	}
    if (!area) {
#ifdef DBG
	sprintf(_ospf_prt_buf, "Area not found %s\n", lntoa(area_id));
	DBG_LOG(_ospf_prt_buf);
#endif
	return;
    }
    if ((db = (struct LSDB *) FindLSA(area, ls_id, adv_rtr, type)) != LSDBNULL)
	lsa_parse_print((void *) DB_RTR(db));
}


/*
 * Calculate the internal checksum sum for this area
 */
void
int_cksum_sum(area)
struct AREA *area;
{
    int		type;
    struct	LSDB *db, *hp;

    /*
     * get the checksum sum for this area only. Exclude ASEs
     */
    area->db_chksumsum = 0;
    CLEAR_BUF(_ospf_prt_buf, sizeof(_ospf_prt_buf));
    for (type = LS_STUB; type < LS_ASE; type++) 
    {
	for (hp = area->htbl[type];
	     hp < &(area->htbl[type][HTBLSIZE]);
	     hp++) 
	{
	    for (db = hp;
		 DB_NEXT(db) != LSDBNULL;
		 db = DB_NEXT(db))
	    {
		/* 
		 * check to see if it is valid 
		 */
		if (NO_GUTS(DB_NEXT(db)))
			continue;
		area->db_chksumsum += LS_CKS(db);
	    }
	}
    }
}

#endif				/* PROTO_OSPF */
