/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991               	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#include "../ospf.h"

#ifdef	PROTO_OSPF

/*
 *		INET_CKSUM
 */
u_short16
inet_chksum(data, len)
char *data;
int len;
{
    u_short16 *d = (u_short16 *) data;
    int res = 0, i;

    for (i = 0; i < len; i += 2) {
	res += *d;
	d++;
	if (res & 0x10000) {
	    /* wrap around */
	    res &= 0xffff;
	    res++;
	}
    }

    /* If Odd grab the last byte */
    if (len & 0x0001)
	res += *(u_char8 *) d;

    return ((u_short16) (~res));
}


/*
 * 		Fletcher checksum
 *		- Based on RFC 1008
 */
#define MODX 4102			/* larges signed value without overflow */

void
fletch(data, len)
u_char8 *data;				/* the Packet to be checksummed */
int len;				/* length */
{
    int low_byte = 0, high_byte = 0;
    u_char8 *d = data;			/* current data ptr */
    u_char8 *p;
    u_char8 *walk;			/* window of loop between d and walk */
    u_char8 *last_byte = data + len;	/* The last byte of data */
    int low_res, high_res;

    /* Zero out cksum field - bytes 16 and 17 */
    data[16] = (data[17] = 0x00);

    while (d < last_byte) {		/* walk length of data */
	walk = d + MODX;
	if (walk > last_byte)		/* back up to last byte */
	    walk = last_byte;
	for (p = d; p < walk; p++)	/* walk between d & d + MODX */
	    high_byte += (low_byte += (*p));

	/* adjust sums to mod 255 */
	low_byte %= 255;
	high_byte %= 255;
	d = walk;
    }

    /* compute cksum (Voodoo) and insert in data */
    low_res = (((len - 17) * low_byte - high_byte) % 255);
    if (low_res <= 0)
	low_res += 255;
    data[16] = low_res;

    high_res = (510 - low_byte - low_res);
    if (high_res > 255)
	high_res -= 255;
    data[17] = high_res;
}

#endif				/* PROTO_OSPF */
