/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991               	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#include "ospf.h"

#ifdef	PROTO_OSPF

/* MODIFIED DB_NH_NDX 1/10 */
/*
 * These routines deal with the SUMMARY and AS External part of the
 * 	Dijkstra algorithm
 */


/*
 * Add entry to forward cache
 */
void
fwd_cache_add(id, r, nhndx, active)
u_long32 id;
OROUTE *r;
int nhndx, active;
{
    int low_use = 0, i;

    if (ospf.fwd_cnt != FORWARD_CACHE_SIZE) {
	forward_cache[ospf.fwd_cnt].use = 1;
	forward_cache[ospf.fwd_cnt].fwd_rt = r;
	forward_cache[ospf.fwd_cnt].fwd_addr = id;
	forward_cache[ospf.fwd_cnt].nhndx = nhndx;
	forward_cache[ospf.fwd_cnt].active = active;
	ospf.fwd_cnt += 1;
    } else {
	for (i = 0; i < FORWARD_CACHE_SIZE; i++)
	    if (forward_cache[i].use < forward_cache[low_use].use)
		low_use = i;
	forward_cache[low_use].use = 1;
	forward_cache[low_use].fwd_rt = r;
	forward_cache[low_use].fwd_addr = id;
	forward_cache[low_use].nhndx = nhndx;
	forward_cache[low_use].active = active;
    }
}


/*
 * Look up ase forwarding address
 *  - return route
 *  - stuff correct nexthop address in nexthop
 */
OROUTE *
findforward(id, from, from_area, nhndx)
u_long32 id;
int from;
struct AREA *from_area;
int *nhndx;
{
    OROUTE *r;
    u_short16 active = FALSE;		/* forward address valid flag */
    int i;

    *nhndx = 0;

    r = RT_FIND(id);
    if (r == ROUTENULL)
	return (ROUTENULL);

    if ((!ORT_INFO(r)) ||
	(!(PTYPE_BIT(ORT_PTYPE(r)) & PTYPE_INT)) ||
	(RT_DEST(r) == 0))
	return (ROUTENULL);

    if ((from == PTYPE_EXT) || (INT_ACTIVE(from, from_area, r)))
	active = TRUE;

    if (RT_DIRECT(r)) {
        /* MODIFIED 1/28/92 */
        /* 
	 * Check here to see if the forwarding address is our own
	 * interface. If it is don't add 
	 */
	if (NDX_IP_ADDR(RT_IO_NDX(r,0)) == id) {
	    DBG_LOG("My Address");
	    active = FALSE;
	} else {
	    DBG_LOG("Direct");
	    *nhndx = add_nh_entry(RT_IO_NDX(r,0), id, NH_DIRECT_FORWARD, 0);
	}
    } else {
	DBG_LOG("Not Direct");
	*nhndx = RT_NH_NDX(r,0);
    }

    fwd_cache_add(id, r, *nhndx, active);

    if (active) {
	DBG_LOG("Active\n");
	return (r);
    }
    return (ROUTENULL);
}

/*
 * Handle network routes imported from another area
 * 	- called by spf() or rxlinkup()
 *   	- intra or sum may have been run before, but it ain't necessarily so
 *	- if called by rxlinkup can just do partial updates
 */
int
netsum(a, from, from_area, partial)
struct AREA *a;
struct AREA *from_area;			/* area running the algorithm */
int from;				/* level was run from */
int partial;				/* True if called from rxlinkup */
{
    struct LSDB *db, *hp, *low = LSDBNULL;
    RTR_ROUTE *rr;
    OROUTE *old_route = ROUTENULL;
    u_long32 lowcost = SUMLSInfinity, cost;

#ifdef DBG
    sprintf(_ospf_prt_buf, "In netsum partial = %d\n", partial);
    DBG_LOG(_ospf_prt_buf);
#endif

    if (!(from & INTRASCHED)) {
	/*
	 * intra hasn't been run
	 */
	a->spfcnt += 1;
	RTAB_REV++;
	SPFRUN_LOG("SUMNET", a->area_id);
    }
    for (hp = a->htbl[LS_SUM_NET];
	 hp < &(a->htbl[LS_SUM_NET][HTBLSIZE]);
	 hp++) {
	if (partial && !DB_RERUN(*hp)) {
	    /* routes not included in partial update */
	    for (db = DB_NEXT(hp);
		 db != LSDBNULL;
		 db = DB_NEXT(db)) {
		if (NO_GUTS(db))
		    continue;
		/*
	         * running partial update - just mark current
	         */
		if (DB_ROUTE(db)) {
		    ORT_CHANGE(DB_ROUTE(db)) = E_UNCHANGE;
		    ORT_REV(DB_ROUTE(db)) = RTAB_REV;
		}
	    }
	} else if ((partial && DB_RERUN(*hp)) || !(partial)) {
	    /*
	     * non-partial update or partial update sched for this row
	     */
	    DB_RERUN(*hp) = FALSE;
	    for (db = DB_NEXT(hp);
		 db != LSDBNULL;
		 db = DB_NEXT(db)) {
		if ((GOT_GUTS(db)) &&
		    (BIG_METRIC(db) != SUMLSInfinity) &&
		    (!DB_FREEME(db)) &&
		    (LS_AGE(db) < MaxAge) &&
		    (ADV_RTR(db) != MY_ID)) {
#ifdef DBG
		    sprintf(_ospf_prt_buf, "Here1 netsum %s\n",
			    lntoa(LS_ID(db)));
		    DBG_LOG(_ospf_prt_buf);
#endif
		    rr = RTR_ROUTENULL;

		    /*
		     * check to see if we know about this ABR
		     */
		    if (GOT_A_BDR(db)) {
			if (ABRTR_ACTIVE(db))
			    rr = DB_AB_RTR(DB_BDR(db));
			DBG_LOG("GOT_A_DBR and active\n");
		    } else {
			rr = rtr_findroute(a,
					   ADV_RTR(db),
					   DTYPE_ABR,
					   PTYPE_INTRA);
			if (rr)
			    DB_BDR(db) = RRT_V(rr);
		    }
#ifdef DBG
		    sprintf(_ospf_prt_buf, "Here2 netsum r is %d\n", rr);
		    DBG_LOG(_ospf_prt_buf);
#endif

		    /*
		     * Have a valid border router?
		     */
		    if (( rr ) &&
			(DB_BDR(db) != LSDBNULL) &&
			(GOT_GUTS(DB_BDR(db))) &&
			((cost = (RRT_COST( rr ) + BIG_METRIC(db))) <
			 SUMLSInfinity)) {
			DBG_LOG("Here3 netsum\n");
			if (cost == lowcost) {
			    addpar(low,
				   DB_BDR(db),
				   cost,
				   a,
				   RRT_NH_NDX( rr ),
				   0,
				   0);
			} else if (cost < lowcost) {
			    /* free old parent list */
			    DBG_LOG("Here4 netsum\n");
			    freeplist(db);
			    low = db;
			    lowcost = cost;
			    addpar(low,
				   DB_BDR(low),
				   cost,
				   a,
				   RRT_NH_NDX( rr ),
				   0,
				   0);
			}
		    }
		}
		/*
	         * Grab old route for deletion with partial update
	         */
		if ((DB_ROUTE(db)))
		    old_route = DB_ROUTE(db);

		/*
	         * Flag ASE for partial update
	         */
		if (partial && GOT_GUTS(db)) {
		    DB_RERUN(a->htbl[LS_ASE][DB_MYHASH(db)]) = TRUE;
#ifdef DBG
		    sprintf(_ospf_prt_buf,"Pre 5 hash: %d db %s",
				DB_MYHASH(db),
				lntoa(LS_ID(db)));
		    DBG_LOG(_ospf_prt_buf);
#endif
		}
			
		if ((DB_NEXT(db) == LSDBNULL) ||
		    (low && (DB_NEXT(db)->key[0] != low->key[0])) ||
		    (old_route && (DB_NEXT(db)->key[0] != RT_DEST(old_route))))
		{
		    DBG_LOG("Here5 netsum old");
		    if (old_route) {
#ifdef DBG
			sprintf(_ospf_prt_buf, "old: %s",
				lntoa(RT_DEST(old_route)));
			DBG_LOG(_ospf_prt_buf);
#endif
		    }
		    if (low) {
#ifdef DBG
			sprintf(_ospf_prt_buf, "low: %s nh_cnt %d",
				lntoa(LS_ID(low)),
				DB_NH_CNT(low));
			DBG_LOG(_ospf_prt_buf);
#endif
		    }
		    /*
		     * Nexthops were added?
		     */
		    if (low && DB_NH_CNT(low)) {
			if (addroute(a, low, from, from_area))
			    return (FLAG_NO_BUFS);
		    }

		    /*
		     * Modify routing table if partial update
		     */
		    if (partial) {
			if (low && DB_ROUTE(low))
			    old_route = DB_ROUTE(low);
			if (old_route)
			    if (ospf_route_update(old_route, a, SUMASESCHED))
				return(FLAG_NO_BUFS);
		    }
		    low = LSDBNULL;
		    lowcost = SUMLSInfinity;
		    old_route = ROUTENULL;
		}
	    }
	}
    }
    from_area->spfsched &= (~SUMNETSCHED);
    a->spfsched &= (~SUMNETSCHED);
    return (FLAG_NO_PROBLEM);
}


/*
 * Handle all network as border rtrs imported from another area
 * 	- called by spf() or rxlinkup()
 *   	- intra or sum may have been run before, but it ain't necessarily so
 */
int
asbrsum(a, from, from_area, partial)
struct AREA *a, *from_area;
int from;				/* 0 if called from spf() else 1 */
int partial;
{
    struct LSDB *db, *hp, *low = LSDBNULL;
    RTR_ROUTE *rr, *rrt_next;
    u_long32 lowcost = SUMLSInfinity, cost;

    /*
     * For now will not do partial updates for asbrsum
     * 	because there probably won't be more than a few asbr routes
     */

    /*
     * if intra and netsum haven't been run update spfcnt
     */
    if (!(from & SUMNETSCHED)) {
	a->spfcnt += 1;
	RTAB_REV++;
    }

    if (!(from & INTRASCHED)) {
	SPFRUN_LOG("ASBRSUM", a->area_id);
    }

    DBG_LOG("Here1 in asbrsum");
    for (hp = a->htbl[LS_SUM_ASB];
	 hp < &(a->htbl[LS_SUM_ASB][HTBLSIZE]);
	 hp++) {
	for (db = DB_NEXT(hp);
	     db != LSDBNULL;
	     db = DB_NEXT(db)) {
	    if ((GOT_GUTS(db)) &&
		(BIG_METRIC(db) != SUMLSInfinity) &&
		(!DB_FREEME(db)) &&
		(LS_AGE(db) < MaxAge) &&
		(ADV_RTR(db) != MY_ID)) {
		DBG_LOG("Here2 in asbrsum");
		/* First check for intra */
		if ((rr = rtr_findroute(0,
					LS_ID(db),
					DTYPE_ASBR,
					PTYPE_INTRA)) != RTR_ROUTENULL)
		    goto next_db;

		DBG_LOG("Here3 in asbrsum");
		/* check to see if we know about this ABR */
		if (GOT_A_BDR(db)) {
		    if (ABRTR_ACTIVE(db))
			rr = DB_AB_RTR(DB_BDR(db));
		    DBG_LOG("Here4 in asbrsum");
		} else {
		    rr = rtr_findroute(a,
				       ADV_RTR(db),
				       DTYPE_ABR,
				       PTYPE_INTRA);
		    if ( rr )
			DB_BDR(db) = RRT_V( rr );
		    DBG_LOG("Here5 in asbrsum");
		}
		/* Have a valid border router? */
		if (( rr ) &&
		    (DB_BDR(db) != LSDBNULL) &&
		    (GOT_GUTS(DB_BDR(db))) &&
		    ((cost = (RRT_COST( rr ) + BIG_METRIC(db))) <
		     SUMLSInfinity)) {
		    DBG_LOG("Here6 in asbrsum");
		    if (cost == lowcost) {
			DBG_LOG("Here7 in asbrsum");
			addpar(low,
			       DB_BDR(db),
			       cost,
			       a,
			       RRT_NH_NDX( rr ),
			       0,
			       0);
		    } else if (cost < lowcost) {
			/* free old parent list */
			DBG_LOG("Here8 in asbrsum");
			freeplist(db);
			low = db;
			lowcost = cost;
			addpar(low,
			       DB_BDR(low),
			       cost,
			       a,
			       RRT_NH_NDX( rr ),
			       0,
			       0);
		    }
		}
	    }				/* Reasonable LS_SUM_ASB */
	  next_db:
	    if ( low &&
		( (DB_NEXT(db) == LSDBNULL) ||
		  ((DB_NEXT(db)->key[0] != low->key[0])) ) ) {
		/* Nexthops were added? */
		DBG_LOG("Here9 in asbrsum");
		if (DB_NH_CNT(low)) {
		    /* add route to ospf's routing table */
		    if (addroute(a, low, from, from_area))
			return (FLAG_NO_BUFS);
		}
		low = LSDBNULL;
		lowcost = SUMLSInfinity;
	    }
	}
    }

    /* 
     * modify asb routes 
     */
    for (rr = sum_asb_rtab.ptr[NEXT];
	 rr != RTR_ROUTENULL;
	 rr = rrt_next) 
    {
	rrt_next = RRT_NEXT(rr);
#ifdef DBG
	sprintf(_ospf_prt_buf,"Dest %s rr: %d rrt_next: %d",
		lntoa(RRT_DEST(rr)),
		rr,
		rrt_next);
	DBG_LOG(_ospf_prt_buf);
#endif

	if (RRT_REV(rr) != RTAB_REV) {
	    /* delete intra routes from all other areas
	     *	- add to txq -
	     *	- dist will = Infinity
	     */
	    DBG_LOG("Here in delete");
	    if (RRT_V(rr)) {
	        if ((IAmBorderRtr) &&
		    (a == ospf.area) &&
		    (ADV_RTR(RRT_V(rr)) != MY_ID))
			if (build_sum_asb(a, rr, from_area))
		    	    return(FLAG_NO_BUFS);

		DB_ASB_RTR(RRT_V(rr)) = RTR_ROUTENULL;
		freeplist(RRT_V(rr));
	    }
	    DEL_Q(rr, TRUE, OMEM_ORT);
	} else
	if (RRT_CHANGE(rr) != E_UNCHANGE) {
	    /* 
	     * add inter routes to all other areas txq
	     * change in firsthop or newroute 
	     */
	    DBG_LOG("Here is add/change");
	    if ((IAmBorderRtr) && (a == ospf.area) &&
		(ADV_RTR(RRT_V(rr)) != MY_ID))
		if (build_sum_asb(a, rr, from_area))
		    return(FLAG_NO_BUFS);
	    RRT_CHANGE(rr) = E_UNCHANGE;
	}
    }
    a->spfsched &= (~SUMASBSCHED);
    return (FLAG_NO_PROBLEM);
}


/*
 * Handle all routes imported from another AS
 * 	- called by spf() or rxlinkup()
 *   	- intra or sum may have been run before, but it ain't necessarily so
 *	- will just keep one equal cost route per border rtr/forwarding addr
 */
int
ase(area, from, partial)
struct AREA *area;	/* area resulting in ase() being called */
int from;		/* what was (intra or sum run before ase) flag */
int partial;		/* True if called for rxlinkup */
{
    struct LSDB *hp, *db, *par, *low = LSDBNULL, *my_version;
    RTR_ROUTE *rr;
    OROUTE *f, *old_route = ROUTENULL;
    int nhndx, i, j, k = 0;
    int p[MAXNH * 2];

    u_long32 low_cost = ASELSInfinity, cost;
    int etype, low_etype = 2;
    u_long32 type2cost, low_type2cost = ASELSInfinity;

#ifdef DBG
    sprintf(_ospf_prt_buf, "In ase partial = %d\n", partial);
    DBG_LOG(_ospf_prt_buf);
#endif

    if (!(from & INTSCHED)) {
	area->spfcnt += 1;
	RTAB_REV++;			/* intra and sum haven't been run*/
	SPFRUN_LOG("ASE", area->area_id);
    }

    /* 
     * initialize forwarding address cache 
     */
    fwd_cache_init();

    for (hp = area->htbl[LS_ASE];
	 hp < &(area->htbl[LS_ASE][HTBLSIZE]);
	 hp++, k++) {
	my_version = LSDBNULL;

	if (partial && !DB_RERUN(*hp)) {
	    /* routes not included in partial update */
	    for (db = DB_NEXT(hp);
		 db != LSDBNULL;
		 db = DB_NEXT(db)) {
		if (NO_GUTS(db))
		    continue;
		/* running partial update - just mark current */
		if (DB_ROUTE(db)) {
		    ORT_CHANGE(DB_ROUTE(db)) = E_UNCHANGE;
		    ORT_REV(DB_ROUTE(db)) = RTAB_REV;
		}
	    }
	} else if ((partial && DB_RERUN(*hp)) || !(partial)) {
	    /* non-partial update or partial update sched for this row */
	    DB_RERUN(*hp) = FALSE;
	    for (db = DB_NEXT(hp);
		 db != LSDBNULL;
		 db = DB_NEXT(db)) {
		DBG_LOG("Here1.2 in ASE\n");
		/* Reasonable looking DB? */
		if ((GOT_GUTS(db)) &&
		    (BIG_METRIC(db) != ASELSInfinity) &&
		    (!DB_FREEME(db)) &&
		    (LS_AGE(db) < MaxAge)) {
		    if (ADV_RTR(db) == MY_ID) {
			/* May nuke my version of this - store info for now */
			my_version = db;
			goto next_db;
		    }
		    rr = RTR_ROUTENULL;
		    f = ROUTENULL;
		    /* check to see if we know about this ASBR */
		    /* ASBR may have changed so if not active lookup.. */
		    if ((GOT_A_BDR(db)) && (ASBRTR_ACTIVE(db)))
			rr = DB_BDR_ASB(db);
		    else {
			rr = rtr_findroute(0,
					   ADV_RTR(db),
					   DTYPE_ASBR,
					   PTYPE_INT);
			if (rr)
			    DB_BDR(db) = RRT_V(rr);
		    }
		    /* Can't seem to get this AS border thing together... */
		    if ((rr == RTR_ROUTENULL) ||
			(DB_BDR(db) == LSDBNULL) &&
			(NO_GUTS(DB_BDR(db))))
			{
			    goto next_db;
			}
		    DBG_LOG("Here past findroute in ASE\n");
		    par = RRT_V(rr);
		    nhndx = RRT_NH_NDX(rr);
		    cost = RRT_COST(rr);

		    /* Do that forwarding address thing... */
		    if (DB_ASE_FORWARD(db) != 0) {
		        for (i = 0; i < ospf.fwd_cnt; i++) 
			{
			    if (forward_cache[i].fwd_addr == DB_ASE_FORWARD(db))
			    {
			        forward_cache[i].use += 1;
			        if (!forward_cache[i].active) {
				    goto next_db;
				}
			    	nhndx = forward_cache[i].nhndx;
			    	f = forward_cache[i].fwd_rt;
				break;
			    }
		    	}
			if (!f) f = findforward(DB_ASE_FORWARD(db),
					 from,
					 area,
					 &nhndx);
			if (!f) goto next_db;

			DBG_LOG("Here1 in ASE\n");
			par = ORT_V(f);
			cost = ORT_COST(f);
		    }
		    /* Set metric for external type */
		    if (etype = ASE_TYPE2(db))
			type2cost = BIG_METRIC(db);
		    else {
			cost = BIG_METRIC(db) + cost;
			type2cost = 0;
		    }

		    /* Have a valid parent? */
		    if ((par) &&
			(GOT_GUTS(par)) &&
			(nhndx) &&
			(type2cost < ASELSInfinity) &&
			(cost < ASELSInfinity)) {
			/* Add equal cost route */
			DBG_LOG("Here2 in ASE\n");
			if (ASE_COST_EQUAL(etype, cost, type2cost,
				   low_etype, low_cost, low_type2cost)) {
			    DBG_LOG("Here2.a in ASE adding equal cost\n");
			    for (i = 0;
				 i < DB_NH_CNT(low);
				 i++) {
				/* check for duplicate */
				if (nhndx == DB_NH_NDX(low,i)) {
				    nhndx = 0;
				    break;
				}
				p[i] = DB_NH_NDX(low,i);
			    }
			    if (!nhndx)
				goto next_db;

			    for (i = 0, j = 0;
			    (i < (DB_NH_CNT(low) + 1) && (i < MAXNH));
				 i++) {
				if ((ntohl(nh_block[nhndx].nh_addr)) <
				    (ntohl(nh_block[p[j]].nh_addr)))
				    DB_NH_NDX(low,i) = nhndx;
				else {
				    DB_NH_NDX(low,i) = p[j];
				    j++;
				}
			    }
			    DB_NH_CNT(low) =
				((DB_NH_CNT(low) + 1) < MAXNH) ?
				(DB_NH_CNT(low) + 1) : MAXNH;
			} else if (ASE_COST_LESS(etype,
						 cost,
						 type2cost,
						 low_etype,
						 low_cost,
						 low_type2cost)) {
			    DBG_LOG("Here3 in ASE\n");
			    /* free old parent list */
			    freeplist(db);
			    low = db;
			    low_cost = cost;
			    low_etype = etype;
			    low_type2cost = type2cost;
			    DB_DIST(low) = cost;
			    DB_NH_CNT(low) = 1;
			    DB_NH_NDX(low,0) = nhndx;
			}
		    }
		}
	      next_db:

		/* Grab old route for deletion with partial update */
		if ((DB_ROUTE(db))) {
#ifdef DBG
		    sprintf(_ospf_prt_buf, "grabbing old route %s\n",
			    lntoa(RT_DEST(DB_ROUTE(db))));
		    DBG_LOG(_ospf_prt_buf);
#endif
		    old_route = DB_ROUTE(db);
		}
		if ((DB_NEXT(db) == LSDBNULL) ||
		    (low && ((DB_NEXT(db)->key[0] != low->key[0]))) ||
		    (old_route && (DB_NEXT(db)->key[0] != RT_DEST(old_route))))
		{
		    DBG_LOG("Here4 in ASE\n");
		    /* Nexthops were added? */
		    if (low && DB_NH_CNT(low)) {
			if (addroute(area, low, from, area))
			    return (FLAG_NO_BUFS);
		    }
		    /* Modify partial update */
		    if (partial) {
			if ((low) && DB_ROUTE(low)) {
			    DBG_LOG("Using low\n");
			    old_route = DB_ROUTE(low);
			}
			if (old_route)
			    if (ospf_route_update(old_route, area, ASESCHED))
			     return(FLAG_NO_BUFS);
		    }
		    low = LSDBNULL;
		    low_cost = ASELSInfinity;
		    low_type2cost = ASELSInfinity;
		    low_etype = 1;
		    my_version = LSDBNULL;
		    old_route = ROUTENULL;
		}
	    }				/* db loop */
	}				/* Partial */
	area->spfsched &= (~ASESCHED);
    }
    return (FLAG_NO_PROBLEM);
}

#endif				/* PROTO_OSPF */
