/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991               	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#include "ospf.h"

#ifdef	PROTO_OSPF

static int force_flood;

/* MODIFIED 2/13/92 - removed all references to block_size and BLOCK_SIZE */
/*
 * Compare LSAs for changes
 * - schedule partial update
 * - return spfsched
 */
int
lsacmp(area, adv, db, sec)
struct AREA *area;
union LSA_PTR adv;
struct LSDB *db;
time_t sec;
{
    int spfsched = 0;

    if ((ADV_AGE(db, sec) >= MaxAge && adv.rtr->ls_hdr.ls_age < MaxAge) ||
	(ADV_AGE(db, sec) < MaxAge && adv.rtr->ls_hdr.ls_age >= MaxAge)) {
	if (LS_TYPE(db) > LS_NET) {
	    DB_RERUN(area->htbl[LS_TYPE(db)][DB_MYHASH(db)]) = TRUE;
	    /*
	    * If virtual link transit area rerun backbone
	     */
	    if ((LS_TYPE(db) != LS_ASE) && (area->virtual_up)) {
		DBG_LOG("Scheduling VIRTUAL");
		ospf.area->spfsched |= SCHED_BIT(LS_NET);
	    }
	}
	return (SCHED_BIT(LS_TYPE(db)));
    }
    switch (adv.rtr->ls_hdr.ls_type) {
	case LS_RTR:
	    if ((adv.rtr->ls_hdr.length != LS_LEN(db)) ||
		(adv.rtr->lnk_cnt != DB_RTR(db)->lnk_cnt) ||
		(adv.rtr->E_B != DB_RTR(db)->E_B) ||
		(RTR_LINK_CMP(adv.rtr, DB_RTR(db),
		     (ntohs(adv.rtr->ls_hdr.length) - RTR_LA_HDR_SIZE))))
		spfsched = SCHED_BIT(LS_RTR);
	    break;

	case LS_NET:
	    if ((adv.net->ls_hdr.length != LS_LEN(db)) ||
		(NET_ATTRTR_CMP(adv.net, DB_NET(db),
		     ntohs(adv.net->ls_hdr.length) - (NET_LA_HDR_SIZE))))
		spfsched = SCHED_BIT(LS_NET);
	    break;

	case LS_SUM_NET:
	    /*
	     * Just check metric
	     */
	    DBG_LOG("Here in ls sum net");
	    if (adv.sum->tos0.tos_metric != (DB_SUM(db)->tos0.tos_metric)) {
#ifdef DBG
		sprintf(_ospf_prt_buf, "Here LS_SUM_NET virtual up %d",
			area->virtual_up);
		DBG_LOG(_ospf_prt_buf);
#endif
		/*
	         * If there is a virtual link schedule backbone spf
	         */
		if (area->virtual_up)
		    ospf.area->spfsched |= SCHED_BIT(LS_NET);

		/*
	         * schedule netsum if not bdr rtr or bdr rtr and
	         * area is backbone
	         */
		if ((IAmBorderRtr && area == ospf.area) ||
		    (!(IAmBorderRtr))) {
		    spfsched = SCHED_BIT(LS_SUM_NET);
		    DB_RERUN(area->htbl[LS_SUM_NET][DB_MYHASH(db)]) = TRUE;
#ifdef DBG
		    sprintf(_ospf_prt_buf, "Setting hash %d to TRUE for net %s",
			DB_MYHASH(db),
			lntoa(LS_ID(db)));
		    DBG_LOG(_ospf_prt_buf);
#endif
		}
	    }
	    break;

	case LS_SUM_ASB:
	    if (adv.sum->tos0.tos_metric != (DB_SUM(db)->tos0.tos_metric)) {
		/*
	         * If there is a virtual link schedule backbone spf
	         */
		if (area->virtual_up) {
#ifdef DBG
		    sprintf(_ospf_prt_buf, "Here LS_SUM_ASB virtual up %d",
			area->virtual_up);
		    DBG_LOG(_ospf_prt_buf);
#endif
		    ospf.area->spfsched |= SCHED_BIT(LS_NET);
		}
		/*
	         * schedule asbrsum if not bdr rtr or bdr rtr and
	         * area is backbone - will have to rerun sum and ase
	         */
		if ((IAmBorderRtr && area == ospf.area) ||
		    (!(IAmBorderRtr))) {
		    spfsched = SCHED_BIT(LS_SUM_ASB);
		    DB_RERUN(area->htbl[LS_SUM_ASB][DB_MYHASH(db)]) = TRUE;
		}
	    }
	    break;

	case LS_ASE:
	    if (ASE_TOS_CMP(&(DB_ASE(db)->tos0), &(adv.ase->tos0))) {
		spfsched = SCHED_BIT(LS_ASE);
		DB_RERUN(area->htbl[LS_ASE][DB_MYHASH(db)]) = TRUE;
	    }
	    break;
    }
    return (spfsched);
}

void
ls_req_entry_print(ls_req, type)
struct LS_REQ *ls_req;
int type;
{
#ifdef DBG
    sprintf(_ospf_prt_buf, "LS HDR: type: %d ls_id: %s adv_rtr: %s\n",
	    type,
	    lntoa(ls_req->ls_id),
	    lntoa(ls_req->adv_rtr));
    DBG_LOG(_ospf_prt_buf);
    sprintf(_ospf_prt_buf, "        age: %d seq #: %x cksum: %x\n",
	    ls_req->ls_age,
	    ls_req->ls_seq,
	    ls_req->ls_chksum);
    DBG_LOG(_ospf_prt_buf);
#endif
}


/*
 * Remove request from nbr request list
 */
int
nbr_rem_req(nbr, adv)
union LSA_PTR adv;
struct NBR *nbr;
{
    struct LS_REQ *ls_req;

#ifdef DBG
    sprintf(_ospf_prt_buf, "rem_req: type %d ls_id %s adv_rtr %s\n",
	    (adv.rtr->ls_hdr.ls_type),
	    lntoa(adv.rtr->ls_hdr.ls_id),
	    lntoa(adv.rtr->ls_hdr.adv_rtr));
    DBG_LOG(_ospf_prt_buf);
#endif

    for (ls_req = nbr->ls_req[adv.rtr->ls_hdr.ls_type];
	 ls_req != LS_REQ_NULL; ls_req = ls_req->ptr[NEXT])
	if ((adv.rtr->ls_hdr.ls_id == ls_req->ls_id) &&
	    (adv.rtr->ls_hdr.adv_rtr == ls_req->adv_rtr)) {
	    if (MORE_RECENT(ls_req, &(adv.rtr->ls_hdr), 0)) {
		DBG_LOG("REQ_MORE_RECENT\n");
		return (REQ_MORE_RECENT);
	    }
	    DBG_LOG("REQ_SAME or LESS: removed\n");
	    REM_Q((nbr->ls_req[adv.rtr->ls_hdr.ls_type]),
		  ls_req,
		  NUKE,
		  OMEM_LS_REQ);
	    nbr->reqcnt -= 1;
	    if (SAME_INSTANCE(ls_req, &(adv.rtr->ls_hdr), 0))
		return (REQ_SAME_INSTANCE);
	    return (REQ_LESS_RECENT);
	}
    return (REQ_NOT_FOUND);
}

/*
 * Handle self-originated LSA
 */
int
rx_self_orig(dbi, trans, asetrans, acks)
struct DB_INFO *dbi;
struct LSDB_LIST **trans, **asetrans;
struct ACK_LIST **acks;
{
    int spfsched = 0;
    int implied_ack = FALSE;
    struct LSDB_LIST *ll;
    struct INTF *ifp, *db_intf;
    u_short16 age = 0;
    u_long32 new_seq;


    if ((!dbi->foundlsa) ||
	MORE_RECENT(&(dbi->adv.rtr->ls_hdr),
		    &(DB_RTR(dbi->db)->ls_hdr),
		    dbi->diff)) 
    {
	/*
	 * newer one has come in, we have an old one floating around
	 */
	DBG_LOG("Rxlinkup: more recent instance");

	if (!(QueueChk(dbi->adv.rtr->ls_hdr.ls_type,dbi->area)))
	    return(FLAG_NO_BUFS);
	/* 
	 * if there is a retrans list  free it 
	 */
	if ((dbi->foundlsa) && (DB_RETRANS(dbi->db) != NLNULL))
	    rem_db_retrans(dbi->db);

	/*
	 * build new LSA and send
	 */
	switch (dbi->adv.rtr->ls_hdr.ls_type) {
	    case LS_RTR:
		age = LS_AGE(dbi->db);
		LS_AGE(dbi->db) = 0;
		LS_SEQ(dbi->db) = dbi->adv.rtr->ls_hdr.ls_seq;
	    	dbi->area->db_chksumsum -= LS_CKS(dbi->db);
		fletch(DB_RTR(dbi->db), dbi->len);
	    	dbi->area->db_chksumsum += LS_CKS(dbi->db);
		LS_AGE(dbi->db) = age;
		force_flood |= PTYPE_BIT(LS_RTR);
		dbi->area->build_rtr = TRUE;
		break;

	    case LS_NET:

		/*
	         * Find interface associated with this net lsa
	         */
		for (ifp = dbi->area->intf;
		     ifp < &(dbi->area->intf[dbi->area->ifcnt]);
		     ifp++)
		    if (ADV_NETNUM(dbi->adv.net) == INTF_NETNUM(ifp)) {
			db_intf = ifp;
			break;
		    }
		if ((!dbi->foundlsa) ||
		    (db_intf == INTFNULL) ||
		    (db_intf->state != IDr) ||
		    ((db_intf->state == IDr) && (!db_intf->nbrFcnt))) {
		    /*
		     * nbr has an out of date net lsa around
		     */
		    if (!dbi->foundlsa) {
			ADV_ALLOC(dbi->db,
				  LS_NET,
				  dbi->len);
			if (!DB_NET(dbi->db)) {
	    		    /* MODIFIED 1/17 */
	    		    ospf.db_cnt--;
			    dbi->area->db_cnts[LS_NET]--;
    			    dbi->area->db_int_cnt--;
			    db_free(dbi->db);
			    return(FLAG_NO_BUFS);
			}
			ADV_COPY(dbi->adv.net, DB_NET(dbi->db), dbi->len);
		    } else {
	    		dbi->area->db_chksumsum -= LS_CKS(dbi->db);
		    }
		    /*
		     * MaxAge so everyone deletes it
		     */
		    age = MaxAge;
		    LL_ALLOC(ll);
		    ll->lsdb = dbi->db;
		    EN_Q((*trans), ll);
		} else {
		    /*
		     * have one in lsdb and this rtr is Dr
		     */
	    	    dbi->area->db_chksumsum -= LS_CKS(dbi->db);
		    LS_SEQ(dbi->db) = dbi->adv.net->ls_hdr.ls_seq;
		    age = LS_AGE(dbi->db);
		    if (db_intf)
			db_intf->build_net = TRUE;
		}
		DB_TIME(dbi->db) = dbi->sec;
		LS_AGE(dbi->db) = 0;
		fletch(DB_NET(dbi->db), dbi->len);
	    	dbi->area->db_chksumsum += LS_CKS(dbi->db);
		LS_AGE(dbi->db) = age;
		force_flood |= SCHED_BIT(LS_NET);
		break;

	    case LS_SUM_ASB:
	    case LS_SUM_NET:
		LL_ALLOC(ll);
		/*
	         * An old sum hangin' around
	         */
		if (!dbi->foundlsa) {
		    ADV_ALLOC(dbi->db, dbi->adv.rtr->ls_hdr.ls_type, dbi->len);
		    if (!DB_SUM(dbi->db)) {
	    		/* MODIFIED 1/17 */
	    		ospf.db_cnt--;
			dbi->area->db_cnts[dbi->adv.rtr->ls_hdr.ls_type]--;
    			dbi->area->db_int_cnt--;
			db_free(dbi->db);
			return(FLAG_NO_BUFS);
		    }
		    ADV_COPY(dbi->adv.sum, DB_SUM(dbi->db), dbi->len);
		    DB_SUM(dbi->db)->tos0.tos_metric = htonl(SUMLSInfinity);
		    age = MaxAge;	/* let everyone know to free it */
		    DB_FREEME(dbi->db) = TRUE;
		    ADD_DBQ(&ospf.db_free_list, dbi->db);
		    new_seq = NEXTNSEQ(dbi->adv.sum->ls_hdr.ls_seq);
		} else if ((!(DB_SEQ_MAX(dbi->db))) && 
			    LS_SEQ(dbi->db) == MaxSeqNum) {
		    /*
		     * Flush from everyone's db
		     */
		    age = MaxAge;
		    new_seq = MaxSeqNum;
		    DB_SEQ_MAX(dbi->db) = TRUE;
	    	    dbi->area->db_chksumsum -= LS_CKS(dbi->db);
		} else {
		    age = (DB_WHERE(dbi->db) != ON_SUM_INFINITY) ? 0 : MaxAge;
		    new_seq = NEXTNSEQ(dbi->adv.sum->ls_hdr.ls_seq);
	    	    dbi->area->db_chksumsum -= LS_CKS(dbi->db);
		}
		LS_AGE(dbi->db) = 0;
		LS_SEQ(dbi->db) = new_seq;
		DB_TIME(dbi->db) = dbi->sec;
		/*
	         * add new chksum
	         */
		fletch(DB_SUM(dbi->db), dbi->len);
	    	dbi->area->db_chksumsum += LS_CKS(dbi->db);
		LS_AGE(dbi->db) = age;
		ll->lsdb = dbi->db;
		EN_Q((*trans), ll);
		break;

	    case LS_ASE:
		LL_ALLOC(ll);
		/*
	         * An old ase hangin' around
	         */
		if (!dbi->foundlsa) {
		    /*
		     * Save ASE type bit
		     */
		    u_long32 bitE = htonl(ASE_bit_E);

		    ADV_ALLOC(dbi->db, LS_ASE, dbi->len);
		    if (!DB_ASE(dbi->db)) {
	    		/* MODIFIED 1/17 */
	    		ospf.db_cnt--;
			ospf.db_ase_cnt--;
			db_free(dbi->db);
			return(FLAG_NO_BUFS);
		    }
		    ADV_COPY(dbi->adv.ase, DB_ASE(dbi->db), dbi->len);
		    age = MaxAge;
		    DB_FREEME(dbi->db) = TRUE;
		    ADD_DBQ(&ospf.db_free_list, dbi->db);
		    if (!(bitE & DB_ASE(dbi->db)->tos0.tos_metric))
			bitE = 0;
		    DB_ASE(dbi->db)->tos0.tos_metric = htonl(ASELSInfinity);
		    DB_ASE(dbi->db)->tos0.tos_metric |= htonl(bitE);
		    new_seq = NEXTNSEQ(dbi->adv.ase->ls_hdr.ls_seq);
		} else if ((!(DB_SEQ_MAX(dbi->db))) && 
			    LS_SEQ(dbi->db) == MaxSeqNum) {
		    /*
		     * Flush from everyone's db
		     */
		    age = MaxAge;
		    new_seq = MaxSeqNum;
		    DB_SEQ_MAX(dbi->db) = TRUE;
	    	    ospf.db_chksumsum -= LS_CKS(dbi->db);
		} else {
		    age = (DB_WHERE(dbi->db) == ON_ASE_LIST) ? 0 : MaxAge;
		    new_seq = NEXTNSEQ(dbi->adv.sum->ls_hdr.ls_seq);
	    	    ospf.db_chksumsum -= LS_CKS(dbi->db);
		}
		LS_SEQ(dbi->db) = new_seq;
		DB_TIME(dbi->db) = dbi->sec;
		LS_AGE(dbi->db) = 0;
		/*
	         * add new chksum
	         */
		fletch(DB_ASE(dbi->db), dbi->len);
	    	ospf.db_chksumsum += LS_CKS(dbi->db);
		LS_AGE(dbi->db) = age;
		ll->lsdb = dbi->db;
		EN_Q((*asetrans), ll);
		break;
	}

	/*
	 * If it is to be flushed, put on free list
	 */
	if (LS_AGE(dbi->db) == MaxAge && LS_SEQ(dbi->db) != MaxSeqNum) {
	    DEL_DBQ(dbi->db);
	    DB_FREEME(dbi->db) = TRUE;
	    ADD_DBQ(&ospf.db_free_list, dbi->db);
	}
    } else if (SAME_INSTANCE(&(dbi->adv.rtr->ls_hdr),
		&(DB_RTR(dbi->db)->ls_hdr),
		dbi->diff))
    {
	DBG_LOG("Rxlinkup: same instance");
	if (dbi->nbr->state < NFULL) {
	    /*
	     * Out of sync with nbr's state machine
	     */
	    if (nbr_rem_req(dbi->nbr, dbi->adv)) {
#ifdef DBG
		sprintf(_ospf_prt_buf, "Same instance:Cur Seq # %x new %x\n",
			LS_SEQ(dbi->db),
			dbi->adv.rtr->ls_hdr.ls_seq);
		DBG_LOG(_ospf_prt_buf);
#endif
		(*(nbr_trans[BAD_LS_REQ][dbi->nbr->state]))(dbi->intf,dbi->nbr);
		return (FLAG_BAD_REQ);
	    }
	}
	/*
         * remove from retransmit lists
         */
	rem_nbr_ptr(dbi->db, dbi->nbr);
	implied_ack |= rem_db_ptr(dbi->nbr, dbi->db);
	/*
         * in this case, implied ack means that the lsa wasn't
         * on the retrans list so send direct ack
         */
	if (!implied_ack)
	    add_ack(acks, dbi->db);

	/*
         * If seqnum is MaxSeq and this is last ack, generate a new one
         */
	if ((DB_SEQ_MAX(dbi->db) == TRUE) &&
	    (DB_RETRANS(dbi->db) == NLNULL) &&
	    (DB_FREEME(dbi->db) != TRUE))
	    beyond_max_seq(dbi->area,dbi->intf,dbi->db,trans,asetrans,TRUE);
    } else {
	/*
	 * Less recent
	*/
	if (dbi->nbr->state < NFULL) {
	    /*
	     * Out of sync with nbr's state machine
	     */
	    if (nbr_rem_req(dbi->nbr, dbi->adv)) {
#ifdef DBG
		sprintf(_ospf_prt_buf, "Same instance:CurSeq # %x new %x\n",
			LS_SEQ(dbi->db),
			dbi->adv.rtr->ls_hdr.ls_seq);
		DBG_LOG(_ospf_prt_buf);
#endif
		(*(nbr_trans[BAD_LS_REQ][dbi->nbr->state]))(dbi->intf,dbi->nbr);
		return (FLAG_BAD_REQ);
	    }
	}
	RX_LOG(dbi->mc, UNUSUAL_INSTANCE, dbi->intf->ifspfndx, dbi->nbr->nbrip_addr);
    }
    return (spfsched);
}


/*
 * Handle non self-originated LSA
 */
int
not_my_lsa(dbi, trans, asetrans, acks)
struct DB_INFO *dbi;
struct LSDB_LIST **trans, **asetrans;
struct ACK_LIST **acks;
{
    int spfsched = 0;
    int implied_ack = FALSE;
    struct LSDB_LIST *ll;

    /*
     * if found and not the same or if not found
     */
    if ((!dbi->foundlsa) ||
	MORE_RECENT(&(dbi->adv.rtr->ls_hdr),
		    &(DB_RTR(dbi->db)->ls_hdr),
		    dbi->diff))
    {
	if ((dbi->foundlsa) && (dbi->diff < MinLSInterval))
	{
#ifdef DBG
	    sprintf(_ospf_prt_buf,"Tsuchiya diff: %d\n",dbi->diff);
	    DBG_LOG(_ospf_prt_buf);
#endif
	    return (FLAG_NO_PROBLEM);		/* The Tsuchiya fix */
	}

	/*
	 * Enough memory to put on all retrans queues?
	 */
	if (!(QueueChk(dbi->adv.rtr->ls_hdr.ls_type,dbi->area)))
	    return(FLAG_NO_BUFS);
	/*
	 * Keep track of received new instances for MIBness
	 */
	ospf.rx_new_lsa++;

	/*
         * install in lsdb - may have to recalculate routing table
         */
	if (!dbi->foundlsa) {
	    /*
	     * allocate a new one and assign the lsa info to it
	     */
	    DBG_LOG("Newer Not Found LSA");
	    ADV_ALLOC(dbi->db,
		      dbi->adv.rtr->ls_hdr.ls_type,
		      dbi->len);

	    if (!DB_RTR(dbi->db)) {
		/* No memory - undo a couple of things... */
		ospf.rx_new_lsa--;
	    	/* MODIFIED 1/17 */
	    	ospf.db_cnt--;
		if (dbi->adv.rtr->ls_hdr.ls_type == LS_ASE)
			ospf.db_ase_cnt--;
		else {
		    dbi->area->db_cnts[dbi->adv.rtr->ls_hdr.ls_type]--;
    		    dbi->area->db_int_cnt--;
		}
		db_free(dbi->db);
		return(FLAG_NO_BUFS);
	    }

	    ADV_COPY(dbi->adv.rtr, DB_NET(dbi->db), dbi->len);
	    switch (LS_TYPE(dbi->db)) {
		case LS_RTR:
		case LS_NET:
		    /*
		     * will rerun intra()
		     */
		    spfsched |= (SCHED_BIT(LS_TYPE(dbi->db)));
		    break;

		case LS_SUM_NET:
		    /* 
		     * add net 
		     */
		    if ((IAmBorderRtr && dbi->area == ospf.area) ||
			(!(IAmBorderRtr))) {
			spfsched = SCHED_BIT(LS_SUM_NET);
			DB_RERUN(dbi->area->htbl[LS_SUM_NET][DB_MYHASH(dbi->db)]) = TRUE;
		    }
		    if (dbi->area->virtual_up)
			ospf.area->spfsched |= SCHED_BIT(LS_NET);
		    break;

		case LS_SUM_ASB:
		    /* add as border rtr and schedule ase -
			    ls_ase may have become reachable */
		    if ((IAmBorderRtr && dbi->area == ospf.area) ||
			(!(IAmBorderRtr))) {
			spfsched = SCHED_BIT(LS_SUM_ASB);
			DB_RERUN(dbi->area->htbl[LS_SUM_ASB][DB_MYHASH(dbi->db)]) = TRUE;
		    }
		    if (dbi->area->virtual_up)
			ospf.area->spfsched |= SCHED_BIT(LS_RTR);
		    break;

		case LS_ASE:
		    /* new ase has come in */
		    spfsched = SCHED_BIT(LS_ASE);
#ifdef DBG
		    sprintf(_ospf_prt_buf, "In rxlinkup ASE: myhash: %d\n",
			    DB_MYHASH(dbi->db));
		    DBG_LOG(_ospf_prt_buf);
#endif
		    DB_RERUN(dbi->area->htbl[LS_ASE][DB_MYHASH(dbi->db)]) = TRUE;
		    break;
	    }
	} else {
	    u_short16 old_age;
	    u_long32  old_cks;
    	    struct RTR_LA_HDR *r;

	    old_age  = ADV_AGE(dbi->db, dbi->sec);
	    old_cks = LS_CKS(dbi->db);

	    /*
	     * found lsa
	     */
	    DBG_LOG("Newer Found LSA");

	    /*
	     * see if they're the same - if not schedule spf
	     */
	    spfsched |= lsacmp(dbi->area, dbi->adv, dbi->db, dbi->sec);

	    /*
	     * save an alloc
     	     */
	    if ((dbi->len) > ntohs(LS_LEN(dbi->db))) {
    		RTR_HDR_ALLOC(r, dbi->len);
		if (!r)
		    return(FLAG_NO_BUFS);
		DBADV_FREE((dbi->db),LS_TYPE(dbi->db));
		DB_RTR(dbi->db) = r;
	    }
	    ADV_COPY(dbi->adv.rtr,DB_RTR(dbi->db),(dbi->len));


	    /*
	     * if there is a retrans list free it
	     */
	    if (DB_RETRANS(dbi->db) != NLNULL)
		rem_db_retrans(dbi->db);

	    /*
	     * if new one is no longer maxage, remove from free list
	     */
	    if ((old_age >= MaxAge) &&
		(LS_AGE(dbi->db) < MaxAge)) {
		if (DB_FREEME(dbi->db)) {
		    DEL_DBQ(dbi->db);
		    DB_FREEME(dbi->db) = FALSE;
		}
	    }
	    /*
	     * set it up so when retrans list is empty, free
	     */
	    else if ((LS_AGE(dbi->db) >= MaxAge) &&
		     (DB_FREEME(dbi->db) == FALSE)) {
		DEL_DBQ(dbi->db);
		DB_FREEME(dbi->db) = TRUE;
		ADD_DBQ(&ospf.db_free_list, dbi->db);
	    }

	    /*
	     * Subtract chksum for MIBness
	     */
	    if (LS_TYPE(dbi->db) < LS_ASE)
	    	dbi->area->db_chksumsum -= old_cks;
	    else 
	    	ospf.db_chksumsum -= old_cks;

	}

	LL_ALLOC(ll);
	ll->lsdb = dbi->db;
	/*
         * put on appropriate list for flooding and update new checksum sum
         */
	if (LS_TYPE(dbi->db) < LS_ASE) {
	    EN_Q((*trans), ll)
	    /*
	     * Update area chksumsum for MIB
	     */
	    dbi->area->db_chksumsum += LS_CKS(dbi->db);
	} else {
	    EN_Q((*asetrans), ll);
	    ospf.db_chksumsum += LS_CKS(dbi->db);
	}

	/*
         * note when it came it
         */
	DB_TIME(dbi->db) = dbi->sec;

	/*
         * will add non-direct acks in flood()
         */
    } else if (SAME_INSTANCE(&(dbi->adv.rtr->ls_hdr),
			     &(DB_RTR(dbi->db)->ls_hdr),
			     dbi->diff)) {
	if (dbi->nbr->state < NFULL) {	/* remove from req list */
	    /* Out of sync with nbr's state machine */
	    if (nbr_rem_req(dbi->nbr, dbi->adv)) {
		(*(nbr_trans[BAD_LS_REQ][dbi->nbr->state]))(dbi->intf,dbi->nbr);
		return (FLAG_BAD_REQ);
	    }
	}
	/* count same instance as ack, remove from nbrs list */
	/* remove from db */
	rem_nbr_ptr(dbi->db, dbi->nbr);
	/* remove from nbr */
	implied_ack = rem_db_ptr(dbi->nbr, dbi->db);
	if (implied_ack &&
	    (dbi->intf->state == IBACKUP
	     && dbi->nbr->nbrip_addr == dbi->intf->dr->nbrip_addr))
	    add_ack(&(dbi->intf->acks), dbi->db);
	/*
         * if MaxAge and not retrans queue, remove from lsdb
         */
	else if (implied_ack &&
		 DB_CAN_BE_FREED(dbi->db) &&
		 ADV_AGE(dbi->db, dbi->sec) >= MaxAge)
	    db_free(dbi->db);
	/* send direct ack */
	else if (!implied_ack)
	    add_ack(acks, dbi->db);
    } else {				/* Less recent LSA */
	if (dbi->nbr->state < NFULL) {	/* remove from req list */
	    /* Out of sync with nbr's state machine */
	    if (nbr_rem_req(dbi->nbr, dbi->adv)) {
		(*(nbr_trans[BAD_LS_REQ][dbi->nbr->state]))(dbi->intf,dbi->nbr);
		return (FLAG_BAD_REQ);
	    }
	}
	RX_LOG(dbi->mc, UNUSUAL_INSTANCE, dbi->intf->ifspfndx, dbi->nbr->nbrip_addr);
    }
    return (spfsched);
}

int
RxLinkUp(lsup, intf, ipsrc, rtrid, olen, mc)
struct LS_UPDATE_HDR *lsup;
struct INTF *intf;
u_long32 ipsrc, rtrid;
int olen;
int mc;				/* multicast rx flag */
{

    struct DB_INFO dbi;
    int i;			/* length of adv */
    int spfsched = 0;
    int reqcnt;			/* current number of requests on nbr->ls_req */
    struct NBR *n = NBRNULL;
    struct LSDB *dbnext = LSDBNULL;

    /* list of lsdbs to be sent */
    struct LSDB_LIST *trans = LLNULL, *asetrans = LLNULL;
    struct LSDB_LIST *src_trans = LLNULL, *src_asetrans = LLNULL;

    /* list of direct acks to be sent */
    struct ACK_LIST *acks = (struct ACK_LIST *) 0;
    struct AREA *a;
    struct INTF *ifp;
    u_short16 newage;
    u_short16 chk;

    dbi.intf = intf;
    dbi.foundlsa = TRUE;
    dbi.area = AREA_PTR(intf); /* area received from */
    dbi.nbr = NBRNULL;

    /* Locate nbr */
    n = FirstNbr(intf);
    if (intf->type > NONBROADCAST) {
	if (n->nbr_id == rtrid)
	    dbi.nbr = n;
    } else
	for (; n != NBRNULL; n = n->next) {
	    if (ipsrc == n->nbrip_addr) {
		dbi.nbr = n;
		break;
	    }
	}

    if (dbi.nbr == NBRNULL)
	return (CANT_FIND_NBR2);
    if (dbi.nbr->state < NEXCHANGE)
	return (LOW_NBR_STATE2);

    /* log count of ls_reqests */
    reqcnt = dbi.nbr->reqcnt;
    force_flood = 0;		/* use if self_orig and build rtr or net */

    dbi.sec = ospf_get_time();	/* get time to check for MaxAge */
    lsup->adv_cnt = ntohl(lsup->adv_cnt);

    for (i = 0, dbi.adv.rtr = (struct RTR_LA_HDR *) & (lsup->adv.rtr);
	 i < lsup->adv_cnt && olen;
	 i++,
	 olen -= dbi.len,
	 dbi.adv.rtr = (struct RTR_LA_HDR *) ((long) dbi.adv.rtr + dbi.len)) {
	dbi.len = ntohs(dbi.adv.rtr->ls_hdr.length);
	newage = dbi.adv.rtr->ls_hdr.ls_age;
	dbi.adv.rtr->ls_hdr.ls_age = 0;

	chk = dbi.adv.rtr->ls_hdr.ls_chksum;
	fletch((char *) (dbi.adv.rtr), dbi.len);
	if (chk != dbi.adv.rtr->ls_hdr.ls_chksum) {
	    RX_LOG(mc, BAD_LS_CHKSUM, intf->ifspfndx, dbi.nbr->nbrip_addr);
	    continue;
	}

	if (dbi.adv.rtr->ls_hdr.ls_type < LS_RTR ||
	    dbi.adv.rtr->ls_hdr.ls_type > LS_ASE) {
	    RX_LOG(mc, BAD_LSA_TYPE, intf->ifspfndx, dbi.nbr->nbrip_addr);
	    continue;
	}

	/* If stub area and type is ASE continue */
	if ( (dbi.area->ext_option != EXT_OPT_NORMAL) && 
	     (dbi.adv.rtr->ls_hdr.ls_type == LS_ASE) )
	    continue;

	/* put back age in host order */
	dbi.adv.rtr->ls_hdr.ls_age = ntohs(newage);

	if (!(QueueChk(QAck,0)))
	    goto nobufs;

	if (!(XAddLSA(&(dbi.db), dbi.area, dbi.adv.rtr, 0))) {
	    dbi.foundlsa = FALSE;
	    dbi.diff = 0;
	    /* 
	     * not found, if MaxAge remove from req lists and drop 
	     */
	    if (dbi.adv.rtr->ls_hdr.ls_age >= MaxAge) {
		if (!dbi.db)
	    	    goto nobufs;

		/*
		 * Enough memory to put on all retrans queues?
		 */
		if (!(QueueChk(dbi.adv.rtr->ls_hdr.ls_type,dbi.area)))
	    	    goto nobufs;

		ADV_ALLOC(dbi.db,
			  dbi.adv.rtr->ls_hdr.ls_type,
			  dbi.len);

		/* 
		 * No memory - undo a couple of things... 
		 */
		if (!DB_NET(dbi.db)) {
	    	    /* MODIFIED 1/17 */
	    	    ospf.db_cnt--;
		    if (dbi.adv.rtr->ls_hdr.ls_type == LS_ASE)
			ospf.db_ase_cnt--;
		    else {
			dbi.area->db_cnts[dbi.adv.rtr->ls_hdr.ls_type]--;
    			dbi.area->db_int_cnt--;
		    }
		    db_free(dbi.db);
		    goto nobufs;
		}

		ADV_COPY(dbi.adv.net, DB_NET(dbi.db), dbi.len);
		add_ack(&acks, dbi.db);
		if (dbi.nbr->state < NFULL) {	/* remove from req list */
		    nbr_rem_req(dbi.nbr, dbi.adv);
		    if (NO_REQ(dbi.nbr))
		  	(*(nbr_trans[LOAD_DONE][dbi.nbr->state]))(intf,dbi.nbr);
		}
		/* A bit strange to do an add then a delete but mostly
		   the adv won't be maxage - saves doing a find then an add */
		DB_FREEME(dbi.db) = TRUE;
		ADD_DBQ(&ospf.db_free_list, dbi.db);
		continue;
	    }
	} else {
	    dbi.foundlsa = TRUE;
	    dbi.diff = dbi.sec - DB_TIME(dbi.db);	/* For the NEW AGE */
#ifdef DBG
	    sprintf(_ospf_prt_buf,"setting diff to %d sec: %d time: %d\n",
			dbi.diff,dbi.sec,DB_TIME(dbi.db));
	    DBG_LOG(_ospf_prt_buf);
#endif
	}
	/* check for self originated lsa */
	if (dbi.adv.rtr->ls_hdr.adv_rtr == MY_ID) {
	    spfsched |= rx_self_orig(&dbi, &src_trans, &src_asetrans, &acks);
	} else {
	    spfsched |= not_my_lsa(&dbi, &trans, &asetrans, &acks);
	}

	if (spfsched & (FLAG_NO_BUFS | FLAG_BAD_REQ)) {
	    break;
	}
    }

  nobufs:				/* have run out of buffers... */

    /*
     * Flood new self originated ls_ase
     */
    if (src_asetrans != LLNULL) {
	for (a = FirstArea; a < &(ospf.area[ospf.acnt]); a++)
	    if (a->ext_option == EXT_OPT_NORMAL)
		self_orig_area_flood(a, src_asetrans, LS_ASE);
	freeq(&src_asetrans, OMEM_LL);
    }
    /*
     * Flood local to this area
     */
    if (trans != LLNULL) {
/* MODIFIED 2/5/92 removed param */
	area_flood(dbi.area,
		   trans,
		   intf,
		   dbi.nbr,
		   LS_RTR);
	freeq(&trans, OMEM_LL);
    }
    /*
     * Flood other than this RTR's LS_ASEs
     */
/* MODIFIED 2/5/92 removed param */
    if (asetrans != LLNULL) {
	for (a = FirstArea; a < &(ospf.area[ospf.acnt]); a++)
	    if (a->ext_option == EXT_OPT_NORMAL)
		area_flood(a,
			   asetrans,
			   intf,
			   dbi.nbr,
			   LS_ASE);
	freeq(&asetrans, OMEM_LL);
    }
    /*
     * load done event has occurred, build_rtr LSA and net LSA
     */
    if (dbi.area->build_rtr) {
	dbi.area->build_rtr = FALSE;
	spfsched |= build_rtr_lsa(dbi.area,
				  &src_trans,
				  (PTYPE_BIT(LS_RTR) & force_flood));
    }
    /*
     * Build net LSAs for intfs scheduled to do so while parsing this pkt
     */
    for (ifp = dbi.area->intf;
	 ifp < &(dbi.area->intf[dbi.area->ifcnt]);
	 ifp++) {
	if (ifp->build_net)
	    spfsched |= build_net_lsa(ifp,
				      &src_trans,
				      (PTYPE_BIT(LS_NET) & force_flood));
    }

    /*
     * flood new self-originated LSAs
     */
    if (src_trans != LLNULL) {
	self_orig_area_flood(dbi.area, src_trans, LS_NET);
	freeq(&src_trans, OMEM_LL);
    }
    /*
     * Send direct ack
     */
    if (acks != ACKNULL)
	send_ack(intf, dbi.nbr, &acks, TRUE);
    /*
     * Topology change in area or load done has occurred
     */
    dbi.area->spfsched |= (spfsched & ALLSCHED);

    if (dbi.area->spfsched)
	PARTIAL_RUN_SPF(dbi.area);

    /*
     * if any requests were acked, send new request pkt
     */
    if (dbi.nbr->state > NEXSTART && dbi.nbr->reqcnt < reqcnt)
	send_req(intf, dbi.nbr, 0);

    /*
     *  Check to-be-free list
     */
    for (dbi.db = DB_PTR(&(ospf.db_free_list))[NEXT]; dbi.db; dbi.db = dbnext) {
	dbnext = DB_PTR(dbi.db)[NEXT];
	if (DB_CAN_BE_FREED(dbi.db))
	    db_free(dbi.db);
    }
    return (GOOD_RX);
}

#endif				/* PROTO_OSPF */
