/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991               	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#include "ospf.h"

#ifdef	PROTO_OSPF

/*
 * Event: new lsa generated and Area's LINK_LIST has pointer to
 *  all neighbors: link_ptr in nbr has to be removed
 *	- search for link pointer and remove it from a neighbor's list
 *	- remove from nbr
 */
int
rem_db_ptr(nbr, db)
struct NBR *nbr;
struct LSDB *db;
{
    struct DBRT_LIST *lp = nbr->retrans;

    for (; lp != DBRTNULL; lp = lp->ptr[NEXT])
	if (lp->lsdb == db) {
	    REM_Q((nbr->retrans), lp, NUKE, OMEM_DBRT);
	    nbr->rtcnt -= 1;
	    return (TRUE);
	}
    return (FALSE);
}


/*
 * Event: ack has been received and neighbor has pointer to LINK_LIST
 *	  or nbr's state has dropped and are freeing nbr's lsdb list
 *	- search for nbr pointer in lsdb's nbr list and remove it from list
 */
int
rem_nbr_ptr(db, nbr)
struct LSDB *db;
struct NBR *nbr;
{
    struct NBR_LIST *nl;

    if (NO_GUTS(db))
	adios("GUTS BE NULL\n");
    for (nl = DB_RETRANS(db); nl != NLNULL; nl = nl->ptr[NEXT])
	if (nl->nbr == nbr) {
	    if (nbr == NBRNULL)
		DBG_LOG("rem_nbr_ptr : nbr is null");
	    REM_Q((DB_RETRANS(db)), nl, NUKE, OMEM_NL);
	    return (TRUE);
	}
    return (FALSE);
}

void
freeq(qhp, type)
struct Q **qhp;
int type;
{
    struct Q *q;

    for (q = *qhp; *qhp != QNULL;) {
	*qhp = q->ptr[NEXT];
	ZAP(((char *) q), type);
	q = *qhp;
    }
}

/*
 *  add_nbr_retrans - add an lsdb ptr to the nbr's retrans list
 */
void
add_nbr_retrans(nbr, db)
struct NBR *nbr;
struct LSDB *db;
{
    struct DBRT_LIST *ll;

    DBRT_ALLOC(ll);
    ll->lsdb = db;
    EN_Q((nbr->retrans), ll);
    nbr->rtcnt += 1;
}

/*
 *  add_db_retrans - add a nbr ptr to the lsdb's retrans list
 */
void
add_db_retrans(db, nbr)
struct LSDB *db;
struct NBR *nbr;
{
    struct NBR_LIST *nl;

    NL_ALLOC(nl);
    nl->nbr = nbr;
    EN_Q((DB_RETRANS(db)), nl);
}


/*
 * rem_db_retrans - clear lsdb's retrans list and free lsdb prtr from neighbors
 */
void
rem_db_retrans(db)
struct LSDB *db;
{
    struct NBR_LIST *nl, *next_nl;

    /* remove from all nbrs' lists */
    for (nl = DB_RETRANS(db); nl != NLNULL; nl = next_nl) {
	next_nl = nl->ptr[NEXT];
	/* remove from nbr */
	rem_db_ptr(nl->nbr, db);
	/* remove from lsdb's nbr list */
	REM_Q((DB_RETRANS(db)), nl, NUKE, OMEM_NL);
    }
    DB_RETRANS(db) = NLNULL;
}

/*
 * rem_nbr_retrans - remove all lsdb ptrs from nbr retrans list
 */
void
rem_nbr_retrans(nbr)
struct NBR *nbr;
{
    struct DBRT_LIST *ll, *next_ll;

    /* remove from all nbrs' lists */
    for (ll = nbr->retrans; ll != DBRTNULL; ll = next_ll) {
	next_ll = ll->ptr[NEXT];
	/* remove from lsdb */
	if (NO_GUTS(ll->lsdb))
	    adios("GUTS BE NULL in rem_nbr_retrans");
	rem_nbr_ptr(ll->lsdb, nbr);
	/* remove from nbr's retrans list */
	REM_Q((nbr->retrans), ll, NUKE, OMEM_DBRT);
    }
    nbr->retrans = DBRTNULL;
    nbr->rtcnt = 0;
}


/*
 * Free nbr's db summary list
 */
void
freeDbSum(nbr)
struct NBR *nbr;
{
    struct LSDB_SUM *nextd;

    for (nextd = nbr->dbsum; nextd != LSDB_SUM_NULL;) {
	nbr->dbsum = nextd->next;
	DB_ZAP_PKT(nextd);
	ZAP(nextd, OMEM_DBSUM);
	nextd = nbr->dbsum;
    }
    nbr->dbsum = LSDB_SUM_NULL;
    nbr->dbcnt = 0;
}

/*
 * Free nbr's ls request list
 */
void
freeLsReq(nbr)
struct NBR *nbr;
{
    int type;

    for (type = LS_RTR; type <= LS_ASE; type++) {
	if (nbr->ls_req[type] != LS_REQ_NULL)
	    freeq((struct Q **)&(nbr->ls_req[type]), OMEM_LS_REQ);
	nbr->ls_req[type] = LS_REQ_NULL;
    }
    nbr->reqcnt = 0;
}

/*
 * Free list of acks to be sent to this nbr
 */
void
freeAckList(intf)
struct INTF *intf;
{
    struct ACK_LIST *ack;

    for (ack = intf->acks; ack != ACKNULL;) {
	intf->acks = ack->ptr[NEXT];
	DB_ACK_CNT(ack->db) -= 1;
	ZAP(ack, OMEM_ACKLST);
	ack = intf->acks;
    }
    intf->acks = ACKNULL;
}


/*
 * add_ack: add acks to link list - used to call send_ack
 */
void
add_ack(qhp, db)
struct ACK_LIST **qhp;
struct LSDB *db;
{
    struct ACK_LIST *ack;

    /*
     * Don't add duplicate acks
     */
    for (ack = *qhp; ack != ACKNULL; ack = ack->ptr[NEXT])
	if (ack->db == db)
	    return;
    ACKLST_ALLOC(ack);
    ack->db = db;
    DB_ACK_CNT(db) += 1;
    EN_Q((*qhp), ack);
}

/*
 * Add neighbor to NBMA or BROADCAST intf in sorted order
 */
void
nbr_enq(intf,nbr)
struct INTF *intf;
struct NBR *nbr;
{
    struct NBR *last_nbr;

    for (last_nbr = &(intf->nbr);;last_nbr = last_nbr->next)
    {
        if ( (last_nbr->next == NBRNULL) ||
	     (ntohl(last_nbr->next->nbrip_addr) > ntohl(nbr->nbrip_addr)) )
	{
	    nbr->next = last_nbr->next;
	    last_nbr->next = nbr;
	    break;
        }
    }
    ospf.nbrcnt++;
    ospf.nbr_sb_not_valid = TRUE;
}

/*
 * Add net range to area in sorted order for ease of MIB ness
 */
void
range_enq(area,range)
struct AREA *area;
struct NET_RANGE *range;
{
    struct NET_RANGE *nr;

    for(nr = &(area->nr);;nr = nr->ptr[NEXT])
    {
        if ( (nr->ptr[NEXT] == NRNULL) ||
	     (ntohl(nr->ptr[NEXT]->net) > ntohl(range->net)) )
	{
	    ADD_Q(nr, range);
	    return;
        }
    }
}

/*
 * Add host to area in sorted order for ease of MIB ness
 */
void
host_enq(area,host)
struct AREA *area;
struct OSPF_HOSTS *host;
{
    struct OSPF_HOSTS *h;

    for(h = &(area->hosts);;h = h->ptr[NEXT])
    {
        if ( (h->ptr[NEXT] == HOSTSNULL) ||
	     (ntohl(h->ptr[NEXT]->if_addr) > ntohl(host->if_addr)) )
	{
	    ADD_Q(h, host);
	    return;
        }
    }
}
#endif				/* PROTO_OSPF */
