/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991               	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#include "ospf.h"

#ifdef	PROTO_OSPF

/*
 * 		Link State Db stuff
 */


/*
 * addLSA 		Add lsa to the linked list
 */
int
addLSA(db, area, key0, key1, data, type)
struct LSDB **db;
struct AREA *area;
u_long32 key0, key1;
void *data;
int type;
{
    struct LSDB *e, *hp;
    int hash = XHASH(key0, key0);

    if (type > LS_ASE)
	adios("AddLSA: LSDB bad type");
    /* 
     * First key 
     */
    for (hp = (e = &(area->htbl[type][hash]));
	 (DB_NEXT(e) != LSDBNULL) && (key0 < DB_NEXT(e)->key[0]);
	 e = DB_NEXT(e)) ;

    if ((DB_NEXT(e) == LSDBNULL) || (DB_NEXT(e)->key[0] != key0))
	goto install;

    /* 
     * Ls id is all that is needed for LS_NET && LS_RTR 
     */
    if (type == LS_NET || type == LS_RTR) {
	*db = DB_NEXT(e);
	if (NO_GUTS(*db))
	    goto install2;
	return (TRUE);
    }

    /* 
     * handle second key 
     */
    if (DB_NEXT(e)->key[1] == key1) {	/* may have found it */
	/* had it at one time? */
	*db = DB_NEXT(e);
	if (NO_GUTS(*db))
	    goto install2;
	return (TRUE);
    }

    /* 
     * install *db as e->lsdbnext 
     */
    if (DB_NEXT(e) == LSDBNULL || key1 > DB_NEXT(e)->key[1])
	goto install;

    /* 
     * else e->lsdbnext->key[1] > key1 so find where to install 
     */
    for (; DB_NEXT(e) != LSDBNULL &&
	 key0 == DB_NEXT(e)->key[0] &&
	 key1 < DB_NEXT(e)->key[1];
	 e = DB_NEXT(e)) ;

    if (DB_NEXT(e) != LSDBNULL &&
	(DB_NEXT(e)->key[1] == key1) &&
	(DB_NEXT(e)->key[0] == key0)) {
	*db = DB_NEXT(e);
	if (NO_GUTS(*db))
	    goto install2;
	return (TRUE);
    }

  install:

    DB_ALLOC((*db));
    if (!(*db))
	return(FALSE);
    DB_COUNT(hp) += 1;
    DB_NEXT(*db) = DB_NEXT(e);
    DB_NEXT(e) = *db;

  /* 
   * had a previously used one around 
   */
  install2:				
    (*db)->key[0] = key0;
    (*db)->key[1] = key1;
    DBGUTS_ALLOC(*db);
    if (NO_GUTS(*db)) {
	(*db) = LSDBNULL;
	return(FALSE);
    }
    DB_RTR(*db) = (struct RTR_LA_HDR *) data;
    DB_FREEME(*db) = FALSE;
    DB_DIST(*db) = (type < LS_SUM_NET) ? RTRLSInfinity : SUMLSInfinity;
    DB_MYHASH(*db) = hash;
    DB_MY_AREA_NDX(*db) = area->area_ndx;

    switch(type)
    {
	case LS_STUB:
    		area->db_cnts[type]++;
		break;

	case LS_RTR:
	case LS_NET:
	case LS_SUM_NET:
	case LS_SUM_ASB:
		/* MODIFIED 1/17 */
		ospf.db_cnt++;
    		area->db_cnts[type]++;
    		area->db_int_cnt++;
		break;

	case LS_ASE:
		/* MODIFIED 1/17 */
		ospf.db_cnt++;
		ospf.db_ase_cnt++;
		break;
    }

    /*
     * If a new db entry has been added within
     * the range of area and type mark sb invalid 
     */
    if (ospf.ls_sb && 
	ospf.sb_ls_type == type && 
	area->area_ndx == ospf.sb_area_ndx)
	ospf.sb_not_valid = TRUE;

    /* 
     * successful add, not found 
     */
    return (FALSE);
}

/*
 * findLSA 		Add sum lsa or ase lsa to the linked list
 */
struct LSDB *
findLSA(hp, key0, key1, type)
struct LSDB *hp;
u_long32 key0, key1;
int type;
{
    struct LSDB *e = hp;

    if (type > LS_ASE)
	adios("FindLSA: LSDB bad type");
    /* 
     *  First key 
     */
    for (; (DB_NEXT(e) != LSDBNULL) && (key0 < DB_NEXT(e)->key[0]);
	 e = DB_NEXT(e)) ;
    if ((DB_NEXT(e) == LSDBNULL) ||
	(DB_NEXT(e)->key[0] != key0))
	return (LSDBNULL);

    /* 
     * LS_NET and LS_RTR just use ls id 
     */
    if (type == LS_NET || type == LS_RTR) {
	if (GOT_GUTS(DB_NEXT(e)))
	    return (DB_NEXT(e));
	else
	    return (LSDBNULL);
    }

    /* 
     * handle second key 
     */
    if (key1 > DB_NEXT(e)->key[1])
	return (LSDBNULL);

    if (DB_NEXT(e)->key[1] == key1) {
	if (GOT_GUTS(DB_NEXT(e)))
	    return (DB_NEXT(e));
	else
	    return (LSDBNULL);
    }

    /* 
     * else e->lsdbnext->key[1] > key1 so contunue to search 
     */
    for (; (DB_NEXT(e) != LSDBNULL) &&
	 (key0 == DB_NEXT(e)->key[0]) &&
	 (key1 < DB_NEXT(e)->key[1]);
	 e = DB_NEXT(e)) ;

    if (DB_NEXT(e) != LSDBNULL &&
	(DB_NEXT(e)->key[1] == key1) &&
	(DB_NEXT(e)->key[0] == key0) &&
	(GOT_GUTS(DB_NEXT(e))))
	return (DB_NEXT(e));

    return (LSDBNULL);
}

/*
 * free a db entry
 *	- called by RxLsAck, RxLinkUp or tq_dbage
 *	- spf will have just been run so parent list and routes will have
 * 	  been freed
 *	- leave entry around db age will free the rest for
 *	  LS_ASE and LS_SUM_NET else since most other entries may be back
 *	  just free structure
 */
void
db_free(db)
struct LSDB *db;
{
    struct AREA *area;

    /* 
     * Still some outstanding acks? Wait untill dbfreelist is scanned again
     */
    if (NO_GUTS(db) || DB_ACK_CNT(db) > 0)
	return;
    FREE_LOG((DB_RTR(db) == ADVNULL) || (NO_GUTS((db))) ?
		"Unknown" : ls_types[LS_TYPE(db)],
	     lntoa(db->key[0]),
	     lntoa(db->key[1]));
    LOG_LSDB(2,
	     MY_ID,
	     NO_GUTS((db)) ? "Unknown" : ls_types[LS_TYPE(db)],
	     lntoa(db->key[0]),
	     lntoa(db->key[1]));

    if (DB_RTR(db) != ADVNULL)
    {
	area = &ospf.area[DB_MY_AREA_NDX(db)];
    	switch(LS_TYPE(db))
    	{
	    case LS_STUB:
    		area->db_cnts[LS_STUB]--;
		break;

	    case LS_RTR:
	    case LS_NET:
	    case LS_SUM_NET:
	    case LS_SUM_ASB:
		/* MODIFIED 1/17 */
	    	ospf.db_cnt--;
    		area->db_cnts[LS_TYPE(db)]--;
    		area->db_int_cnt--;
	    	area->db_chksumsum -= LS_CKS(db);
		break;

	    case LS_ASE:
		/* MODIFIED 1/17 */
	    	ospf.db_cnt--;
		ospf.db_ase_cnt--;
	    	ospf.db_chksumsum -= LS_CKS(db);
		break;
    	}

     	/*
     	 * If a new db entry has been added within
     	 * the range of area and type mark sb invalid 
     	 */
    	if (ospf.ls_sb && 
	    ospf.sb_ls_type == LS_TYPE(db) && 
	    area->area_ndx == ospf.sb_area_ndx)
	    ospf.sb_not_valid = TRUE;
	DBADV_FREE(db, LS_TYPE(db));
    }

    /* 
     * Free from current queue 
     */
    DEL_DBQ(db);
    DB_FREEME(db) = FALSE;
    if (GOT_GUTS(db))
	DBGUTS_FREE(db);
}

#endif				/* PROTO_OSPF */
