/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991               	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   **     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#ifdef AVL_DEBUG
#include <stdio.h>
#include <math.h>			/* for log() */
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif

#define BALANCED     0			/* neither subtree is heavy */
#define RIGHT        1			/* right subtree is heavy */
#define LEFT         2			/* left subtree is heavy  */
#define EMPTY        3			/* returned by find_exact if empty tree */

#define EQUAL        0			/* good comaprison from compare() */


#define OPP(A) (((A) == LEFT) ? RIGHT : LEFT)

#define LLINK 	0
#define RLINK 	1

struct NODE_INFO {
    u_char delete;		/* True if route has been deleted */
    u_char balanced;		/* Tree node balanced? */
    u_char direct;		/* True if route is directly connected*/
    u_char owner;
    u_char nh_ndx[MAXNH];	/* Index of interface to this net */
    u_char preference;		/* Preference of route chosen */
    u_short is_discard;		/* True if discard route */
    u_short nh_cnt;		/* Number of nh entries */
    struct LSDB *db;		/* For exporting non-ospf routes into ospf */
};

struct avl_node {
    struct avl_node *ptr[2];
    u_long dest;			/* IP address of routing table entry */
    u_long mask;			/* Mask associated with IP address */
    struct NODE_INFO node;
    struct static_rt_info *static_rt_info;
    struct ospf_rt_info *ospf_rt_info;
};

typedef struct avl_node AVL;

#define AVLNULL ((AVL *)0)

AVL **__rt_top;				/* index to top the stack */
AVL *stack[50];
AVL avl_dflt_rt;			/* default route */

#define push(N) *(++__rt_top) = (N)
#define reset_stack()	__rt_top = stack


/* For accessing members of a tree node */
#define avl_addr	dest
#define avl_mask	mask
#define avl_nh_ndx	node.nh_ndx
#define avl_nh_cnt	node.nh_cnt
#define avl_balanced	node.balanced
#define avl_left	node.left
#define avl_right	node.right
#define avl_delete	node.delete
#define avl_direct	node.direct
#define avl_owner	node.owner
#define avl_pref	node.preference
#define avl_discard	node.is_discard
#define avl_rt_info 	node
#define avl_ort_info 	ospf_rt_info
#define avl_ext_db	node.db
