/************************************************************************/
/*	Routing Protocol Simulator	Release 1.0	1994/3/17	*/
/*                                              1.21    1997/2/10       */
/*									*/
/*		module 	: protocol procedure	      			*/
/*		file	: rps_icmp.h			       		*/
/*									*/
/*   Copyright (c) 1994-1997 by Systems Development Laboratory Hitachi,	*/
/*   Ltd. All rights reserved.						*/
/*----------------------------------------------------------------------*/
/*	UPDATE HISTORY							*/
/*									*/
/************************************************************************/

#define IPPROTO_ICMP	1

struct PROTO_ICMP {
    byte type;
    byte code;
    u_short cksum;
    union {
	byte para_prob;
	struct in_addr rdirect_gw;
	struct _echo {
	    short id;
	    short seq;
	} echo ;
	int unused;
    } icmp_un;
    union {
	struct _icmp_data {
	    char ip_data[64];
	} icmp_data;
	u_int id_mask;
    } icmp_dun;
};

#define prob		icmp_un.para_prob
#define rd_gw		icmp_un.rdirect_gw
#define echo_id		icmp_un.echo.id
#define echo_seq	icmp_un.echo.seq
#define unused		icmp_un.unused
/*
#define ip_data		icmp_dun.icmp_data
#define mask		icmp_dun.id_mask
*/
#define ICMP_ECHOREPLY		0
#define ICMP_UNREACH		3
#define ICMP_SRCQUENCH		4
#define ICMP_REDIRECT		5
#define ICMP_ECHO		8
#define ICMP_TIMEEXCEED		11
#define ICMP_PRAMPROB		12
#define ICMP_TIMESTAMP		13
#define ICMP_TIMESTAMPRPLY	14

/* ICMP dest unreachable subcodes */
#define NET_UNREACH		0
#define HOST_UNREACH		1
#define PROTO_UNREACH		2
#define PORT_UNREACH		3
#define FRAG_NEED		4
#define SRC_RT_FAIL		5
