/************************************************************************/
/*	Routing Protocol Simulator	Release 1.0	1994/3/17	*/
/*                                              1.21    1997/2/10       */
/*									*/
/*		module 	: protocol procedure	   	      		*/
/*		file	: rps_bgp.h			      		*/
/*									*/
/*   Copyright (c) 1994-1997 by Systems Development Laboratory Hitachi,	*/
/*   Ltd. All rights reserved.						*/
/*----------------------------------------------------------------------*/
/*	UPDATE HISTORY							*/
/*									*/
/************************************************************************/
#ifdef VXWORKS

#include "types.h"

#else

/*#include <sys/stdtypes.h>*/

#endif


#define	BGPMNGID_MAXLENGTH 	32

#define BGP_PORT 179


#define BGP_VERSION_2		2
#define BGP_VERSION_3		3

#define BGP_HOLDTIME		180
#define BGP_HOLDTIME_MAX	65535
#define BGP_HOLDTIME_MIN	0

#define BGP_METRIC_MAX		65535
#define BGP_METRIC_MIN		0

struct proto_bgp {
    char mng_id[BGPMNGID_MAXLENGTH];
    u_long router_id;
    u_int version;
    time_t holdtime;
    u_int local_as;
    u_int state;
    struct if_addr *myaddr;
    struct if_addr *peeraddr;
    u_int peer_as;
    u_long peer_id;
};

#define BGP_HEADER_LEN		19
#define BGP_MARKER_LENGTH	16

struct bgp_header {
    u_char marker[BGP_MARKER_LENGTH];
    int length;
    u_char type;
};

/* BGP message type */

#define BGP_MSG_NONE		0
#define BGP_MSG_OPEN		1
#define BGP_MSG_KEEPALIVE	2
#define BGP_MSG_UPDATE		3
#define BGP_MSG_NOTIFY		4

#define BGP_OPEN2_MIN_LEN	6
#define BGP_OPEN3_MIN_LEN	10

struct bgp2_open {
    u_char version;
    int my_as;
    int holdtime;
    u_char authcode;
};

struct bgp3_open {
    u_char version;
    int my_as;
    int holdtime;
    u_long bgp_id;
    u_char authcode;
};

#define BGP_KEEPALIVE_MIN_LEN 	19

#define BGP_UPDATE_MIN_LEN	2


#define BGP_ERR_HEADER		1
#define BGP_ERR_OPEN		2
#define BGP_ERR_UPDATE		3
#define BGP_ERR_HOLDTIME	4
#define BGP_ERR_FSM		5
#define BGP_CEASE		6

/* protocol state */
#define BGP_STATE_IDLE		1
#define BGP_STATE_CONNECT	2
#define BGP_STATE_ACTIVE	3
#define BGP_STATE_OPENSENT	4
#define BGP_STATE_OPENCONFIRM	5
#define BGP_STATE_ESTABLISHED	6

/* Events */
#define BGP_EVENT_NOTHING	0
#define BGP_EVENT_START		1
#define BGP_EVENT_STOP		2
#define BGP_EVENT_OPEN		3
#define BGP_EVENT_CLOSE		4
#define BGP_EVENT_OPENFAIL	5
#define BGP_EVENT_ERROR		6
#define BGP_EVENT_CONNECTRETRY	7
#define BGP_EVENT_HOLDTIME	8
#define BGP_EVENT_KEEPALIVE	9
#define BGP_EVENT_RECVOPEN	10
#define BGP_EVENT_RECVKEEPALIVE 11
#define BGP_EVENT_RECVUPDATE	12
#define BGP_EVENT_RECVNOTIFY	13

#define OKOK			1
#define FAILED			0
    










