/************************************************************************/
/*	Routing Protocol Simulator	Release 1.0	1994/3/17	*/
/*                                              1.21    1997/2/10       */
/*									*/
/*		module 	: protocol procedure	       			*/
/*		file	: ospf_type.h			       		*/
/*									*/
/*   Copyright (c) 1994-1997 by Systems Development Laboratory Hitachi,	*/
/*   Ltd. All rights reserved.						*/
/*----------------------------------------------------------------------*/
/*	UPDATE HISTORY	1996.7.10 add struct LS_ACK			*/
/*									*/
/************************************************************************/
#include "lsdb.h"

#define INTF_MTU	1024

#define OSPF_HDR_SIZE		24

struct OSPF_HDR {
    u_char	ver;
    u_char	type;
    u_short 	length;
    u_long	rt_id;
    u_long	area_id;
    u_short	chcksum;
    u_short	authtype;
    u_long	auth[2];
};

#define OSPF_HELLO_PKT		1
#define OSPF_DB_PKT		2
#define OSPF_LS_REQ_PKT		3
#define OSPF_LS_UPDATE_PKT	4
#define OSPF_LS_ACK_PKT		5

#define	HELLO_PACKET_SIZE	20

struct HELLO_PKT {
    struct OSPF_HDR hdr;
    u_long netmask;
    u_short hello_int;
    u_char options;
    u_char priority;
    u_long dead_int;
    u_long dr;
    u_long bdr;
    u_long nbr;
};

#define T_OPTION	0x01
#define E_OPTION	0x02


#define DB_PACKET_SIZE	8

struct DB_PKT {
    struct OSPF_HDR hdr;
    u_short	reserve;
    u_char	options;
    u_char	db_bit;
    long	seq;
    struct LS_HDR db;
};

#define	INIT		0x04
#define MORE		0x02
#define MASTER_SLAVE	0x01


#define LS_REQ_PACKET_SIZE	12

struct LS_REQ_PKT {
    struct OSPF_HDR hdr;    
    u_short	reserve1;
    u_char	reserve2;
    u_char	ls_type;
    u_long	ls_id;
    u_long	adv_rt;
};

union	ADV_LSDB {
    struct LS_RT_HDR rt;
    struct LS_NET_HDR net;
    struct LS_SUM_HDR sum;
    struct LS_ASE_HDR ase;
};

#define	LS_UPDATE_PACKET_SIZE	4

struct LS_UPDATE_PKT {
    struct OSPF_HDR hdr;    
    u_long	adv_num;
    union ADV_LSDB adv;
};

#define LS_ACK_PACKET_SIZE	4

struct LS_ACK_PKT {
    struct OSPF_HDR hdr;    
    struct LS_HDR lsh;
};

union OSPF_PKT {
    struct HELLO_PKT		hello;
    struct DB_PKT		db;
    struct LS_REQ_PKT		ls_req;
    struct LS_UPDATE_PKT	ls_update;
    struct LS_ACK_PKT		ls_ack;
};

struct DB_SUM {
    struct DB_SUM *next;
    struct DB_PKT *db;
    long len;
    short db_num;
    char *rt_table;
};

struct LS_REQ {
    struct LS_REQ *next;
    u_short ls_type;
    u_long ls_id;
    u_long adv_rt;
    u_long ls_seq;
    u_short ls_chksum;
    u_short ls_len;

};

/*
  add 1996.7.10
*/
struct LS_ACK {
    struct LS_ACK *next;
    struct LS_HDR lsh;
};

#define NBR_NUM(num,nbr) \
  	{ \
	    struct ospf_nbr *n; \
	    for(num=0,n=nbr;n;n=n->next,num++); \
	}


#define REQ_LIST_FREE(list) \
	{ \
	    struct LS_REQ *req,*nreq; \
	    for(req=list;req;) { \
	        nreq = req->next; \
		free((char *)req); \
		req = nreq; \
	    } \
	 } 

    
    





