/************************************************************************/
/*	Routing Protocol Simulator	Release 1.0	1994/3/17	*/
/*                                              1.21    1997/2/10       */
/*									*/
/*		module 	: protocol procedure	       			*/
/*		file	: rps_ospf.h		       			*/
/*									*/
/*   Copyright (c) 1994-1997 by Systems Development Laboratory Hitachi,	*/
/*   Ltd. All rights reserved.						*/
/*----------------------------------------------------------------------*/
/*	UPDATE HISTORY							*/
/*			1996.7.11 add OSPF_LSREFRESH		        */
/************************************************************************/
#ifdef VXWORKS

#include "types.h"

#else

#include <sys/types.h>

#endif

#define IPPROTO_OSPF 89

/* OSPF packet type */
#define OSPF_HELLO_PKT	1
#define OSPF_DB_PKT		2
#define OSPF_LS_REQ_PKT		3
#define OSPF_LS_UPDATE_PKT	4
#define OSPF_LS_ACK_PKT		5

#define OSPF_HELLOTIMER		10
#define OSPF_ROUTERDEAD		40
#define OSPF_TRANSDELAY		1
#define OSPF_POLL		120
#define OSPF_RETRANS		10
#define OSPF_PRIORITY		0
#define OSPF_LS_REFRESH         1800

#define OSPF_DEFAULT_COST	0

#define OSPF_AUTHTYPE_NONE	0
#define OSPF_AUTHTYPE_SIMPLE	1

#define	OSPF_ALLSPF_ADDR	0xe0000005
#define OSPF_ALLDR_ADDR		0xe0000006

#define LOCAL_LOOPBACK_ADDR	0x7f000001

#define IFS_DOWN		0
#define IFS_LOOPBACK		1
#define IFS_WAITING		2
#define IFS_POINT_TO_POINT	3
#define IFS_DR			4
#define IFS_BDR			5
#define IFS_OTHER		6

#define OSPFMNGID_MAXLENGTH	32

#define	SLAVE		1
#define MASTER		2
#define SLAVE_HOLD	4

#define NBR_DOWN	0
#define NBR_ATTEMPT	1
#define NBR_INIT	2
#define NBR_2WAY	3
#define NBR_EXSTART	4
#define NBR_EXCHANGE	5
#define NBR_LOADING	6
#define NBR_FULL	7

struct OSPF_NBR {
    struct OSPF_NBR *next;
    char mng_id[OSPFMNGID_MAXLENGTH];
    struct OSPF_IF *intf;
    byte bits;
    byte mode;
    u_int state;
    u_long nbr_id;
    struct if_addr *nbr_addr;
    u_short priority;
    u_long dr;
    u_long bdr;
    u_long seq;
    byte *rtrans_list;
    struct LS_REQ *req_list;
    struct LS_ACK *wait_ack;
    struct DB_SUM *sum_list;
    time_t recv_time;
};

#define EVT_HELLO_RECEIVED	0
#define EVT_START		1
#define EVT_2_WAY		2
#define EVT_ADJ_OK		3
#define EVT_NEGO_DONE		4
#define EVT_EXCH_DONE		5
#define EVT_SEQNUM_MISMATCH	6
#define EVT_BAD_LS_REQ		7
#define EVT_LOAD_DONE		8
#define EVT_1_WAY		9
#define EVT_RST_ADJ		10
#define EVT_KILL_NBR		11
#define EVT_INACT_TIMER		12
#define EVT_LLDOWN		13

#define BROADCAST		1
#define NONBROADCAST		2
#define POINT_TO_POINT		3
#define VIRTUAL_LINK		4

/*
#define	INTFS_DOWN		0
#define INTFS_LOOPBACK		1
#define	INTFS_WAITING		2
#define INTFS_POINT_TO_POINT	3
#define INTFS_DR		4
#define INTFS_BACKUP		5
#define INTFS_DR_OTHER		6
*/
struct OSPF_IF {
    struct OSPF_IF *next;
    char mng_id[OSPFMNGID_MAXLENGTH];
    struct OSPF_AREA *area;
    u_short type;
    u_short state;
    struct if_addr *ifaddr;
    u_long area_id;
    byte *htimer;
    byte *rtimer;
    time_t hello_timer;
    time_t dead_timer;
    time_t trans_timer;
    time_t poll_timer;
    time_t retrans_timer;
    u_short priority;
    u_short cost;
    struct OSPF_NBR *nbr;
    u_long dr;
    u_long bdr;
/*    struct OSPF_NBR *dr;
    struct OSPF_NBR *bdr;*/
    u_short send_flag;
    u_long authkey[2];
};

#define EVT_INTF_UP		0
#define EVT_WAIT_TIMER		1
#define EVT_BACKUP_SEEN		2
#define EVT_NBR_CHANGE		3
#define EVT_LOOP_IND		4
#define EVT_UNLOOP_IND		5
#define EVT_INTF_DOWN		6

struct OSPF_AREA {
    struct OSPF_AREA *next;
    char mng_id[OSPFMNGID_MAXLENGTH];
    u_long id;
    int type;
    struct OSPF_IF *intf;
    byte *lsdb;
    byte *adv_lsa;
    int authtype;
    int default_cost;
};

#define BACKBONE_AREA		0

#define AREA_TYPE_TRANSIT 	1
#define AREA_TYPE_STUB		2
#define AREA_TYPE_VIRTUAL	3

struct PROTO_OSPF {
    struct PROTO_OSPF *next;
    char mng_id[OSPFMNGID_MAXLENGTH];
    u_long router_id;
    struct OSPF_AREA *myarea;
    struct OSPF_AREA *backbone;
    int vlink;
    int ase_list;
    int ase_data;
    int refresh_time;      /* 1996.7.11 add */
    short hello_display;
    short db_display;
    short req_display;
    short up_display;
    short ack_display;
};

    
#define STUB_COST(info)\
  (((struct PROTO_OSPF *)info)->myarea->default_cost)

#define IS_VIRTUAL(info) \
  (((struct PROTO_OSPF *)info)->myarea->intf->type == VIRTUAL_LINK ? 1 : 0)

#define AREA_TYPE(info) \
  (((struct PROTO_OSPF *)info)->myarea->type)






