/* $Id: trace.c,v 1.1 1999/08/23 16:18:41 naamato Exp $ */
/*
 * Copyright(c) 1998 by Hitachi.Ltd All rights reserved.
 *
 */


#include <stdio.h>
#include <varargs.h>
#include <sys/time.h>
#include <sys/param.h>
#include <time.h>
#include <fcntl.h>

#define LOG_FILE "trace.log"
#define LOG_DIR "/var/tmp/"
#define LOG_EXT ".log"

char log_buff[256];
char log_file[256];
FILE *log_fp;

#if !(defined(BSD) && (BSD >= 199103))
extern int errno;
extern int sys_nerr;
extern char *sys_errlist[];
#endif

int trace_mode=0;
int trace_fd=0;
char trace_tty[sizeof("ttyxx")];

void log_status();
char *time_to_char();

int log_init(file)
char *file;
{
    time_t start;
    struct timeval t;

    if(file) {
	strcpy(log_file,file);
    }
    else {
	strcpy(log_file,LOG_FILE);
    }

    if((log_fp = fopen(file,"w+")) == NULL) {
	return 0;
    }
    
    gettimeofday(&t,NULL);
    start = t.tv_sec;

/*    log_status("\n  Log Start at : %s \n",time_to_char(&start));*/

    return 1;
}

void log_close()
{
    time_t end;
    struct timeval t;

    gettimeofday(&t,NULL);
    end = t.tv_sec;
/*    log_status("\n  Log End at : %s \n",time_to_char(&end));*/
    log_status("\n%s Done...\n",ctime(&end));

    fclose(log_fp);
}

void trace(va_alist)
va_dcl
{
    char *fmt;
    FILE *fp;

    va_list args;

    va_start(args);

    fp = va_arg(args,FILE *);
    fmt = va_arg(args,char *);

    bzero(log_buff,sizeof(log_buff));
    vsprintf(log_buff,fmt,args);

    va_end(args);

/*    printf("fmt = %s\n",fmt);
    printf("args = %s\n",args);*/
    if(fp == NULL) fp = stderr;
    
/*    strcat(log_buff,"\0");*/

    fputs(log_buff,fp);
    fflush(fp);
}

void open_tty(tty)
char *tty;
{
    char dev[sizeof("/dev/ttyxx")];

    strcpy(dev,"/dev/");
    strcat(dev,tty);

    trace_fd = open(dev,O_WRONLY);
    if(trace_fd < 0) {
	perror(" can't open tty ");
	trace_fd = 0;
	return;
    }
}

void close_tty()
{
    if(trace_fd > 0)
	close(trace_fd);
}

void trace2(va_alist)
va_dcl
{
    char *fmt;
    FILE *fp;
    struct timeval t;
    va_list args;

    va_start(args);

    fp = va_arg(args,FILE *);
    fmt = va_arg(args,char *);

    bzero(log_buff,sizeof(log_buff));
    vsprintf(log_buff,fmt,args);

    va_end(args);
    if(fp == NULL) {
	if(trace_fd > 0) {
	    write(trace_fd,log_buff,sizeof(log_buff));
	    return;
	}
	else {
	    fp = stderr;
	}
    }
/*
    gettimeofday(&t,NULL);
    fprintf(fp,"%s ",time_to_char(&t.tv_sec));
*/
    fputs(log_buff,fp);
    fflush(fp);
}

/*
 *   trace with timestamp 
 */
void ttrace(va_alist)
va_dcl
{
    char *fmt,time_buf[16];
    FILE *fp;
    struct timeval t;
    va_list args;

    va_start(args);

    fp = va_arg(args,FILE *);
    fmt = va_arg(args,char *);

    bzero(log_buff,sizeof(log_buff));
    vsprintf(log_buff,fmt,args);

    va_end(args);

    gettimeofday(&t,NULL);
    bzero(time_buf,16);
    strcpy(time_buf, time_to_char(&t.tv_sec));

    if(fp == NULL) {
	if(trace_fd > 0) {
	    write(trace_fd,time_buf,16);
	    write(trace_fd,log_buff,sizeof(log_buff));
	    return;
	}
	else {
	    fp = stderr;
	}
    }

    fprintf(fp," %s ",time_buf);
    fputs(log_buff,fp);
    fflush(fp);
}

void log_status(va_alist)
va_dcl
{
    char *fmt;
    FILE *fp;

    va_list args;

    va_start(args);

/*    fp = va_arg(args,FILE *);*/
    fmt = va_arg(args,char *);

    bzero(log_buff,sizeof(log_buff));
    vsprintf(log_buff,fmt,args);

    va_end(args);

/*    printf("fmt = %s\n",fmt);
    printf("args = %s\n",args);*/
    if(log_fp == NULL) log_fp = stderr;
    
/*    strcat(log_buff,"\0");*/

    fputs(log_buff,log_fp);
    fflush(log_fp);
}

void log(severity, syserr, format, va_alist)
int severity;
int syserr;
char *format;
va_dcl
{
    FILE *fp;
    va_list args;
    char buf[20];
    struct timeval t;

    va_start(args);

    bzero(log_buff,sizeof(log_buff));
    gettimeofday(&t,NULL);

    if(log_fp == NULL) return;
    /* log_fp = stderr; */

    fprintf(log_fp,"%s ",time_to_char(&t.tv_sec));
    vsprintf(log_buff,format,args);
    va_end(args);

    fputs(log_buff,log_fp);
    fflush(log_fp);

    if(syserr == 0) {
	/*  */
    }
    else if(syserr < sys_nerr) {
	fprintf(stderr,": %s\n",sys_errlist[syserr]);
    }
    else {
	fprintf(stderr,": errno %d\n",syserr);
    }
    
}

char *time_to_char(clock)
int *clock;
{
    static char time_buf[16];
    char buf[32];

    bzero(time_buf,sizeof(time_buf));

    strcpy(buf,ctime((time_t *)clock));
    strncpy(time_buf,&buf[4],15);
    time_buf[15]='\0';

    return time_buf;
}
    
