/* $Id: interface.h,v 1.1 1999/08/23 16:18:33 naamato Exp $ */

struct if_info {
  int fd;
  char name[sizeof "enxx"];
  unsigned int htype;
  unsigned char hlen;
  char haddr[6];               /* MAC address */
  struct if_addr *ipaddr;
  int buf_size;
  int flag;                    /* IFF_XXX flag */
  int add_flag;                /* ADD membership 1999.5.24 */
  char *buf;
  struct if_info *next;        /* Null terminate */
};

struct if_addr {
    struct if_addr *next;
    struct in_addr *addr;
    struct in_addr *net;
    struct in_addr *net_mask;
    struct in_addr *subnet;
    struct in_addr *subnet_mask;
    struct in_addr *broadcast;   /* 1999.6.16 for BROADCAST */
    int state;
    struct if_info *info;
};

#define IF_ADDR(if_addr)	((if_addr)->addr->s_addr)
#define IF_NET(if_addr)		((if_addr)->net->s_addr)
#define IF_NETMASK(if_addr)	((if_addr)->net_mask->s_addr)
#define IF_SUBNET(if_addr)	((if_addr)->subnet->s_addr)
#define IF_SUBMASK(if_addr)	((if_addr)->subnet_mask->s_addr)
#define IF_NAME(if_addr)        ((if_addr)->info->name)
#define IF_BRDCAST(if_addr)     ((if_addr)->broadcast->s_addr)


