#ifndef _ISO_SUPPORT_H
#define _ISO_SUPPORT_H

#ifndef AF_ISO
#define AF_ISO AF_NBS
#define PF_ISO PF_NBS
#endif


#ifndef IPPROTO_IDRP
#define IPPROTO_IDRP 45
#endif /* IPPROTO_IDRP */

#ifndef  ISOPROTO_IDRP
#define  ISOPROTO_IDRP  36
#endif /* ISOPROTO_IDRP */


struct iso_addr {
	u_char  isoa_len;               /* length (in bytes) */
	char    isoa_genaddr[20];       /* general opaque address */
};

/* used in the file idrp_sock.c */ 
struct sockaddr_iso {
        u_char                  siso_len;       /* length */
        u_char                  siso_family;    /* family */
        u_char                  siso_plen;      /* presentation selector length */
        u_char                  siso_slen;      /* session selector length */
        u_char                  siso_tlen;      /* transport selector length */
        struct  iso_addr        siso_addr;      /* network address */
        u_char                  siso_pad[6];    /* space for gosip v2 sels */
 
        /* makes struct 32 bytes long */
};


/*
 *      Fixed part of clnp header
 */
struct clnp_fixed {
        u_char  cnf_proto_id;   /* network layer protocol identifier */
        u_char  cnf_hdr_len;    /* length indicator (octets) */
        u_char  cnf_vers;       /* version/protocol identifier extension */
        u_char  cnf_ttl;        /* lifetime (500 milliseconds) */
        u_char  cnf_type;       /* type code */
                                /* Includes err_ok, more_segs, and seg_ok */
        u_char  cnf_seglen_msb; /* pdu segment length (octets) high byte */
        u_char  cnf_seglen_lsb; /* pdu segment length (octets) low byte */
        u_char  cnf_cksum_msb;  /* checksum high byte */
        u_char  cnf_cksum_lsb;  /* checksum low byte */
};





#endif /* _ISO_SUPPORT_H */
