/*
 *  isis_pdus.h,v 1.11 1993/01/07 22:39:50 jch Exp
 */

/* Gated Release 3.5 */
/* Copyright (c) 1990,1991,1992,1993,1994 by Cornell University. All rights */
/* reserved. Refer to Particulars and other Copyright notices at the end of this */
/* file. */


#ifndef _pdus_h
#define _pdus_h

#include "isis_base.h"

#define	Unsupported	0x80
#define Reserved	0x40
#define	ValueMask	0x3f

#define	ISL1		0x01
#define	ISL2		0x03
#define	Hippty		0x04
#define AttachedDefault	0x08
#define AttachedDelay	0x10
#define AttachedExpense	0x20
#define AttachedError	0x40
#define	PartitionRepair	0x80

/* Variable length field ID codes */
#define	AreaAddressCode			1			/* IIH and LSP */
#define LSPISNeighborCode		2			/* LSP */
#define LSPESNeighborCode		3			/* LSP */
#define	LSPPDL2ISCode			4			/* LSP */
#define LSPPrefixNeighborCode		5			/* LSP */
#define	ISNeighborCode			6			/* IIH */
#define PaddingCode			8			/* lan IIH */
#define LSPEntries			9			/* CSNP and PSNP */
#define AuthenticationCode		10			/* ISO IIH, LSP, CSNP, PSNP */
#define	IPIntReachCode			128			/* DUAL */
#define ProtoSupportedCode		129			/* DUAL */
#define	IPExtReachCode			130			/* DUAL */
#define IPInterDomInfo                  131                     /* DUAL */
#define IPIfAddrCode			132			/* DUAL */
#define IPAuthInfoCode			133			/* DUAL - different auth code allows disjoint domain for IP */
#define	leafNode			180			/* LSP - indicates whether IS Neighbor option present in this LSP */
#define	IPSumReachCode			254			/* DUAL - fake value for internal use only */

/* return true if there is space left in the option field */
#define optSpaceLeft(curLen, itemSize)\
	((255 - curLen) > itemSize)

typedef struct {
	Metric	defalt;		/* default is reserved in C */
	Metric	delay;
	Metric	expense;
	Metric	error;
} MetricList;

typedef struct _LSPID {
	SystemID6	sourceID;
	Unsigned8	pseudonodeID;
	Unsigned8	LSPNumber;
} LSPID;


typedef struct _CommonHeader {
	Unsigned8	_packetID;
	Unsigned8	_headerLength;
	Unsigned8	_versionProtoID;
	Unsigned8	_reserved1;
#define	GetPacketType(x) ((x) & ~0xe0)
#define ESHType			2
#define ISHType			4
#define RDType			6
#define	L1LANHelloType		15
#define	L2LANHelloType		16
#define PPHelloType		17
#define L1LSType		18
#define L2LSType		20
#define L1CSNType		24
#define L2CSNType		25
#define L1PSNType		26
#define L2PSNType		27
	Unsigned8	_packetType;
	Unsigned8	_version;
	Unsigned8	_eco;
	Unsigned8	_userEco;
} CommonHeader;

#define packetID common._packetID
#define headerLength common._headerLength
#define versionProtoID common._versionProtoID
#define packetType common._packetType
#define myversion common._version
#define eco common._eco
#define userEco common._userEco

typedef struct _ESISHeader {
	Unsigned8	protoID;		/* network layer protocol identifier */
	Unsigned8	headerLen;		/* length indicator (octets) */
	Unsigned8	vers;			/* version/protocol identifier extension */
	Unsigned8	res1;			/* reserved */
	Unsigned8	type;			/* type code */
	Unsigned16	ht;			/* holding time (seconds) */
	Unsigned16	cksum;			/* checksum */
} ESISHeader;

typedef struct _LSPHeader {
	CommonHeader	common;
	Unsigned16	pduLength;
	Unsigned16	remainingLifetime;
	LSPID		lspId;				/* ID of LSP originator */
	Unsigned32	sequenceNumber;
	Unsigned16	checksum;
	Unsigned8	pathhippity;
} LSPHeader;

typedef struct _LANHelloHeader {
	CommonHeader	common;
#define	GetCircuitType(x) ((x) & ~0xfc)
#define L1Circuit	0x01
#define L2Circuit	0x02
	Unsigned8	circuitType;
	SystemID6	sourceID;
	Unsigned16	holdingTimer;
	Unsigned16	pduLength;
#define	GetPriority(x) ((x) & ~0x80)
	Unsigned8	priority;
	SystemID7	LANID;
} LANHelloHeader;

typedef struct _PPHelloHeader {
	CommonHeader	common;
	Unsigned8	circuitType;
	SystemID6	sourceID;
	Unsigned16	holdingTimer;
	Unsigned16	pduLength;
	Unsigned8	localCircuitID;
} PPHelloHeader;

typedef struct _CSNHeader {
	CommonHeader	common;
	Unsigned16	pduLength;
	SystemID7	sourceID;
	LSPID		start;
	LSPID		end;
} CSNHeader;

typedef struct _PSNHeader {
	CommonHeader	common;
	Unsigned16	pduLength;
	SystemID7	sourceID;
} PSNHeader;

typedef struct _AreaAddr {
	u_char		len;
	u_char		addr[MaximumAreaAddressLen];
} AreaAddr;

typedef struct _AreaAddrList {
	char		areaAddr[MaximumAreaAddresses];	/* index into AA store */
	u_char		count;				/* current number */
} AreaAddrList;

#define MAXIPADDRS		10

typedef struct _IPAddrList {
	struct in_addr	addrs[MAXIPADDRS];
	u_short		cnt;
} IPAddrList;

typedef struct _IPReachAddr {
	MetricList	metrics;
	IPAddress	address;
	IPSubnetMask	mask;
} IPReachAddr;

typedef struct _IPReachInfo {
	IPReachAddr		*reachAddrs;	/* array */
	u_short			count;		/* size of array */
	struct _IPReachInfo	*next;
} IPReachInfo;

/* flags field */
#define	SUPPORT_IP	0x01
#define SUPPORT_CLNP	0x02

typedef struct _LANHelloPacket {
	u_int		flags;			/* DUAL: protocols supported */
	IPAddrList	ifAddr;			/* DUAL: addr of if xmitted upon */
	AuthInfo	authInfo;		/* DUAL: TODO */
	LANHelloHeader	*hdr;
	u_short		holdingTimer;		/* host order */
	u_short		pduLength;		/* host order */
	AreaAddrList	areaAddrs;		/* area addresses */
	SystemID6	*ISneighbors;		/* array of SystemIDs */
	u_short		count;			/* number in array */
} LANHelloPacket;

typedef struct _PPHelloPacket {
	caddr_t		data;			/* actual packet */
	u_short		len;			/* length of packet */
	u_int		flags;			/* DUAL: protocols supported */
	IPAddrList	ifAddr;			/* DUAL: addr of if xmitted upon */
	AuthInfo	authInfo;		/* DUAL: TODO */
	u_short		holdingTimer;		/* host order */
	u_short		pduLength;		/* host order */
	PPHelloHeader	*hdr;
	AreaAddrList	areaAddrs;		/* area addresses */
} PPHelloPacket;

typedef struct _AddrPrefix {
	MetricList	*metrics;
	AreaAddrList	addrPrefixes;
} AddrPrefix;

typedef struct _PrefixList {
	AddrPrefix		prefix;
	struct _PrefixList	*next;
} PrefixList;

typedef struct _SNEntry {
	u_short		lifetime;		/* remaining */
	LSPID		id;
	u_long		number;
	u_short		checksum;
} SNEntry;


#endif	/* _pdus_h */


/*
 * ------------------------------------------------------------------------
 * 
 * 	GateD, Release 3.5
 * 
 * 	Copyright (c) 1990,1991,1992,1993,1994 by Cornell University
 * 	    All rights reserved.
 * 
 * 	THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 * 	EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * 	LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * 	AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * 	Royalty-free licenses to redistribute GateD Release
 * 	3 in whole or in part may be obtained by writing to:
 * 
 * 	    GateDaemon Project
 * 	    Information Technologies/Network Resources
 * 	    200 CCC
 * 	    Cornell University
 * 	    Ithaca, NY  14853-2601  USA
 * 
 * 	GateD is based on Kirton's EGP, UC Berkeley's routing
 * 	daemon	 (routed), and DCN's HELLO routing Protocol.
 * 	Development of GateD has been supported in part by the
 * 	National Science Foundation.
 * 
 * 	Please forward bug fixes, enhancements and questions to the
 * 	gated mailing list: gated-people@gated.cornell.edu.
 * 
 * ------------------------------------------------------------------------
 * 
 *       Portions of this software may fall under the following
 *       copyrights:
 * 
 * 	Copyright (c) 1988 Regents of the University of California.
 * 	All rights reserved.
 * 
 * 	Redistribution and use in source and binary forms are
 * 	permitted provided that the above copyright notice and
 * 	this paragraph are duplicated in all such forms and that
 * 	any documentation, advertising materials, and other
 * 	materials related to such distribution and use
 * 	acknowledge that the software was developed by the
 * 	University of California, Berkeley.  The name of the
 * 	University may not be used to endorse or promote
 * 	products derived from this software without specific
 * 	prior written permission.  THIS SOFTWARE IS PROVIDED
 * 	``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 * 	INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * 	MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * ------------------------------------------------------------------------
 * 
 * 	Copyright 1991 D.L.S. Associates
 * 
 * 	Permission to use, copy, modify, distribute, and sell this software
 * 	and its documentation for any purpose is hereby granted without
 * 	fee, provided that the above copyright notice appear in all copies
 * 	and that both that copyright notice and this permission notice
 * 	appear in supporting documentation, and that the name of D.L.S. not
 * 	be used in advertising or publicity pertaining to distribution of
 * 	the software without specific, written prior permission.  D.L.S.
 * 	makes no representations about the suitability of this software for
 * 	any purpose.  It is provided "as is" without express or implied
 * 	warranty.
 * 
 * 	D.L.S. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * 	INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * 	NO EVENT SHALL D.L.S.  BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * 	CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * 	OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * 	NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * 	CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 * 
 * 	Authors:  Robert Hagens and Dan Schuh
 * 
 * 
 */
