/* idrp_import_test_rdpath.h -- sjr */
#include "include.h"
#include "iso.h"
#include "idrp.h"
#include "inet.h"

#define MAKE_INET_ADDR(a, b, c, d) (((((((a) * 256) + (b)) * 256UL) + (c)) * 256UL) + (d))

/*
PROTOTYPE(NULL_gw_rtd_dump,
	       void,
	       (FILE *fp,
		rt_entry *p_rt));		
*/
void
NULL_gw_rtd_dump __PF2(fp, FILE *, p_rt, rt_entry *)
{
	/* do nothing*/
	return;
}

/*
PROTOTYPE(NULL_gw_rtd_free,
               void,
               (void_t garbage));
*/
void
NULL_gw_rtd_free __PF1(garbage, void_t)
{
	/* do nothing*/
	return;
}

#define NULL_RTQ_ENTRY { (struct _rtq_entry *) NULL, (struct _rtq_entry *) NULL, 0 }

#ifdef	PROTO_SNMP
#define MAKE_GW(name, p_sockaddr_un_addr) struct _gw_entry (name) = { \
    (struct _gw_entry *) NULL, \
    0, \
    (p_sockaddr_un_addr), \
    0, \
    (task *) NULL, \
    0, \
    0, \
    0, \
    NULL_RTQ_ENTRY, \
    (void_t) NULL, \
    (struct _adv_entry *) NULL, \
    (struct _adv_entry *) NULL, \
    &NULL_gw_rtd_dump, \
    &NULL_gw_rtd_free, \
    0, \
    0
}
#else
#define MAKE_GW(name, p_sockaddr_un_addr) struct _gw_entry (name) = { \
    (struct _gw_entry *) NULL, \
    0, \
    (p_sockaddr_un_addr), \
    0, \
    (task *) NULL, \
    0, \
    0, \
    0, \
    NULL_RTQ_ENTRY, \
    (void_t) NULL, \
    (struct _adv_entry *) NULL, \
    (struct _adv_entry *) NULL, \
    &NULL_gw_rtd_dump, \
    &NULL_gw_rtd_free \
}
#endif

MAKE_GW(NULL_GW_ENTRY, bad_if);
MAKE_GW(good_gw_entry, good_if);
MAKE_GW(bad_gw_entry, bad_if);

sockaddr_un good_local_ip_intf; 
sockaddr_un bad_local_ip_intf; 

#define GOOD_LOCAL_NET { 20, AF_ISO, { 0x47, 0x00, 0x05, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x2a, 0x01, 0xb4, 0x00 }}

struct iso_net_addr good_local_iso_net = GOOD_LOCAL_NET ;

#define BAD_LOCAL_NET { 20, AF_ISO, { 0x47, 0x00, 0x05, 0x80, 0xff, 0xff, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x23, 0x2a, 0x01, 0xb4, 0xff }}

struct iso_net_addr bad_local_iso_net = BAD_LOCAL_NET ;

#define good_local_net  (sockaddr_un *) &good_local_iso_net
#define bad_local_net   (sockaddr_un *) &bad_local_iso_net

#define SIXTY_ONE_NULL_CHARS  { \
'\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', \
'\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', \
'\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', \
'\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', \
'\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', \
'\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', \
'\0'}

#define NULL_REFRESH_INFO  { 0, \
(idrpRefresh *) NULL, (idrpRefresh *) NULL, 0, 0, 0 } 

#define NULL_AUTH_CODE  { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }

#define NULL_ERROR_INFO { 0, 0, (u_char  *) NULL, 0, (u_char  *) NULL, 0 } 

#define NULL_IDRP_RID_HASH { 0, 0, (struct  _idrp_rid_hash *) NULL, (struct _idrpRoute *) NULL }

#define NULL_HASH_TABLE { \
NULL_IDRP_RID_HASH, NULL_IDRP_RID_HASH, NULL_IDRP_RID_HASH, NULL_IDRP_RID_HASH,\
NULL_IDRP_RID_HASH, NULL_IDRP_RID_HASH, NULL_IDRP_RID_HASH, NULL_IDRP_RID_HASH,\
NULL_IDRP_RID_HASH, NULL_IDRP_RID_HASH, NULL_IDRP_RID_HASH, NULL_IDRP_RID_HASH,\
NULL_IDRP_RID_HASH, NULL_IDRP_RID_HASH, NULL_IDRP_RID_HASH, NULL_IDRP_RID_HASH,\
NULL_IDRP_RID_HASH, NULL_IDRP_RID_HASH, NULL_IDRP_RID_HASH, NULL_IDRP_RID_HASH }

#ifdef ECHOKLUDGE
#define MAKE_GOOD_NET_PEER(name, gw) struct _idrpPeer (name) = { \
    (struct _idrpPeer *) NULL, \
     	0, 0, 0, \
    GOOD_LOCAL_NET, \
    BAD_NET, BAD_NET, \
    (sockaddr_un *) NULL, \
    BAD_NET, \
    	0, \
    GOOD_SNPA_LIST, \
    	0, \
    	0, \
    NULL_AUTH_CODE, \
        0, 0, 0, 0, 0, \
    	0, 0, 0, 0, 0, \
    	0, 0, \
    	{ 0, 0, 0, 0}, \
   (idrpRoute_options	*) NULL, (idrpRoute_options	*) NULL, \
     	0, 0, 0, 0, 0, \
     	0, 0, 0, 0, \
    NULL_REFRESH_INFO, \
    	0, 0, 0, 0, 0, \
    	0, 0, 0, \
    (flag_t) 0, \
     	0, \
    (task *) NULL, \
    (trace *) NULL, \
    SIXTY_ONE_NULL_CHARS, \
    gw_entry iso_gw, \
    (gw), \
    	0, 0, \
    NULL_HASH_TABLE, \
    NULL_ERROR_INFO, \
     	0, 0, \
    (time_t) 0, (time_t) 0, (time_t) 0, (time_t) 0, (time_t) 0, \
    (time_t) 0, (time_t) 0, (time_t) 0, (time_t) 0, (time_t) 0, \
    (time_t) 0, \
    (idrpBuffer *) NULL, \
    (idrpBuffer **) NULL, \
    (idrpBuffer *) NULL, \
    (idrpBuffer **) NULL, \
    (task_timer *) NULL, (task_timer *) NULL, (task_timer *) NULL, \
    (task_timer *) NULL, (task_timer *) NULL, (task_timer *) NULL, \
    (task_timer *) NULL, (task_timer *) NULL, (task_timer *) NULL, \
    (task_timer *) NULL, \
    (time_t) 0, \
    	0, \
    (idrpAdvRt	*) NULL, (idrpAdvRt	*) NULL, \
    (time_t) 0, \
    	0, \
    (idrpAdvRt	*) NULL, (idrpAdvRt	*) NULL \
}
#define MAKE_BAD_NET_PEER(name, gw) struct _idrpPeer (name) = { \
    (struct _idrpPeer *) NULL, \
     	0, 0, 0, \
    BAD_LOCAL_NET, \
    BAD_NET, BAD_NET, \
    (sockaddr_un *) NULL, \
    BAD_NET, \
    	0, \
   GOOD_SNPA_LIST, \
    	0, 0, \
   NULL_AUTH_CODE, \
        0, 0, 0, 0, 0, \
    	0, 0, 0, 0, 0, \
    	0, 0, \
    	{ 0, 0, 0, 0}, \
   (idrpRoute_options	*) NULL, (idrpRoute_options	*) NULL, \
     	0, 0, 0, 0, 0, \
     	0, 0, 0, 0, \
    NULL_REFRESH_INFO, \
    	0, 0, 0, 0, 0, \
    	0, 0, 0, \
    (flag_t) 0, \
     	0, \
    (task *) NULL, \
    (trace *) NULL, \
    SIXTY_ONE_NULL_CHARS, \
    gw_entry iso_gw, \
    (gw), \
     	0, 0, \
    NULL_HASH_TABLE, \
    NULL_ERROR_INFO, \
     	0, 0, \
    (time_t) 0, (time_t) 0, (time_t) 0, (time_t) 0, (time_t) 0, \
    (time_t) 0, (time_t) 0, (time_t) 0, (time_t) 0, (time_t) 0, \
    (time_t) 0, \
    (idrpBuffer *) NULL, \
    (idrpBuffer **) NULL, \
    (idrpBuffer *) NULL, \
    (idrpBuffer **) NULL, \
    (task_timer *) NULL, (task_timer *) NULL, (task_timer *) NULL, \
    (task_timer *) NULL, (task_timer *) NULL, (task_timer *) NULL, \
    (task_timer *) NULL, (task_timer *) NULL, (task_timer *) NULL, \
    (task_timer *) NULL, \
    (time_t) 0, \
    	0, \
    (idrpAdvRt	*) NULL, (idrpAdvRt	*) NULL, \
    (time_t) 0, \
    	0, \
    (idrpAdvRt	*) NULL, (idrpAdvRt	*) NULL \
}
#else
#define MAKE_GOOD_NET_PEER(name, gw) struct _idrpPeer (name) = { \
   (struct _idrpPeer *) NULL, \
   	0, 0, 0, \
   GOOD_LOCAL_NET, \
   BAD_NET, BAD_NET, \
   (sockaddr_un *) NULL, \
   BAD_NET, \
   	0, \
   GOOD_SNPA_LIST, \
   	0, 0, \
   NULL_AUTH_CODE, \
        0, 0, 0, 0, 0, \
	0, 0, 0, 0, 0, \
    	0, 0, \
    	{ 0, 0, 0, 0}, \
   (idrpRoute_options	*) NULL, (idrpRoute_options	*) NULL, \
    	0, 0, 0, 0, 0, \
     	0, 0, 0, 0, \
    NULL_REFRESH_INFO, \
    	0, 0, 0, 0, 0, \
    	0, 0, 0, \
    	(flag_t) 0, \
     	0, \
    (task *) NULL, \
    (trace *) NULL, \
    SIXTY_ONE_NULL_CHARS, \
    NULL_GW_ENTRY, \
    (gw), \
     	0, 0, \
    NULL_HASH_TABLE, \
    NULL_ERROR_INFO, \
     	0, 0, \
    	(time_t) 0, (time_t) 0, (time_t) 0, (time_t) 0, (time_t) 0, \
    	(time_t) 0, (time_t) 0, (time_t) 0, (time_t) 0, (time_t) 0, \
    	(time_t) 0, \
    (idrpBuffer *) NULL, \
    (idrpBuffer **) NULL, \
    (idrpBuffer *) NULL, \
    (idrpBuffer **) NULL, \
    (task_timer *) NULL, (task_timer *) NULL, (task_timer *) NULL, \
    (task_timer *) NULL, (task_timer *) NULL, (task_timer *) NULL, \
    (task_timer *) NULL, (task_timer *) NULL, (task_timer *) NULL, \
    	(time_t) 0, \
    	0, \
    (idrpAdvRt	*) NULL, (idrpAdvRt	*) NULL, \
    	(time_t) 0, \
    	0, \
    (idrpAdvRt	*) NULL, (idrpAdvRt	*) NULL \
}
#define MAKE_BAD_NET_PEER(name, gw) struct _idrpPeer (name) = { \
    (struct _idrpPeer *) NULL, \
     	0, 0, 0, \
    BAD_LOCAL_NET, \
    BAD_NET, BAD_NET, \
    (sockaddr_un *) NULL, \
    BAD_NET, \
    	0, \
    GOOD_SNPA_LIST, \
    	0, 0, \
    NULL_AUTH_CODE, \
        0, 0, 0, 0, 0, \
    	0, 0, 0, 0, 0, \
    	0, 0, \
    	{ 0, 0, 0, 0}, \
    (idrpRoute_options	*) NULL, (idrpRoute_options	*) NULL, \
     	0, 0, 0, 0, 0, \
     	0, 0, 0, 0, \
    NULL_REFRESH_INFO, \
    	0, 0, 0, 0, 0, \
    	0, 0, 0, \
    (flag_t) 0, \
     	0, \
    (task *) NULL, \
    (trace *) NULL, \
    SIXTY_ONE_NULL_CHARS, \
    NULL_GW_ENTRY, \
    (gw), \
     	0, 0, \
    NULL_HASH_TABLE, \
    NULL_ERROR_INFO, \
     	0, 0, \
    (time_t) 0, (time_t) 0, (time_t) 0, (time_t) 0, (time_t) 0, \
    (time_t) 0, (time_t) 0, (time_t) 0, (time_t) 0, (time_t) 0, \
    (time_t) 0, \
    (idrpBuffer *) NULL, \
    (idrpBuffer **) NULL, \
    (idrpBuffer *) NULL, \
    (idrpBuffer **) NULL, \
    (task_timer *) NULL, (task_timer *) NULL, (task_timer *) NULL, \
    (task_timer *) NULL, (task_timer *) NULL, (task_timer *) NULL, \
    (task_timer *) NULL, (task_timer *) NULL, (task_timer *) NULL, \
    (time_t) 0, \
    	0, \
    (idrpAdvRt	*) NULL, (idrpAdvRt	*) NULL, \
    (time_t) 0, \
    	0, \
    (idrpAdvRt	*) NULL, (idrpAdvRt	*) NULL \
}
#endif

MAKE_GOOD_NET_PEER(peer_good_both, good_gw_entry);
MAKE_GOOD_NET_PEER(peer_good_net, bad_gw_entry);
MAKE_BAD_NET_PEER(peer_good_intf, good_gw_entry);
MAKE_BAD_NET_PEER(peer_bad_both, bad_gw_entry);

#define MAKE_ISO_NET_ADDR(name, len, addr) struct iso_net_addr (name) = { \
	(len), AF_ISO, { (addr) } }

struct iso_net_addr rdp1 = { 3, AF_ISO, {0x49, 0x00, 0x49}};
struct iso_net_addr rdp2 = { 3, AF_ISO, {0x49, 0x00, 0x50}};
struct iso_net_addr rdp3 = { 3, AF_ISO, {0x60, 0x00, 0x00}};
struct iso_net_addr rdp4 = { 3, AF_ISO, {0x21, 0x00, 0x40}};
struct iso_net_addr rdp5 = { 3, AF_ISO, {0x21, 0x00, 0x41}};
struct iso_net_addr rdp6 = { 3, AF_ISO, {0x21, 0x00, 0x42}};
struct iso_net_addr rdpb1 = { 4, AF_ISO, {0x21, 0x00, 0x42, 0x00}};
struct iso_net_addr rdpb2 = { 3, AF_ISO, {0x49, 0x00, 0x42}};
struct iso_net_addr rdpb3 = { 3, AF_ISO, {0x50, 0x00, 0xff}};
struct iso_net_addr Null_Rdi = { 0, AF_ISO, {0x00}};
rdi rdi1, rdi2, rdi3, rdi4, rdi5, rdi6, rdib1, rdib2, rdib3;
rdi NULL_RDI;

#define MAKE_RDI_FROM_ISO_NET(an_rdi, p_net) do { \
        iso_net_copy((p_net), &((an_rdi).rdi)); \
	} while (0)

#define MAKE_RDI_ARRAY(name, elem1, elem2, elem3, elem4, elem5) struct _rdi *(name)[IDRP_RD_PATH_ARRAY_SIZE] = { \
	&(elem1), &(elem2), &(elem3), &(elem4), &(elem5), \
	&(NULL_RDI), &(NULL_RDI), &(NULL_RDI), &(NULL_RDI), &(NULL_RDI) }

MAKE_RDI_ARRAY(good_rdarr_1_1, rdi1, rdi2, rdi5, rdi3, NULL_RDI);
MAKE_RDI_ARRAY(good_rdarr_1_2, rdib2, rdi1, rdi2, rdib1, rdi3);
MAKE_RDI_ARRAY(good_rdarr_2, rdi4, rdi5, rdi6, rdi2, rdi4);
MAKE_RDI_ARRAY(bad_rdarr_1_1, rdib1, rdi2, rdi2, rdi3, rdi5);
MAKE_RDI_ARRAY(bad_rdarr_1_2, rdi1, rdib2, rdi2, rdi3, rdi5);
MAKE_RDI_ARRAY(bad_rdarr_1_3, rdi1, rdi2, rdi2, rdib3, rdi5);
MAKE_RDI_ARRAY(bad_rdarr_2, rdib1, rdib2, rdib3, rdi2, rdi1);

#define RDI_ARRAY_STRUCT(array, p_next) { \
      { (array)[0], (array)[1], (array)[2], (array)[3], (array)[4], \
	(array)[5], (array)[6], (array)[7], (array)[8], (array)[9] }, \
        (struct  _rdi_array      *)(p_next), \
        (struct  _rdi_array      *) NULL } 

#define MAKE_RDI_ARRAY_STRUCT(name, array, p_next) rdi_array (name) = RDI_ARRAY_STRUCT((array), (p_next))

/*
MAKE_RDI_ARRAY_STRUCT(good_struct_2_1, good_rdarr_2, NULL);
MAKE_RDI_ARRAY_STRUCT(good_struct_2_2, bad_rdarr_2, &good_rdarr_2);
MAKE_RDI_ARRAY_STRUCT(bad_struct_2, bad_rdarr_2, NULL);

MAKE_RDI_ARRAY_STRUCT(good_struct_1_1, good_rdarr_1_1, &good_struct_2_1);
MAKE_RDI_ARRAY_STRUCT(good_struct_1_2, good_rdarr_1_2, &good_struct_2_2);
MAKE_RDI_ARRAY_STRUCT(good_struct_1_3, bad_rdarr_1_1, &good_struct_1_1);
MAKE_RDI_ARRAY_STRUCT(good_struct_1_4, bad_rdarr_1_2, &good_struct_1_2);
MAKE_RDI_ARRAY_STRUCT(good_struct_1_5, bad_rdarr_1_3, &good_struct_1_1);
MAKE_RDI_ARRAY_STRUCT(bad_struct_1_1, bad_rdarr_1_1, &bad_struct_2);
MAKE_RDI_ARRAY_STRUCT(bad_struct_1_2, bad_rdarr_1_2, &bad_struct_2);
MAKE_RDI_ARRAY_STRUCT(bad_struct_1_3, bad_rdarr_1_3, &bad_struct_2);
*/

/*
#define IDRP_RDPATH_SEQ         BIT(0x01)
#define IDRP_RDPATH_SET         BIT(0x02)
*/

#define MAKE_RDPATH_PIECE(name, status, p_next, count, array, array_p_next) struct _rdpath (name) = { \
        (status),    \
        (struct  _rdpath *)(p_next),     \
        (struct  _rdpath *) NULL,\
        (count),           \
        RDI_ARRAY_STRUCT(array, array_p_next),  \
        (rdi_array *) NULL } 

MAKE_RDPATH_PIECE(good_rdp_p_2_1, IDRP_RDPATH_SET, NULL, 5, good_rdarr_2, NULL);
MAKE_RDPATH_PIECE(good_rdp_p_2_2, IDRP_RDPATH_SET, NULL, 15, bad_rdarr_2, &good_rdp_p_2_1);
MAKE_RDPATH_PIECE(bad_rdp_p_2, IDRP_RDPATH_SET, NULL, 5, bad_rdarr_2, NULL);

MAKE_RDPATH_PIECE(good_rdp_whole_1, IDRP_RDPATH_SEQ, &good_rdp_p_2_1, 4, good_rdarr_1_1, NULL);
MAKE_RDPATH_PIECE(good_rdp_whole_2, IDRP_RDPATH_SEQ, &good_rdp_p_2_2, 5, good_rdarr_1_2, NULL);
MAKE_RDPATH_PIECE(good_rdp_p_1_1, IDRP_RDPATH_SEQ, &good_rdp_p_2_1, 14, bad_rdarr_1_1, &good_rdarr_1_1);
MAKE_RDPATH_PIECE(good_rdp_p_1_2, IDRP_RDPATH_SEQ, &good_rdp_p_2_2, 15, bad_rdarr_1_2, &good_rdarr_1_2);
MAKE_RDPATH_PIECE(good_rdp_p_1_3, IDRP_RDPATH_SET, &good_rdp_whole_1, 5, bad_rdarr_2, NULL);

MAKE_RDPATH_PIECE(bad_rdp_whole_1, IDRP_RDPATH_SEQ, &bad_rdp_p_2, 5, bad_rdarr_1_1, NULL);
MAKE_RDPATH_PIECE(bad_rdp_whole_2, IDRP_RDPATH_SEQ, &bad_rdp_p_2, 5, bad_rdarr_1_2, NULL);
MAKE_RDPATH_PIECE(bad_rdp_whole_3, IDRP_RDPATH_SEQ, &bad_rdp_p_2, 5, bad_rdarr_1_3, NULL);


#define MAKE_RDPATH_LIST(name, p_start, count) struct  _rdpath_list (name) = { \
        (struct  _rdpath_list    *) NULL, \
        (struct  _rdpath_list    *) NULL, \
        (rdpath *) (p_start),             \
        (rdpath  *) NULL,                 \
        (count),                          \
        0 }

MAKE_RDPATH_LIST(good_rdpath_1, &good_rdp_whole_1, 9);
MAKE_RDPATH_LIST(good_rdpath_2, &good_rdp_whole_2, 20);
MAKE_RDPATH_LIST(bad_rdpath_1, &bad_rdp_whole_1, 10);
MAKE_RDPATH_LIST(bad_rdpath_2, &bad_rdp_whole_2, 10);
MAKE_RDPATH_LIST(bad_rdpath_3, &bad_rdp_whole_3, 10);

/*
  Good RD path:

import proto idrp rdpath / .* 0x490049 0x490050 . 0x600000 [ 0x210040 0x210041 
	0x210042 ] .* / local-intf 35.42.1.75

*/
#define NULL_ATTR_ENTRY { 0, 0, 0, (u_char *) NULL }

#define NULL_ATTRIB { \
NULL_ATTR_ENTRY, NULL_ATTR_ENTRY, NULL_ATTR_ENTRY, NULL_ATTR_ENTRY, \
NULL_ATTR_ENTRY, NULL_ATTR_ENTRY, NULL_ATTR_ENTRY, NULL_ATTR_ENTRY, \
NULL_ATTR_ENTRY, NULL_ATTR_ENTRY, NULL_ATTR_ENTRY, NULL_ATTR_ENTRY, \
NULL_ATTR_ENTRY, NULL_ATTR_ENTRY, NULL_ATTR_ENTRY, NULL_ATTR_ENTRY, \
NULL_ATTR_ENTRY }

#define NULL_USR_ATTRIB { NULL_ATTR_ENTRY, NULL_ATTR_ENTRY, NULL_ATTR_ENTRY }

#ifdef	IDRP_ASPATH
#define MAKE_IDRP_ATTR_REC(name, rdpath) struct _idrp_attribute_record (name) = { \
	(struct	_idrp_attribute_record 	*) NULL, \
	(struct	_idrp_attribute_record 	*) NULL, \
	(struct	_idrp_attribute_record	*) NULL, \
	(idrpRoute_entry *) NULL, \
	0, \
	(struct	_idrpPeer *) NULL, \
	(idrpRoute_entry *) NULL, \
	0, 0, 0, \
	(struct	_idrpRoute_options *) NULL, \
	(idrp_canon_rdpath *) NULL, \
	&(rdpath), \
	(sockaddr_un *) NULL, \
	0, \
	(snpa_list *) NULL, \
	(struct _as_path *) NULL,
	(idrp_attribute_entry_list *) NULL, \
	NULL_ATTRIB, \
	NULL_USR_ATTRIB, \
	(u_char	*) NULL, \
	0, 0, 0 \
}
#else
#define MAKE_IDRP_ATTR_REC(name, rdpath) struct _idrp_attribute_record (name) = { \
	(struct	_idrp_attribute_record 	*) NULL, \
	(struct	_idrp_attribute_record 	*) NULL, \
	(struct	_idrp_attribute_record	*) NULL, \
	(idrpRoute_entry *) NULL, \
	0, \
	(struct	_idrpPeer *) NULL, \
	(idrpRoute_entry *) NULL, \
	0, 0, 0, \
	(struct	_idrpRoute_options *) NULL, \
	(idrp_canon_rdpath *) NULL, \
	&(rdpath), \
	(sockaddr_un *) NULL, \
	0, \
	(snpa_list *) NULL, \
	(idrp_attribute_entry_list *) NULL, \
	NULL_ATTRIB, \
	NULL_USR_ATTRIB, \
	(u_char	*) NULL, \
	0, 0, 0 \
}
#endif

MAKE_IDRP_ATTR_REC(good_idrp_attr_rec_1, good_rdpath_1);
MAKE_IDRP_ATTR_REC(good_idrp_attr_rec_2, good_rdpath_2);
MAKE_IDRP_ATTR_REC(bad_idrp_attr_rec_1, bad_rdpath_1);
MAKE_IDRP_ATTR_REC(bad_idrp_attr_rec_2, bad_rdpath_2);
MAKE_IDRP_ATTR_REC(bad_idrp_attr_rec_3, bad_rdpath_3);

#define NULL_ROUTE_OUT    { (struct _idrpRoute *) NULL, (struct _idrpRoute *) NULL, (int) 0}               
#define NULL_route_out    { NULL_ROUTE_OUT, NULL_ROUTE_OUT, \
NULL_ROUTE_OUT, NULL_ROUTE_OUT, NULL_ROUTE_OUT, NULL_ROUTE_OUT, \
NULL_ROUTE_OUT, NULL_ROUTE_OUT, NULL_ROUTE_OUT, NULL_ROUTE_OUT } 

#define ISO_NULLPREFIX { 0, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00} }

#define MAKE_IDRP_ROUTE(name, peer, atts) struct _idrpRoute (name) = { \
    (rt_entry	*) NULL, \
    &(peer), \
    (sockaddr_un	*) NULL, \
    (gw_entry 	*) NULL, \
    &(atts), \
	0, 0, 0, 0, \
    (struct _idrpRoute *) NULL, (struct _idrpRoute *) NULL, \
    (struct _idrpRoute *) NULL, (struct _idrpRoute *) NULL, \
    (struct _idrpRoute *) NULL, (struct _idrpRoute *) NULL, \
    (struct _idrpRoute *) NULL, (struct _idrpRoute *) NULL, \
    (struct _idrpRoute *) NULL, (struct _idrpRoute *) NULL, \
    (struct _idrpRoute *) NULL, (struct _idrpRoute *) NULL, \
    (struct _idrpRoute *) NULL, \
    (struct _idrp_best_ext *) NULL, \
    NULL_route_out, \
    ISO_NULLPREFIX, \
	0, 0, 0 }

MAKE_IDRP_ROUTE(good_idrp_route_1, peer_good_both, good_idrp_attr_rec_1);
MAKE_IDRP_ROUTE(good_idrp_route_2, peer_good_both, good_idrp_attr_rec_2);
MAKE_IDRP_ROUTE(bad_idrp_route_1, peer_good_both, bad_idrp_attr_rec_1);
MAKE_IDRP_ROUTE(bad_idrp_route_2, peer_good_both, bad_idrp_attr_rec_2);
MAKE_IDRP_ROUTE(bad_idrp_route_3, peer_good_both, bad_idrp_attr_rec_3);
MAKE_IDRP_ROUTE(bad_idrp_route_4, peer_bad_both, good_idrp_attr_rec_1);
MAKE_IDRP_ROUTE(bad_idrp_route_5, peer_bad_both, good_idrp_attr_rec_2);
