
/* 
 *    IDRP QOS definitions
 */

#define	IDRP_MAX_QOS_RIBS	IDRP_MAX_RIBS	
#define IDRP_QOS_POLL_TIME	3	

/* definitions to be changed by MITRE
 * Security parameters for PDU
 *
 * Test implementation octets
 *	<Security option> <00> <00> <00> <security_value>
 * 
 * parser commands
 *
 *  security [admin | gen-com | operation | sysmgt] [value] 
 */

#define IDRP_QOS_SEC_TYPE_ADMIN		1	/* administration */		
#define IDRP_QOS_SEC_TYPE_GENCOM	2	/* general communications */	
#define IDRP_QOS_SEC_TYPE_OPERATIONS	3	/* operations */ 		
#define	IDRP_QOS_SEC_TYPE_SYSMGT	4	/* system management */

#define	FAA_SECURITY_VALUE_MAX		255	/* security value maximum */

/* QOS rib definition */ 

typedef	struct _idrp_qos_rib {
int			rib_id;		/* idrp qos id */
int			parse_id;	/* parse id */	
int			nlri_supp[IDRP_NLRI_FAMILIES_SUPPORTED]; /* families supported on rib */
idrp_distinguish_att	att;		/* distinguished attributes */
int			n_att;		/* number of distinguished atts in rib */
int			kern_len;	/* length of byte string for kernel */
byte			*p_qos_str;	/* string for kernel */
int			update_pdu_len;	/* length of byte string for update pdu */
byte			*p_update_pdu;	/* string for insertion into pdu  */
int			open_pdu_len;	/* length of byte string for update pdu */
byte			*p_open_pdu;	/* string for insertion into pdu  */

byte			*p_delay;	/* pointer for delay in pdu */ 
byte			*p_expense;	/* pointer for delay in pdu */ 
byte			*p_error;	/* pointer for delay in pdu */ 
byte			*p_security;	/* pointer for delay in pdu */ 
byte			*p_priority;	/* pointer for delay in pdu */ 
int			status;		/* status flags  */ 
} idrp_qos_rib;

#define	IDRP_STATUS_RIB_INACTIVE	0x0	/* rib is not started */ 
#define	IDRP_STATUS_RIB_ACTIVE		0x1	/* rib is active */
#define	IDRP_STATUS_RIB_DELETE		0x2	/* rib is scheduled to be deleted */ 
#define	IDRP_STATUS_RIB_TO_KERNEL	0x4	/* rib is dropping routes to kernel */  
#define	IDRP_STATUS_RIB_FROM_KERNEL	0x8	/* rib getting routes from kernel */  

#define	IDRP_STATUS_RIB_RECONFIGURE	0x20	/* rib has been reconfigured */ 
#define	IDRP_STATUS_RIB_NEW		0x40	 /* garbage collect this rib */ 


#define	IDRP_QOS_PDU_PTR_DELAY		0	/* pointer into the string for pdus */
#define IDRP_QOS_PDU_PTR_ERROR		1	/* pointer into the string for pdus */
#define IDRP_QOS_PDU_PTR_EXPENSE	2	/* pointer into the string for pdus */
#define IDRP_QOS_PDU_PTR_SECURITY	3	/* pointer into the string for pdus */
#define IDRP_QOS_PDU_PTR_PRIORITY	4	/* pointer into the string for pdus */


