/*
 * ------------------------------------------------------------------------
 * 
 * GateD, Release 3.5.5 
 * 
 * Copyright (c) 1996, 1997 The Regents of the University of Michigan
 * All Rights Reserved
 * 
 * License to use, copy, modify, and distribute this software and its
 * documentation can be obtained from Merit at the University of Michigan.
 * 
 * Merit GateDaemon Project
 * 4251 Plymouth Road, Suite C
 * Ann Arbor, MI 48105
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the
 * University of Michigan and Merit shall not be liable for
 * any special, indirect, incidental or consequential damages with respect
 * to any claim by Licensee or any third party arising from use of the
 * software. GateDaemon was originated and developed through release 3.0
 * by Cornell University and its collaborators.
 * 
 * Please forward bug fixes, enhancements and questions to the
 * gated mailing list: gated-people@gated.merit.edu.
 * 
 * ---------------------
 * 
 * Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.
 * All rights reserved.
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * Royalty-free licenses to redistribute GateD Release
 * 3 in whole or in part may be obtained by writing to:
 * 
 * GateDaemon Project
 * Information Technologies/Network Resources
 * 200 CCC
 * Cornell University
 * Ithaca, NY  14853-2601  USA
 * 
 * GateD is based on Kirton's EGP, UC Berkeley's routing
 * daemon	 (routed), and DCN's HELLO routing Protocol.
 * Development of GateD has been supported in part by the
 * National Science Foundation.
 * 
 * Please forward bug fixes, enhancements and questions to the
 * gated mailing list: gated-people@gated.cornell.edu.
 * 
 * ------------------------------------------------------------------------
 * 
 * Portions of this software may fall under the following
 * copyrights:
 * 
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms are
 * permitted provided that the above copyright notice and
 * this paragraph are duplicated in all such forms and that
 * any documentation, advertising materials, and other
 * materials related to such distribution and use
 * acknowledge that the software was developed by the
 * University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote
 * products derived from this software without specific
 * prior written permission.  THIS SOFTWARE IS PROVIDED
 * ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * This copyright has ben automaticly added by the util/addcopyright.pl program.
 * __END_OF_COPYRIGHT__
 */

 /*  krt_rtread_kinfo.c,v 1.8.2.3 1994/07/28 02:00:25 jch Exp^M
 */^M
/* Gated Release 3.5 */^M
/* Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.  All */^M
/* rights reserved.  Refer to Particulars and other Copyright notices at */^M
/* the end of this file.  */^M
/*  */^M
^M
^M
#define       INCLUDE_ROUTE^M
#define       INCLUDE_IOCTL^M
#define       INCLUDE_IF^M
#include <stropts.h>^M
#include "include.h"^M
#ifdef        PROTO_INET^M
#include "inet.h"^M
#endif        /* PROTO_INET */^M
#ifdef        PROTO_ISO^M
#include "iso.h"^M
#endif        /* PROTO_ISO */^M
#include "krt.h"^M
#include "krt_var.h"^M
^M
^M
/* Use the ioctl() system call to read the routing table(s) */^M
/*ARGSUSED*/^M
int^M
krt_rtread __PF1(tp, task *)^M
{^M
    size_t size, alloc_size;^M
    caddr_t kbuf;^M
    rt_parms rtparms;^M
    struct strioctl ioc;^M
    struct rtrecord *krt;^M
    if_addr *ifap;^M
^M
    trace_only_tp(tp,^M
                TRC_NL_BEFORE,^M
                ("krt_rtread: Initial routes read from kernel (via socket ioctl)
));^M
^M
    bzero((caddr_t) &rtparms, sizeof (rtparms));^M
    rtparms.rtp_n_gw = 1;^M
^M
    ioc.ic_cmd = SIOCGRTSIZ;^M
    ioc.ic_timout = 0;^M
    ioc.ic_len = 0;^M
    ioc.ic_dp = 0;^M
    if ((alloc_size = ioctl(tp->task_socket, I_STR, &ioc)) < 0) {^M
      trace_log_tp(tp,^M
                   0,^M
                   LOG_ERR,^M
                   ("krt_rtread: ioctl for routing table estimate: %m"));^M
      return errno;^M
    }^M
    if (alloc_size < 0) {^M
      errno = EINVAL;^M
      trace_log_tp(tp,^M
                   0,^M
                   LOG_ERR,^M
                   ("krt_rtread: routing table estimate: %m"));^M
      return errno;^M
    }^M
    if (alloc_size == 0) {^M
      goto end;^M
    }^M
    trace_tp(tp,^M
           TR_STATE,^M
           0,^M
           ("krt_rtread: routing table estimates %d entries needed",^M
            alloc_size));^M
    size = ROUNDUP(alloc_size * sizeof(struct rtrecord), task_pagesize);^M
    kbuf = (caddr_t) task_block_malloc(size);^M
    ioc.ic_cmd = SIOCGRTTAB;^M
    ioc.ic_timout = 0;^M
    ioc.ic_len = size;^M
    ioc.ic_dp = (char *)kbuf;^M
    if ((alloc_size = ioctl(tp->task_socket, I_STR, &ioc)) < 0) {^M
      trace_log_tp(tp,^M
                   0,^M
                   LOG_ERR,^M
                   ("krt_rtread: routing table retrieve: %d, %m", size));^M
      task_block_reclaim(size, kbuf);^M
      return errno;^M
    }^M
^M
    krt = (struct rtrecord *) kbuf;^M
    for ( ; alloc_size ; alloc_size--, krt++ ) {^M
^M
      {^M
          struct sockaddr_in *addr;^M
^M
          addr = (struct sockaddr_in *) &krt->rt_dst;^M
          addr->sin_family = AF_INET;^M
          addr->sin_port = 0;^M
          bzero((caddr_t) addr->sin_zero, sizeof (addr->sin_zero));^M
^M
          addr = (struct sockaddr_in *) &krt->rt_gateway;^M
          addr->sin_family = AF_INET;^M
          addr->sin_port = 0;^M
          bzero((caddr_t) addr->sin_zero, sizeof (addr->sin_zero));^M
      }^M
^M
     rtparms.rtp_dest = sock2gated(&krt->rt_dst, unix_socksize(&krt->rt_dst));^

      rtparms.rtp_router = sock2gated(&krt->rt_gateway, unix_socksize(&krt->rt_g
ateway));^M
      rtparms.rtp_state = krt_flags_to_state((flag_t) krt->rt_flags);^M
      if (BIT_TEST(krt->rt_flags, RTF_HOST)) {^M
          rtparms.rtp_dest_mask = sockhostmask(rtparms.rtp_dest);^M
      } else if ((ifap = if_withdstaddr(rtparms.rtp_dest))^M
              || (ifap = inet_ifwithnet(rtparms.rtp_dest))) {^M
          rtparms.rtp_dest_mask = ifap->ifa_netmask;^M
      } else {^M
          rtparms.rtp_dest_mask = inet_mask_natural(rtparms.rtp_dest);^M
      }^M
      krt_rtread_add(tp,^M
                     &rtparms,^M
                     (flag_t) krt->rt_flags,^M
                     FALSE,^M
                     "REMNANT");^M
^M
    }^M
    task_block_reclaim(size, kbuf);^M
end:^M

    return 0;^M
}^M
