/*
 * Copyright (c) 1983 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef lint
static char sccsid[] = "@(#)log.c	5.3 (Berkeley) 9/2/88";
#endif /* not lint */

#include "tip.h"
#include <grp.h>

#ifdef ACULOG
static	FILE *flog = NULL;

#ifdef PRISTINE
int pristine = 1;	/* so it is easier to change for binary-only sites */
#else
int pristine = 0;
#endif

/*
 * Log file maintenance routines
 */

logent(group, num, acu, message)
	char *group, *num, *acu, *message;
{
	static int uid = -1, gid = -1;
	static char *user, *ugroup;
	int i;
  	long t;
	char *timestamp;
	struct passwd *pwd;
	struct group *grp;

	if (flog == NULL)
		return;
	if (flock(fileno(flog), LOCK_EX) < 0) {
		perror("tip: flock");
		return;
	}
	if (uid != (i = geteuid())) {
		uid = i;
		setpwent();
		if ((pwd = getpwuid(getuid())) == NOPWD)
			user = "???";
		else
			user = pwd->pw_name;
	}
	if (gid != (i = getgid())) {
		gid = i;
		setgrent();
		if ((grp = getgrgid(getgid())) == (struct group *)0)
			ugroup = "???";
		else
			ugroup = grp->gr_name;
	}
	t = time(0);
	timestamp = ctime(&t);
	timestamp[24] = '\0';
	fprintf(flog, "%s:%s (%s) <%s, %s, %s> %s\n",
		user, ugroup, timestamp, group,
		pristine ? "" : num,
		acu, message);
	(void) fflush(flog);
	(void) flock(fileno(flog), LOCK_UN);
}

loginit()
{
	extern int errno;

  	flog = fopen(value(LOG), "a");
	if (flog == NULL) {
		int e = errno;
		fprintf(stderr, "tip: can't open log file: ");
		errno = e;
		perror(value(LOG));
		putc('\r', stderr);
		putc('\n', stderr);
	}
}
#endif
