
#include <sys/types.h>
#include <sys/file.h>
#include <sys/dir.h>
#include <errno.h>
#include <stdio.h>

#define LOCKDIRNAME	"/usr/spool/locks/LCK..%s"	/**/
#define DEFTTY "cuab"

/* 
 */

extern int errno;

main(ac,av)
int ac;
char **av;
{
	int fd, pid, a;
	char tbuf[sizeof(LOCKDIRNAME) + MAXNAMLEN];

	(void)sprintf(tbuf,LOCKDIRNAME,"slip");

	if ((a  = access(tbuf,F_OK)) == 0) {
		(void)
		fprintf
		(stderr,"killslip: No action because LCK..slip exists\n");
		exit(1);
	}

	if (ac == 2)
		(void)sprintf(tbuf, LOCKDIRNAME, *++av);
	else
		(void)sprintf(tbuf, LOCKDIRNAME, DEFTTY);

	/*
	 * file is already locked
	 * check to see if the process holding the lock still exists
	 */
	fd = open(tbuf, O_RDWR, 0);

	if (fd < 0) {
		perror("killslip: open(LCK..cuab)");
		exit(1);
	}
	if (read(fd, &pid, sizeof(pid)) != sizeof(pid)) {
		(void)close(fd);
		perror("killslip: read()");
		exit(1);
	}

	if (kill(pid, 1) == 0 ) {
		fprintf(stderr,"killslip: sent HANGUP signal to %d\n",pid);
		(void)close(fd);	/* process is still running */
		exit(0);
	}

	perror("killslip: kill()");

	exit(1);
}

