/* ppp_str.h - streams version include file defines ioctl calls for MRU, COMPPROT and ASYNCMAP */
/*
 * Copyright (C) 1990 Brad K. Clements, All Rights Reserved, See copyright statement
   in Readme.streams
*/
/*
 * Copyright (c) 1992 Purdue University
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by Purdue University.  The name of the University may not be used
 * to endorse or promote products derived * from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Note: this copyright applies to portions of this software developed
 * at Purdue beyond the software covered by the original copyright.
 */

#include	<sys/ioccom.h>

#define	SIOCSIFCOMPAC	_IOW(p, 130, char)
#define	SIOCSIFCOMPPROT	_IOW(p, 131, char)
#define	SIOCSIFMRU	_IOW(p, 132, int)
#define	SIOCGIFMRU	_IOR(p, 133, int)
#define	SIOCGIFASYNCMAP	_IOR(p, 134, long)
#define	SIOCSIFASYNCMAP	_IOW(p, 135, long)
#define	SIOCGETU	_IOR(p, 136, int)  /* get unit number */
#define	SIOCSIFVJCOMP	_IOW(p, 137, char) /* enable/disable VJ Compression */

/*
 * Newly defined stuff for Dialup options.
 */
#define	SIOCSIFUNIT	_IOW(p, 138, int)	/* Set unit number */
#define	SIOCGIFUNIT	_IOR(p, 139, int)	/* Get unit number */
#define	SIOCCALLSTAT	_IOW(p, 140, char)	/* Call status */

#define	SIOCSDPTIMEO	_IOW(p, 141, dp_timeo)	/* Set Timeouts */
#define	SIOCGDPTIMEO	_IOR(p, 142, dp_timeo)	/* Get Timeouts */

/*
 * Call status values
 */
#define	DP_FAILURE	0
#define	DP_SUCCESS	1
#define	DP_IN_PROGRESS	2
/*
 * These ioctls can be applied to an interface even if there is
 * no associated stream.
 */
#define SIOCICALLSTAT	_IOW(i, 64, struct ifreq)  /* Report Call Status */
#define	SIOCSDPIATIMEO	_IOW(i, 65, struct ifreq)  /* Set Activity Timeouts */
#define	SIOCGDPIATIMEO	_IOWR(i, 66, struct ifreq) /* Get Activity Timeouts */
#define	SIOCSDPICTIMEO	_IOW(i, 67, struct ifreq)  /* Set Call Timeouts */
#define	SIOCGDPICTIMEO	_IOWR(i, 68, struct ifreq) /* Get Call Timeouts */

/*
 * Bits for pii_flags.
 */
#define	PII_FLAGS_INUSE		0x0001	/* in use by  a stream	*/
#define	PII_FLAGS_COMPAC	0x0002
#define	PII_FLAGS_COMPPROT	0x0004
#define	PII_FLAGS_ATTACHED	0x0008	/* already if_attached	*/
#define	PII_FLAGS_INITTED	0x0040	/* already if_initted	*/
#define	PII_FLAGS_VJC_ON	0x0010	/* VJ TCP header compression enabled */
#define	PII_FLAGS_DIALUP	0x0020	/* Operate in dialup on demand mode */
#define	PII_FLAGS_ACTIVE	0x0040	/* Keep track of active connections */

/*
 * Values for pii_dustate.
 */
#define	PII_DPS_ACTIVE		0	/* Active */
#define	PII_DPS_ACTIVEC		1	/* Not used */
#define	PII_DPS_ACTIVEU		2	/* Not used */
#define	PII_DPS_WAITING		3	/* Waiting for call completion */
#define	PII_DPS_FAILCALL	4	/* After failed call */
#define	PII_DPS_DISCON		5	/* Not connected */
#define	PII_DPS_DOWN		6	/* Shouldn't try to connect */

#define	PII_DP_NSTATES		7
/*
 * Constants related to the timeout mechanism
 * Array indices are defined for the states which have timeouts.
 * Also, default settings for timeouts.
 */
#define	DP_ATIMEO	PII_DPS_ACTIVE	/* Activity with open TCP connections */
#define	DP_CTIMEO	PII_DPS_ACTIVEC	/* Activity after last TCP close */
#define	DP_UTIMEO	PII_DPS_ACTIVEU	/* Activity for non-TCP traffic only */
#define	DP_WTIMEO	PII_DPS_WAITING	/* Call Wait Timeout */
#define	DP_FTIMEO	PII_DPS_FAILCALL/* Failed Call Timeout */
#define	DP_ATIMEOUTS	0		/* First Activity Timeout */
#define	DP_NATIMEOUTS	3		/* Number of activity timeouts */
#define	DP_CTIMEOUTS	DP_NATIMEOUTS	/* First Call Timeout */
#define	DP_NCTIMEOUTS	2		/* Number of call timeouts */
#define	DP_NTIMEOUTS	(DP_NATIMEOUTS + DP_NCTIMEOUTS)
					/* Number of timeouts */

#define DP_HZ		5		/* 5 second granularity */
#define	DP_NO_TIMEOUT	(-1)
#define	DP_DEF_TIMEOUT	(-2)
#define DP_DEF_ATIMEO	(2 * 60)	/* 2 minutes */
#define DP_DEF_WTIMEO	(1 * 60)	/* 1 minute */
#define DP_DEF_FTIMEO	(1 * 60)	/* 1 minute */
#define DP_DEF_CTIMEO	DP_NO_TIMEOUT	/* */
#define DP_DEF_UTIMEO	DP_NO_TIMEOUT	/* */

#define	DP_ACTIVE
#ifdef	DP_ACTIVE
/*
 * Data structures to monitor the active conversations on a PPP interface.
 */
#define	MAX_ACTIVE	16
#define	DC_ACTIVE	1

struct  dp_conv {
    struct dp_conv *dc_next;
    int	dc_flags;
    struct in_addr dc_ip_src,  dc_ip_dst;
    u_short dc_th_sport, dc_th_dport;
};

struct dp_ctab {
    struct dp_conv *dt_last;
    struct dp_conv dt_conv[MAX_ACTIVE];
};

struct  dp_active {
    int da_nactive;			/* Number of active conversations */
    int da_lookups,			/* Total table searches */
	da_misses;			/* Cache misses */
    struct dp_ctab da_ttab,		/* Transmit conversation table */
		   da_rtab;		/* Receive conversation table */
};
#endif

struct	dp_if_info {
	int	pii_flags;
	struct	ifnet	pii_ifnet;
	queue_t		*pii_writeq;		/* used by ppp_output 	*/
#ifdef	VJC
	struct 	slcompress	pii_sc_comp;	/* vjc control buffer */
#endif
#ifdef	PPP_STATS
	struct slipstat		pii_stats;
#endif
#ifdef	DP_ACTIVE
	struct dp_active	pii_active;
#endif
	int pii_dustate;

	long pii_timo[PII_DP_NSTATES];		/* Timeouts */
	long pii_timer,				/* Normal timeout */
	     pii_ftimer;			/* Fast timeout */
	queue_t *pii_q;				/* Associated Queue */
};

typedef struct dp_timeo {
    int timeo[DP_NTIMEOUTS];
} dp_timeo;

#define	DR_MINHDRLEN	(sizeof(struct ip))
#define	DR_MAXHDRLEN	(sizeof(struct ip) + 2 * sizeof(u_short))

typedef struct dp_reqinfo {
    char dri_ifname[8];
    int dri_ifunit;
    int dri_flag;
    struct sockaddr_in dri_sin;
    int dri_hdrlen;
} dp_reqinfo;

typedef union dp_reqhdr {
    char drh_data[DR_MAXHDRLEN];
    struct ip drh_ip;
} dp_reqhdr;

typedef struct dp_req {
    struct dp_reqinfo dr_info;
    union dp_reqhdr dr_hdr;
} dp_req;

#define	dr_ifname	dr_info.dri_ifname
#define	dr_ifunit	dr_info.dri_ifunit
#define	dr_flag		dr_info.dri_flag
#define	dr_sin		dr_info.dri_sin
#define	dr_hdrlen	dr_info.dri_hdrlen

#define	dr_data		dr_hdr.drh_data
#define	dr_ip		dr_hdr.drh_ip
#define	dr_tcpip	dr_hdr.drh_tcpip
#define	dr_udpip	dr_hdr.drh_udpip

#define DP_REQ_CHECKIT	1

#define DP_HIWAT	(5 * sizeof(struct dp_req))
#define DP_LOWAT	(4 * sizeof(struct dp_req))
