#ifdef	STS
#include <sys/types.h>
#include <stropts.h>
#include <sys/conf.h>

/*
 * This is the best I could do on short notice with no documentation..
 * Truss and adb are very useful tools..
 */

#define	STSIOCSINFO	0x80445414
#define	STSIOCGINFO	0x40445415

struct stsinfo {
    char fill1[3];
    char baudext;
    char fill2[64];
};

#define	EXTBITS		0x10
#define	EXTSHIFT	4
#define EXTMIN		0
#define EXTMAX		1

stsbaudext(fd, ext)
int fd;
int ext;
{
    struct stsinfo sinfo;
    struct strioctl si;

    if (ext < 0 || ext > 1)
	return;

    si.ic_cmd = STSIOCGINFO;
    si.ic_timout = 0;
    si.ic_len = sizeof(sinfo);
    si.ic_dp = (char *)&sinfo;
    if (ioctl(fd, I_STR, &si) < 0)
	return -1;

    sinfo.baudext = (sinfo.baudext & ~EXTBITS)
		  | ((ext << EXTSHIFT) & EXTBITS);

    si.ic_cmd = STSIOCSINFO;
    si.ic_timout = 0;
    si.ic_len = sizeof(sinfo);
    si.ic_dp = (char *)&sinfo;

    if (ioctl(fd, I_STR, &si) < 0)
	return -1;
    return 0;
}
#endif
