/***************************************
  $Revision: 1.18 $

  Error reporting (er) er_facilities.h - list of facilities (modules)

  Status: NOT REVUED, TESTED, 
 
  Design and implementation by: Marek Bukowy

  ******************/ /******************
  Copyright (c) 1999,2000,2001,2002               RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/

/* 
NOTE:  modify the m4 file only, do not change the resulting .h !!!
*/

#ifndef ER_FACILITIES_H
#define ER_FACILITIES_H

/* this #include is just for cxref to not get lost completely :-) */
#include <erroutines.h>

/* this is the file for adding new facilities.
   This requires three steps:
   1. Prepare and  a file with your error messages (see other files).	
      Please follow the filename convention er_??_errors.c 
   2. Declare your facility number in the enum (before the FAC_LAST)

   only when that's ready (for not to prevent other people from working)

   3. Add your facility to the facility table, using the GLUP macro
	(it takes a two-letter code and a description of the facility).
	This will add a pointer to the module-specific error table
	to the global table.
*/

/* m4 macro */








typedef enum {
	FAC_NONE=0,
	 FAC_RX   , 
	 FAC_ER    ,                           
	 FAC_IP   ,                   
	 FAC_UP    ,                     
	 FAC_UT    ,         
	 FAC_WH    ,                  
	 FAC_RP   ,            
	 FAC_QI   ,                         
	 FAC_QC   ,                       
	 FAC_PW   ,                          
	 FAC_SK   ,                    
	 FAC_TH   ,                         
	 FAC_SQ   ,                           
	 FAC_PM   , 
	 FAC_MM   , 
	 FAC_SV   , 
	 FAC_AC   ,
	 FAC_UD   ,
	 FAC_PA   , 
	 FAC_PC   ,
	FAC_LAST
} er_fac_code_t;
 
/* paste the "include"s here. This will define error codes. */
#include "er_RX_errors.h"
#include "er_ER_errors.h"
#include "er_IP_errors.h"
#include "er_UP_errors.h"
#include "er_UT_errors.h"
#include "er_WH_errors.h"
#include "er_RP_errors.h"
#include "er_QI_errors.h"
#include "er_QC_errors.h"
#include "er_PW_errors.h"
#include "er_SK_errors.h"
#include "er_TH_errors.h"
#include "er_SQ_errors.h"
#include "er_PM_errors.h"
#include "er_MM_errors.h"
#include "er_SV_errors.h"
#include "er_AC_errors.h"
#include "er_UD_errors.h"
#include "er_PA_errors.h"
#include "er_PC_errors.h"


#ifndef ER_IMPL
/* just a declaration for modules using this */
#include "erroutines.h"
extern er_fac_t er_fac_err[];
#else 
  er_fac_t 	er_fac_err[] = {
/*    {FAC_NONE}, */
DEFFAC(RX,"radix tree indexing for IP/route objects"),
DEFFAC(ER,"error system"),
DEFFAC(IP,"IP conversion library"),
DEFFAC(UP,"upper update layer"),
DEFFAC(UT,"general utilities and wrappers"),
DEFFAC(WH,"embedded whois client"),
DEFFAC(RP,"radix tree payload functions"),
DEFFAC(QI,"query execution"),
DEFFAC(QC,"query preparation"),
DEFFAC(PW,"protocol whois"),
DEFFAC(SK,"socket communication"),
DEFFAC(TH,"thread handling"),
DEFFAC(SQ,"SQL interface"),
DEFFAC(PM,"protocol mirror"),
DEFFAC(MM,"MIME parser"),
DEFFAC(SV,"main server functions"),
DEFFAC(AC,"access control"),
DEFFAC(UD,"core update process"),
DEFFAC(PA,"GPG authentication"),
DEFFAC(PC,"Protocol config"),

    {FAC_LAST}
  };
#endif /* ER_IMPL */

#endif /* ER_FACILITIES_H */
