#       whoisd - whois Internet daemon
#
# Copyright (c) 1993, 1994, 1995, 1996, 1997  The TERENA Association
# Copyright (c) 1998                              RIPE NCC
#
# All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of the author not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
#
# THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
# AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#

# Sees if the object has a refer attribute.
# If no just return
# If yes, make a whois query and substitue the value obtained
# Include a Warning message

require "dpr.pl";

sub has_refer {

    local($name, $rhost, %object) = @_;
    my($msg, $query);
    local(*referral);
    $referral = 0;
    @referral = undef;
    %referral = %object;


#    &dpr("\%object = " . join("*", %object) . "\n");
    &dpr("global \$name = $name, \$rhost = $rhost\n");

    # If the query has the -R option, don't do referral
    return \$referral, \@referral, \%referral if ($opt_R);

    if (defined $object{"rf"}) {
	$referral = 1;
	%referral = undef;
	($type,$host,$port)= split /\s+/, $object{"rf"};
        # Default port is 43
	$port = 43 if (!$port);
	$REFERHOST = $host;
        $REFERPORT = $port;
	if ($host eq $rhost || $host eq $name) {
	    # referral loop
	    &ReplaceGlobalVars(*REFERRALLOOPERRORTXT);
	    @referral = split(/\n+/,$REFERRALLOOPERRORTXT);
	    return \$referral, \@referral, \%referral;
	}

	&dpr("Querying referred host $host:$port. Type = $type\n");
	$query = $object{'dn'};
	$query = "-F " . $query if ($type =~ /ripe/i);

	my($handler_ref) = $SIG{'ALRM'};
	$SIG{'ALRM'} = sub {die "REFERRAL TIMEOUT";};
	eval {
	    alarm($REFERRALTIMEOUT);
	    $msg = &initwhoisqry($host, $port, $query);
	    alarm(0);
	};

	$SIG{'ALRM'} = $handler_ref;
	if ($@ =~ /REFERRAL TIMEOUT/) {
	    &ReplaceGlobalVars(*REFERRALTIMEOUTTXT);
	    @referral = split(/\n+/,$REFERRALTIMEOUTTXT);
	    return \$referral, \@referral, \%referral;
	}

	if ($msg) {
	    $REFERMSG = $msg;
	    &ReplaceGlobalVars(*REFERRALERRORTXT);
	    @referral = split(/\n+/,$REFERRALERRORTXT);
	    return \$referral, \@referral, \%referral;
	}
	@referral = <WHOIS_S>;
	close(WHOIS_S);
	map(chomp, @referral);

	if ($type =~ m/ripe/i) {
	    foreach (@referral) {
                # Skip the header
		#print "read: $_\n";
		next if (/^$/ || /^%/);
		($attr,$value) = split /\s+/,$_,2;
                #print "attr: $attr, value: $value\n";
		$attr = substr $attr,1,2;
                #print "attr: $attr, value: $value\n";
		$referral{$attr} .= $value."\n";
	    }
	    @referral = ();
	}
	&ReplaceGlobalVars(*REFERRALTXT);
	my(@tmp)  = split(/\n+/, $REFERRALTXT);
	unshift(@referral, @tmp);
    }
    &dpr("\$referral = $referral; \@referral = " . join("*", @referral) .
	 "\%referral = " . join("*", %referral) . "\n");
    return \$referral, \@referral, \%referral;
}

# Drop the leftmost part of a domain name
sub cut_domain {
    local(*keys) = @_;

    ($drop, $keep) = split(/\./, $keys[0], 2);
#    &dpr("\@keys = @keys, \$drop = $drop, \$keep = $keep\n");
    
}

# Query a remote server
sub whois_qry {



}

#Print notice about referred object
sub print_notice {
    print $REFERRALTXT;
}

1;
