import java.util.*;
import org.w3c.dom.*;
import com.sun.xml.tree.*;

/**
 * RIPE attribute.
 *
 * @author ottrey@ripe.net
 * @version $Version$
 *
 */
public class AttributeDef implements Cloneable {
  
  final static int QI_SQL   = 1;
  final static int QI_RADIX = 2;

  private String name;
  private String altName;
  private String code;
  private String status;

  private String description;
  private String format;

  private boolean lookup;
  private boolean inverse;
  private boolean primary;
  private String foreign;
  private String keytype;

  private String insert;
  private String insertQ_type;
  private String update;
  private String updateQ_type;
  private String dummy;
  private String dummyQ_type;
  private String select;
  private String selectQ_type;

  private String choice;
  private String number;

  private Vector queries;

  // -----------------oOo-----------------
  //              Constructors
  // -----------------oOo-----------------
  /**
   * Creates a RIPE attribute.
   *               
   * @author ottrey@ripe.net
   * @version $Version$
   *               
   * @param obj The node from which a RIPE attribute is made.
   * 
   * NOTE: I don't know why Node.getNodeValue() isn't working.
   *       description = tw.getNextElement("description").getNodeValue();
   * @see getNodeValue
   */
  public AttributeDef(Node obj) {
    name      = obj.getAttributes().getNamedItem("name").getNodeValue();
    code      = obj.getAttributes().getNamedItem("code").getNodeValue();
    status    = obj.getAttributes().getNamedItem("status").getNodeValue();

    // Blindly ask for the optional items.
    try {
      altName   = obj.getAttributes().getNamedItem("altName").getNodeValue();
    }
    catch (NullPointerException e) {
      altName = new String();
      // Throw the exception away.  :-)
    }

    // Prepare to walk the tree.
    TreeWalker tw = new TreeWalker(obj);

    // Get the "description" node.
    description = getNodeValue(tw.getNextElement("description"));

    // Get the "format" node.
    format = getNodeValue(tw.getNextElement("format"));

    // Initialize
    foreign = new String();
    lookup = false;
    inverse = false;
    primary = false;

    insert       = new String();
    insertQ_type = new String("UD_NULL_");
    update       = new String();
    updateQ_type = new String("UD_NULL_");
    dummy        = new String();
    dummyQ_type  = new String("UD_NULL_");
    select       = new String();
    selectQ_type = new String("UD_NULL_");

    queries = new Vector();

    Node kn = tw.getNextElement("keys");
    if (kn != null) {
      String searchable = kn.getAttributes().getNamedItem("searchable").getNodeValue();
      inverse = searchable.equals("inverse");
      lookup = searchable.equals("lookup");

      TreeWalker fw = new TreeWalker(kn);
      Node f = fw.getNextElement("foreign");
      if (f != null) {
        foreign = f.getAttributes().getNamedItem("value").getNodeValue();
      }

      TreeWalker pw = new TreeWalker(kn);
      Node p = pw.getNextElement("primary");
      if (p != null) {
        primary = true;
      }

      // Get the insert.
      Node in = (new TreeWalker(kn)).getNextElement("insert");
      if (in != null) {
        insert = getNodeValue(in);
        try {
          insertQ_type = in.getAttributes().getNamedItem("qtype").getNodeValue().toUpperCase();
        }
        catch (NullPointerException e) {
        }
      }

      // Get the updates.
      Node un = (new TreeWalker(kn)).getNextElement("update");
      if (un != null) {
        update = getNodeValue(un);
        try {
          updateQ_type = un.getAttributes().getNamedItem("qtype").getNodeValue().toUpperCase();
        }
        catch (NullPointerException e) {
        }
      }

      // Get the dummies.
      Node dn = (new TreeWalker(kn)).getNextElement("dummy");
      if (dn != null) {
        dummy = getNodeValue(dn);
        try {
          dummyQ_type = dn.getAttributes().getNamedItem("qtype").getNodeValue().toUpperCase();
        }
        catch (NullPointerException e) {
        }
      }

      // Get the selects.
      Node sn = (new TreeWalker(kn)).getNextElement("select");
      if (sn != null) {
        select = getNodeValue(sn);
        try {
          selectQ_type = sn.getAttributes().getNamedItem("qtype").getNodeValue().toUpperCase();
        }
        catch (NullPointerException e) {
        }
      }

      // Get the queries.
      Node qsn = (new TreeWalker(kn)).getNextElement("queries");

      appendQueries(queries, qsn, "sql");
      appendQueries(queries, qsn, "radix");
    }

    // Now check cominations.
    // XXX TODO

  } // AttributeDef()

  private void appendQueries(Vector queries, Node qsn, String qrytype) {
    if (qsn != null) {
      TreeWalker qsw;
      Node q;

      qsw = new TreeWalker(qsn);
      while ((q = qsw.getNextElement(qrytype)) != null) {
        String keytype = q.getAttributes().getNamedItem("keytype").getNodeValue();

        // Blindly get the optional values.
        String clars = new String();
        try {
          clars = q.getAttributes().getNamedItem("class").getNodeValue();
        }
        catch (NullPointerException e) {
        }
        String space = new String();
        try {
          space = q.getAttributes().getNamedItem("space").getNodeValue();
        }
        catch (NullPointerException e) {
        }
        String family = new String();
        try {
          family = q.getAttributes().getNamedItem("family").getNodeValue();
        }
        catch (NullPointerException e) {
        }

        String sqlQuery = getNodeValue(q);

        Query query = new Query(qrytype, lookup, keytype, code, clars, sqlQuery, space, family);
        queries.addElement(query);
      }
    }
  } // getQueries()

  /**
   * Aaaargh I shouldn't have to write this. :-(
   *
   * @param        node
   * @return       The value of the node.
   * @see          AttributeDef
   *
   */
  private String getNodeValue(Node node) {
    String result = new String();

    String nodeStr = node.toString();
    int startIndex = nodeStr.indexOf('>') + 1;
    int endIndex = nodeStr.lastIndexOf('<');
    
    if ((startIndex < endIndex) && (startIndex > 0)) {
      result = nodeStr.substring(startIndex, endIndex);
    }

    return result;
  } // getNodeValue()

  
  public String getCode() {
    return code;
  } // getCode()

  public String getName() {
    return name;
  } // getName()

  public String getAltName() {
    return altName;
  } // getAltName()

  public String getStatus() {
    return status;
  } // getStatus()

  public String getDescription() {
    return description;
  } // getDescription()

  public String getFormat() {
    return format;
  } // getFormat()

  public String getEnum() {
    return new String("A_" + code).toUpperCase();
  } // getEnum()

  public String getChoice() {
    return choice;
  } // getChoice()

  public String getNumber() {
    return number;
  } // getNumber()

  public String getKeytype() {
    return keytype;
  } // getKeytype()

  public String getInsert() {
    return insert;
  } // getInsert()

  public String getInsertQ_type() {
    return insertQ_type;
  } // getInsertQ_type()

  public String getUpdate() {
    return update;
  } // getUpdate()

  public String getUpdateQ_type() {
    return updateQ_type;
  } // getUpdateQ_type()

  public String getDummy() {
    return dummy;
  } // getDummy()

  public String getDummyQ_type() {
    return dummyQ_type;
  } // getDummyQ_type()

  public String getSelect() {
    return select;
  } // getSelect()

  public String getSelectQ_type() {
    return selectQ_type;
  } // getSelectQ_type()

  public String getKeytype2() {
    String result = new String();

    if      (!lookup && !inverse && !primary) {
      result = " ";
    }
    else if (!lookup && !inverse &&  primary) {
      result = "primary key";
    }
    else if (!lookup &&  inverse && !primary) {
      result = "inverse key";
    }
    else if (!lookup &&  inverse &&  primary) {
      result = "primary/inverse key";
    }
    else if ( lookup && !inverse && !primary) {
      result = "lookup key";
    }
    else if ( lookup && !inverse &&  primary) {
      result = "primary/look-up key";
    }
    else if ( lookup &&  inverse && !primary) {
      result = "look-up/inverse key";
    }
    else if ( lookup &&  inverse &&  primary) {
      result = "Gimmie a break!";
    }

    return result;
  } // getKeytype()

  public String getKeytype3() {
    String result = new String();
    
    if (primary) {
      result = "[P]";
    }
    else  {
      result = "   ";
    }

    if (inverse) {
      result += "[I]";
    }
    else if (lookup) {
      result += "[L]";
    }
    else {
      result += "   ";
    }

    return result;
  } // getKeytype()

  public String getForeign() {
    return foreign;
  } // getForeign()

  public boolean getInverse() {
    return inverse;
  } // getInverse()

  public boolean getPrimary() {
    return primary;
  } // getPrimary()

  public Vector getQueries() {
    return queries;
  } // getQueries()

  public boolean setChoice(String choice) {
    boolean result=true;

    this.choice = choice;

    return result;
  } // setChoice()

  public boolean setNumber(String number) {
    boolean result=true;

    this.number = number;

    return result;
  } // setNumber()

  public Object clone() throws CloneNotSupportedException {
    return (AttributeDef)super.clone();
  } // clone()

  /*
  public boolean equals(String code) {
    return code.equals(code);
  } // equals()
  */
  
  public String toString() {
    return new String("ripe attribute={" +
                         "\n\tname="        + name        +
                         "\n\taltName="     + altName     +
                         "\n\tcode="        + code        +
                         "\n\tstatus="      + status      +
                         "\n\tkeytype="     + keytype     +
                         "\n\tdescription=" + description +
                         "\n\tformat="      + format      +
                         "\n\tchoice="      + choice      +
                         "\n\tnumber="      + number      +
                         "\n}");
  } // toString()


} // AttributeDef
