/* template.c - your comments here */

#ifndef	lint
static char *rcsid = "$Header: /a/vulcan/xtel/isode/isode-master/others/quipu/uips/de/RCS/init.c,v 8.0 91/07/17 13:18:42 isode Rel $";
#endif

/* 
 * $Header: /a/vulcan/xtel/isode/isode-master/others/quipu/uips/de/RCS/init.c,v 8.0 91/07/17 13:18:42 isode Rel $
 *
 *
 * $Log:	init.c,v $
 * Revision 8.0  91/07/17  13:18:42  isode
 * Release 7.0
 * 
 * 
 */

/*
 *				  NOTICE
 *
 *    Acquisition, use, and distribution of this module and related
 *    materials are subject to the restrictions of a license agreement.
 *    Consult the Preface in the User's Manual for the full terms of
 *    this agreement.
 *
 */


/****************************************************************************

  init.c - Do some initialising
           Read tailor files
           Eventually do argument parsing

*****************************************************************************/

/* #include <stdlib.h> */
#include "types.h"
#include "util.h"
#include "quipu/util.h"
#include "tailor.h"
#include "logger.h"


extern int print_parse_errors;          /* Quipu variable to disable
                                           printing of errors */

extern LLog * de_log;


extern char *oidtable,   /* Name of oidtable to use */
            *tailfile,   /* Name of dsaptailor file to use*/
            *username,
  	    *dsa_address,
  	    *local_dit;

extern int inverseVideo;
extern int greyBook;
extern int maxOrgs;
extern int maxDepts;
extern int maxPersons;
extern int localAlarmTime;
extern int remoteAlarmTime;

extern char default_country[],
     	    default_organisation[],
            default_department[],
	    default_person[],
	    origDefaultCo[], 
	    origDefaultOrg[];
static void read_de_option();

extern struct namelist * orgatts;
extern struct namelist * ouatts;
extern struct namelist * prratts;

int initialisations()
{
FILE *config_file;
char linebuf[LINESIZE], user_file[LINESIZE];
char * cp;

  print_parse_errors = FALSE;   /* Stop auto printing of errors */
  quipu_syntaxes();

#ifdef USE_PP
  pp_quipu_init ("de");
#endif

  /* Initialize dsap library. */
  dsap_init((int *)NULL, (char ***)NULL);

  specialSyntaxHandlers();

#ifdef USE_PP
  pp_quipu_run ();
#endif

  dsa_address = NULLCP;

  default_country[0] = '\0';
  default_organisation[0] = '\0';
  default_department[0] = '\0';
  default_person[0] = '\0';

/* Read in dsaptailor file */
  if ((config_file = fopen(isodefile(tailfile, 0), "r")) == (FILE *) NULL) {
    (void) fprintf(stderr,
            "Cannot open `dsaptailor' file. Attempting to continue.\n");
  } else {
    while(fgets(linebuf, sizeof(linebuf), config_file) != NULLCP)
      if ((*linebuf != '#') && (*linebuf != '\n')) (void) tai_string (linebuf);

    (void) fclose(config_file);
  }
  
  if ((config_file = fopen(isodefile("de/detailor", 0), "r")) == (FILE *) NULL) {
    (void) fprintf(stderr,
            "Cannot open `detailor' file. Attempting to continue.\n");
  } else {
    while(fgets(linebuf, sizeof(linebuf), config_file) != NULLCP)
      if ((*linebuf != '#') && (*linebuf != '\n')) read_de_option(linebuf);
    
    (void) fclose(config_file);
  }

  if ((cp = getenv("HOME")) != NULLCP)
  {
    (void) strcpy(user_file, cp);
    (void) strcat(user_file, "/.derc");
    if ((config_file = fopen(isodefile(user_file, 0), "r")) != (FILE *) NULL) {
      while(fgets(linebuf, sizeof(linebuf), config_file) != NULLCP)
        if ((*linebuf != '#') && (*linebuf != '\n')) read_de_option(linebuf);
      (void) fclose(config_file);
    }
  }
  initVideo();

  return OK;
}

/*
 * - read_de_option() -
 * Read in an option from detailor or derc file.
 *
 */
static void read_de_option(line)
     char *line;
{
char *part1, *part2;
extern char *TidyString(), *SkipSpace();
int n;

  part1 = SkipSpace(line);
  
  if ((part2 = index(part1, ':')) == NULLCP) return;

  *part2++ = '\0';
  part2 = TidyString(part2);

  if (lexequ(part1, "default_country") == 0) {
    (void) strcpy(default_country, part2);
  }
  else if (lexequ(part1, "default_org") == 0) {
    (void) strcpy(default_organisation, part2);
  }
  else if (lexequ(part1, "default_dept") == 0) {
    (void) strcpy(default_department, part2);
  }
  else if (lexequ(part1, "dsa_address") == 0) {
    dsa_address = copy_string(part2);
  }
  else if (lexequ(part1, "username") == 0) {
    username = copy_string(part2);
  }
  else if (lexequ(part1, "delogfile") == 0) {
    de_log->ll_file = copy_string(part2);
  }
  else if (lexequ(part1, "inverseVideo") == 0) {
    if (lexequ(part2, "off") == 0)
      inverseVideo = FALSE;
    else
      inverseVideo = TRUE;
  }
  else if (lexequ(part1, "greyBook") == 0) {
    if (lexequ(part2, "off") == 0)
      greyBook = FALSE;
    else
      greyBook = TRUE;
  }
  else if (lexequ(part1, "country") == 0) {
    addToCoList(part2);
  }
  else if (lexequ(part1, "mapattname") == 0) {
    addToAttList(part2);
  }
  else if (lexequ(part1, "commonatt") == 0) {
    addToList(&prratts, part2);
    addToList(&ouatts, part2);
    addToList(&orgatts, part2);
  }
  else if (lexequ(part1, "orgatt") == 0) {
    addToList(&orgatts, part2);
  }
  else if (lexequ(part1, "ouatt") == 0) {
    addToList(&ouatts, part2);
  }
  else if (lexequ(part1, "prratt") == 0) {
    addToList(&prratts, part2);
  }
  else if (lexequ(part1, "mapphone") == 0) {
    addToPhoneList(part2);
  }
/*
  else if (lexequ(part1, "maxOrgs") == 0) {
    n = atoi(part2);
    if (n > 0)
      maxOrgs = n;
  }
  else if (lexequ(part1, "maxDepts") == 0) {
    n = atoi(part2);
    if (n > 0)
      maxDepts = n;
  }
*/
  else if (lexequ(part1, "maxPersons") == 0) {
    n = atoi(part2);
    if (n > 0)
      maxPersons = n;
  }
  else if (lexequ(part1, "localAlarmTime") == 0) {
    n = atoi(part2);
    if (n > 0)
      localAlarmTime = n;
  }
  else if (lexequ(part1, "remoteAlarmTime") == 0) {
    n = atoi(part2);
    if (n > 0)
      remoteAlarmTime = n;
  }
} /* read_de_option */



/* might want this at some point
Usage (rtn)
char *rtn;
{
  (void) fprintf(stderr, "Some helpful message\n");
}
*/

welcome()
{
FILE * welcome_file;
char linebuf[LINESIZE];

  if ((welcome_file = fopen(isodefile("de/dewelcome", 0), "r")) == (FILE *) NULL)
    (void) fprintf(stderr,
            "Cannot open `dewelcome' file. Attempting to continue.\n");
  else 
  {
    while(fgets(linebuf, sizeof(linebuf), welcome_file) != NULLCP)
      (void) fputs(linebuf, stdout);
    (void) fclose(welcome_file);
  }
}
