      PROGRAM sequential_matrix_transpose
      implicit none
      integer m, i, j 
      parameter (m=12)
      real*8 a(m,m)
      
      CALL init_matrix(a,m)

      print *,'Square matrix dimension: ',m
      print *,'A='
      print 1000,((int(a(i,j)),j=1,m),i=1,m)
      
      CALL transpose(a,m)
      print *,'A-transpose='
      print 1000,((int(a(i,j)),j=1,m),i=1,m)
      
 1000 format((1x,12i4))      
      END

      SUBROUTINE init_matrix(a,m)
      implicit none         
      integer m, i, j, k
      real*8 a(m,m)
      k = 0
      do i=1,m
         do j=1,i
            k = k + 1
            a(i,j) = k
         enddo
         do j=i+1,m
            a(i,j) = 0
         enddo
      enddo
      END 
      
      SUBROUTINE transpose(a,m)
      implicit none
      integer m, i, j
      real*8 a(m,m), tmp
      do j=1,m
         do i=j+1,m
            tmp = a(j,i)
            a(j,i) = a(i,j)
            a(i,j) = tmp
         enddo
      enddo 
      END
