      PROGRAM sequential_invgamma
      implicit none
      real*8 x, y, eps
      real*8 xmin, xmax, xdelta
      real*8 ymin, ymax, ydelta
      integer nx, ny, i, j, nterms
      complex*16 z, invgamma, res 

      print *,'Error tolerance, xmin, xmax, nx, ymin, ymax, ny ?'
      read *,eps, xmin, xmax, nx, ymin, ymax, ny
      print 1002,eps, xmin, xmax, nx, ymin, ymax, ny

      xdelta = 0  
      nx = nx - 1
      if (nx.gt.0) xdelta = (xmax-xmin)/nx
      ydelta = 0 
      ny = ny - 1
      if (ny.gt.0) ydelta = (ymax-ymin)/ny
      print 1001,'Nterms','X','Y',
     $     'RE(FUN)','IM(FUN)','ABS(FUN)'

      do j=0,ny
         y = ymin + j*ydelta
         do i=0,nx
            x = xmin + i*xdelta          
            z = cmplx(x,y)
            res = invgamma(z,eps,nterms)
            print 1000,nterms,z,res,abs(res)
         enddo
      enddo          
 1000 format(1x,i13,1p,5E13.5)            
 1001 format(1x,a13,5a13)
 1002 format(1x,1p,E13.5,2(2g13.5,i4))
      END

      FUNCTION invgamma(zinput,eps,nterms)
      implicit none
      complex*16 zinput, z, invgamma, zn, fun, term
      real*8 g, eps, smalleps, magn, oldmagn
      parameter (g=0.5772156649)
      parameter (smalleps = 1E-12)
      integer n, ninf, iz, nterms
      parameter (ninf = 1 000 000 000)
      z = zinput
      iz = z
      if (z .eq. iz) z = z + smalleps
      term = log(z) + g*z
      fun = exp(term)
      magn = abs(fun)
      do n=1,ninf
         oldmagn = magn
         zn = z/n
         term = term + log(1 + zn) - zn
         fun = exp(term)
         magn = abs(fun)
         if (abs(magn - oldmagn) .le. eps) then
            nterms = n
            invgamma = fun
            return
         endif
      enddo
      END
