#include <stdio.h>
#include <stdlib.h>
#include "pvm3.h"

#define USAGE "dothost  len_of_the_vectors  NPROC"

int *create_slaves(char *node_exe, int NPROC)
{
  int mytid = pvm_mytid();
  int parent = pvm_parent();
  int *taskid = (int *)malloc(NPROC*sizeof(*taskid));
  int msglabel = 0;

  if (parent < 0) {
    pvm_spawn(node_exe,NULL,
              PvmTaskDefault,"*",
              NPROC,
              &taskid[0]);

    /* Send taskid tables to the other processes */
    pvm_initsend(PvmDataDefault);
    pvm_pkint(&NPROC,1,1);
    pvm_pkint(taskid,NPROC,1);
    pvm_mcast(taskid,NPROC,msglabel);
  }

  return taskid;
}

int main(int argc, char *argv[])
{
  int i, j;
  int N = atoi(argv[1]);
  int Nlocal;
  int NPROC = atoi(argv[2]);
  char *node_exe = "dotnode";
  int *taskid;
  double *a, *b, dotprod;

  Nlocal = (N+NPROC-1)/NPROC;
  N = Nlocal * NPROC;

  a = (double *)malloc(N*sizeof(*a));
  b = (double *)malloc(N*sizeof(*b));

  for (i=0; i<N; i++) {
      a[i] = i+1;
      b[i] = 1.0/(i+1);
  }

  taskid = create_slaves(node_exe,NPROC);

  /* Provide input data for slaves */
  for (j=0; j<NPROC; j++) {
    int msglabel = 1000;
    pvm_initsend(PvmDataDefault);
    pvm_pkint(&Nlocal,1,1);
    pvm_pkdouble(&a[j*Nlocal],Nlocal,1);
    pvm_pkdouble(&b[j*Nlocal],Nlocal,1);
    pvm_send(taskid[j],msglabel);
  }
    
  /* Read partial results and sum them */
  dotprod = 0;
  for (j=0; j<NPROC; j++) {
    int msglabel = 2000;
    double partial_sum;
    pvm_recv(-1,msglabel); /* Recv in any order */
    pvm_upkdouble(&partial_sum,1,1);
    dotprod += partial_sum;
  }

  printf("N = %d, dotprod = %f with NPROC=%d\n",
         N,dotprod,NPROC);

  pvm_exit(); /* Finish with PVM */

  return 0;
}
