#include "easy.h"
#include "easydefs.h"

#include <stdio.h>

#define FUNC     gb1cxch
#define TYPE     char
#define PACK     pvm_pkbyte
#define UNPACK   pvm_upkbyte
#include "gcxch.h"

#define FUNC     gi2cxch
#define TYPE     short
#define PACK     pvm_pkshort
#define UNPACK   pvm_upkshort
#include "gcxch.h"

#define FUNC     gi4cxch
#define TYPE     int
#define PACK     pvm_pkint
#define UNPACK   pvm_upkint
#include "gcxch.h"

#define FUNC     gr4cxch
#define TYPE     float
#define PACK     pvm_pkfloat
#define UNPACK   pvm_upkfloat
#include "gcxch.h"

#define FUNC     gr8cxch
#define TYPE     double
#define PACK     pvm_pkdouble
#define UNPACK   pvm_upkdouble
#include "gcxch.h"

#define MULTIP   2*
#define FUNC     gz8cxch
#define TYPE     float
#define PACK     pvm_pkcplx
#define UNPACK   pvm_upkcplx
#include "gcxch.h"

#define MULTIP   2*
#define FUNC     gz16cxch
#define TYPE     double
#define PACK     pvm_pkdcplx
#define UNPACK   pvm_upkdcplx
#include "gcxch.h"


int gcxch(data, blksize, result)
     void *data; 
     int blksize; 
     void *result;
 /* All-to-all or complete exchange */
{
  int ntotal = 0;

  if (ME != HOSTID) { /* Exclude the HOST */

#ifdef PICL
    if (logfp) {
      if (ME==0) tracemsg("gcxch()");
      SETIDLETIME();
      TRACEF(20,-4,MSG_CXCH,0);
    }
#endif /* PICL */

    switch (DATATYPE) {
    case BYTE1:
      ntotal = gb1cxch(data,blksize,result);
      break;
    case INTEGER2:
      ntotal = gi2cxch(data,blksize,result);
      break;
    case INTEGER4:
      ntotal = gi4cxch(data,blksize,result);
      break;
    case REAL4:
      ntotal = gr4cxch(data,blksize,result);
      break;
    case REAL8:
      ntotal = gr8cxch(data,blksize,result);
      break;
    case COMPLEX8:
      ntotal = gz8cxch(data,blksize,result);
      break;
    case COMPLEX16:
      ntotal = gz16cxch(data,blksize,result);
      break;
    default:
      fprintf(stderr,
	      "gcxch(@%d): Not implemented with data type# %d\n",
	      ME,DATATYPE);
      killproc(ME);
      break;
    }

#ifdef PICL
    if (logfp) {
      TRACETIME();
      TRACEF(21,-4,MSG_CXCH,0);
      UPDATEIDLETIME();
    }
#endif /* PICL */

  }

  return ntotal;
}

