/* gcol.h - macro */

#if defined(FUNC) && defined(TYPE) && defined(PACK) && defined(UNPACK)

#ifndef MULTIP
#define MULTIP
#endif

static int FUNC(data, ndata, result, nresult)
     TYPE *data;
     int ndata;
     TYPE *result; 
     int nresult;
{
  int ncnt = 0;

  if (ME > 0) { /* Nodes with # > 0  */
    pvm_initsend(INITHOW_node);
    pvm_pkint(&ndata,1,1);
    PACK(data, ndata, 1);          /* Send my contribution */
    pvm_send(NODEID[0], MSG_COL);
    
#ifdef PICL
    if (logfp) {
      TRACETIME();
      TRACEF(4,0,MSG_COL,MULTIP sizeof(*data)*ndata);
      TRACEF(7,MSG_COL);
    }
#endif

    pvm_recv(NODEID[0], MSG_COL);
    pvm_upkint(&ncnt,1,1);
    if (ncnt > nresult) error_and_out(nresult,ncnt);
    UNPACK(result, ncnt, 1);

#ifdef PICL
    if (logfp) {
      TRACETIME();
      TRACEF(8,0,MSG_COL,MULTIP sizeof(*data)*ndata);
    }
#endif

  }
  else { /* Node == 0 */
    int i, j;

    if (ndata > nresult) error_and_out(nresult,ndata);

    if (result != data) {
      for (i=0; i<MULTIP ndata; i++) {
	result[i] = data[i];
      }
    }

    ncnt = ndata;

    for (j=1; j<NUMNODES; j++) {

#ifdef PICL
      if (logfp) {
	TRACETIME();
	TRACEF(7,MSG_COL);
      }
#endif

      pvm_recv(NODEID[j], MSG_COL);
      pvm_upkint(&ndata,1,1);
      if (ncnt+ndata > nresult) error_and_out(nresult,ncnt+ndata);
      UNPACK(&result[MULTIP ncnt], ndata, 1);  /* Recv NODE #j's contribution */

#ifdef PICL
      if (logfp) {
        TRACETIME();
        TRACEF(8,j,MSG_COL,MULTIP sizeof(*data)*ndata);
      }
#endif

      ncnt += ndata;
    }
      
    pvm_initsend(INITHOW_node);
    pvm_pkint(&ncnt,1,1);
    PACK(result, ncnt, 1);
    pvm_mcast(&NODEID[1], NUMNODES-1, MSG_COL);

#ifdef PICL
    if (logfp) {
      TRACETIME();
      for (i=1; i<NUMNODES; i++)
	TRACEF(4,i,MSG_COL,MULTIP sizeof(*data) * ndata);
    }
#endif
  }

  return ncnt;
}


#undef MULTIP
#undef FUNC
#undef TYPE
#undef PACK
#undef UNPACK

#endif  /* defined(FUNC) && defined(TYPE) && defined(PACK) && defined(UNPACK) */
