#include "easy.h"

int 
FUNCTION(send) ARGS(`dest, msgtag, data, ndata')
int *dest;
int *msgtag;
void *data;
int *ndata;
{
  int retcode;
  int olddatatype = FUNCALL(getdatatype)();
  int oldstride;

  if (olddatatype == STRING) {
    FUNCALL(setdatatype)(BYTE1);
    oldstride = FUNCALL(setstride)(1);
  }

  retcode = FUNCALL(send)(*dest, *msgtag, data, *ndata);

  if (olddatatype == STRING) {
    FUNCALL(setdatatype)(STRING);
    FUNCALL(setstride)(oldstride);
  }

  return retcode;
}

int 
FUNCTION(send2d) ARGS(`dest, msgtag, data, nrows, ncols, offset')
int *dest;
int *msgtag;
void *data;
int *nrows;
int *ncols;
int *offset;
{
  int retcode;
  int olddatatype = FUNCALL(getdatatype)();
  int oldstride;

  if (olddatatype == STRING) {
    FUNCALL(setdatatype)(BYTE1);
    oldstride = FUNCALL(setstride)(1);
  }

  retcode = FUNCALL(send2d)(*dest, *msgtag, data, *nrows, *ncols, *offset);

  if (olddatatype == STRING) {
    FUNCALL(setdatatype)(STRING);
    FUNCALL(setstride)(oldstride);
  }

  return retcode;
}
