
      SUBROUTINE RANDS5 ( X ) 
C     -----------------------
      DOUBLE PRECISION     X (6)
C     ---------------------------------------------------------
C     |  Returns a random unit vector x (6), with uniform     |
C     |   distribution over the unit 5-sphere (S5)            |
C     ---------------------------------------------------------
      INTEGER  SEED
      DOUBLE PRECISION     N2,  RAND
      LOGICAL  STORED
      COMMON / RANDOM / N2, SEED, STORED
      INTEGER  I
      DOUBLE PRECISION     L, LSQ


C------ Generate 'x' uniformly distributed inside a 6-cube (with sides [-1,1])

  1   CONTINUE
        LSQ = 0.0D0
        DO 8  I = 1, 6
          X(I) = (2.0D0 * RAND (SEED)) - 1.0D0
          LSQ  = LSQ + (X(I) * X(I))
  8     CONTINUE


C------ Accept 'x' if it inside the unit 5-sphere (only 8% probability!).
C------ Otherwise generate a new 'x' :

      IF  ((LSQ .GT. 1.0D0) .OR. (LSQ .LT. 1.0D-6))  GO TO 1


C------ 'x' is now uniformly distributed INSIDE the unit 5-sphere (S5).
C------ Normalise it to length 1, so it is uniformly distributed ON S5 :

      L = SQRT (LSQ)
      DO 18  I = 1, 6
        X(I) = X(I) / L
 18   CONTINUE
      END
