
      SUBROUTINE SHIFTV (U, UPAR, DIR, SENSE, USHIFT)
C     ------------------------------------------------------

      INCLUDE 'qcd2.inc'

      INTEGER  UPAR, DIR, SENSE
      DOUBLE PRECISION   U( VSIZE ), USHIFT( VSIZE )

C     -----------------------------------------------------------------------
C     |       Shifts the fermion vector {u}  by one lattice spacing in      |
C     |  a given direction and sense (given by 'dir', 'sense').  The        |
C     |  shifted vector is returned in  {ushift}.                           |
C     |                                                                     |
C     |  'usites' = the sites on which the original {u} is defined  (i.e.   |
C     |             'even' or 'odd').                                       |
C     |  Note that if {u} is 'even' then {ushift} is 'odd', & vice versa.   |
C     -----------------------------------------------------------------------
      INTEGER     TDIR,  XDIR,  YDIR,  ZDIR,  EVEN,  ODD,
     *            PSENSE,  NSENSE,  PLUS,  MINUS,  RE,  IM
      PARAMETER ( TDIR = 1,    XDIR = 2,    YDIR = 3,    ZDIR = 4,
     *            EVEN = 0,     ODD = 1, PSENSE= 0, NSENSE= 1,
     *            PLUS = 0,   MINUS = 1,      RE = 1,      IM = 2 )

      INTEGER     XSIZE,  YSIZE,  ZSIZE
      PARAMETER ( XSIZE  =  SEGT * SEGY * SEGZ * NCOLOR,
     *            YSIZE  =  SEGT * SEGX * SEGZ * NCOLOR,
     *            ZSIZE  =  SEGT * SEGX * SEGY * NCOLOR )

      INTEGER  POST (2*VSIZE),  NEGT (2*VSIZE), 
     *         POSX (VSIZE),      NEGX (VSIZE),
     *         POSY (VSIZE),      NEGY (VSIZE),
     *         POSZ (VSIZE),      NEGZ (VSIZE)
      COMMON / ISHIFT / POST, POSX, POSY, POSZ, NEGT, NEGX, NEGY, NEGZ 

      INTEGER    SHIFT, I


      IF  (SENSE  .EQ.  PSENSE)  THEN
C     ---------------------------------
          IF  (DIR  .EQ.  TDIR)  THEN
C         ---------------------------

           SHIFT = UPAR * VSIZE

           DO 100 I =1, VSIZE
            USHIFT( POST(I+SHIFT) ) = U(I)
100        CONTINUE


            ELSEIF  (DIR  .EQ.  XDIR)  THEN
C           -------------------------------

           DO 200 I =1, VSIZE
            USHIFT( POSX(I) ) = U(I)
200        CONTINUE

            ELSEIF  (DIR  .EQ.  YDIR)  THEN
C           -------------------------------

           DO 300 I =1, VSIZE
            USHIFT( POSY(I) ) = U(I)
300        CONTINUE

            ELSE
C           ----

           DO 400 I =1, VSIZE
            USHIFT( POSZ(I) ) = U(I)
400        CONTINUE

          ENDIF
C         -----
        ELSEIF  (SENSE  .EQ.  NSENSE)  THEN
C       -------------------------------------
          IF  (DIR  .EQ.  TDIR)  THEN
C         ---------------------------

           SHIFT = UPAR * VSIZE

           DO 500 I =1, VSIZE
            USHIFT( NEGT(I+SHIFT) ) = U(I)
500        CONTINUE

            ELSEIF  (DIR  .EQ.  XDIR)  THEN
C           -------------------------------

           DO 600 I =1, VSIZE
            USHIFT( NEGX(I) ) = U(I)
600        CONTINUE

            ELSEIF  (DIR  .EQ.  YDIR)  THEN
C           -------------------------------

           DO 700 I =1, VSIZE
            USHIFT( NEGY(I) ) = U(I)
700        CONTINUE

            ELSE
C           ----

           DO 800 I =1, VSIZE
            USHIFT( NEGZ(I) ) = U(I)
800        CONTINUE

          ENDIF
C         -----
      ENDIF
C     -----

      END
