
      SUBROUTINE HEAD
C   ==================================================================
C   ===                                                            ===
C   ===         This subroutine generates the output header        ===
C   ===                     for benchmark run                      ===
C   ===                                                            ===
C   ==================================================================

      INCLUDE 'qcd2.inc'
      INTEGER  NPROCS, NSWEEP, UNIT
      PARAMETER ( NPROCS = PROCX * PROCY * PROCZ , UNIT = 8 )
      INTEGER  MAXIT, SIGFIG
      DOUBLE PRECISION H,  HALFH,  MQUARK,  MSQ 
      COMMON / PARAMS / H,HALFH,MQUARK,MSQ,NSWEEP,MAXIT,SIGFIG

      OPEN(UNIT,FILE = 'result')

      CALL HEADER(UNIT)

C------ Lattice size

      WRITE(UNIT, '(//A,I2,A,I2,A//)') 
     *          '   Lattice size   = ', NT, ' * ', NX, ' ** 3'

C  @@@@  Communication Structure  @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
C  @                                                                  @
C------Processor array dimensions

      WRITE(UNIT, '( A,I4 /A,3(I2,A) /A,4(I2,A)// )')
     * '   Number of processors  =',  NPROCS,
     * '        configured as an array of size  ( ',
     *                    PROCX,  ' * ', PROCY,  ' * ', PROCZ,  ' )',
     * '   Lattice segment / processor  =  ( ',
     *      SEGT,  ' * ',  SEGX,  ' * ',  SEGY,  ' * ',  SEGZ,  ' )'
C  @                                                                  @
C  @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

      WRITE(UNIT, '( 3(A,A/)//)')
     *'         -------------------------------------------------------'
     *,'--------',
     *'         |                    Results and Timings               '
     *,'       |',
     *'         -------------------------------------------------------'
     *,'--------'


C------ Results heading :

      WRITE(UNIT,  '(3(A,A/))')
     *'   kinetic     potential      total      no. CG   time/CG iter',
     *'    performance',
     *'   energy      energy         energy     iters        (s)     ',
     *'     (Mflop/s) ',
     *'   -------     ---------      ------     -----    ------------',
     *'    ------------'

      END

