
/*
*  NCSA Telnet source code
*  National Center for Supercomputing Applications
*  November 1, 1987
*  (C) Copyright 1987 The Board of Trustees of the University of Illinois
*
*  Permission is granted to any individual or institution to use, copy,
*  modify, or redistribute this software and its documentation provided
*  this notice and the copyright notices are retained.  This software
*  may not be distributed for profit, either in original form or in
*  derivative works.  The University of Illinois makes no representations
*  about the suitability of this software for any purpose.  
*  THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY,
*  EITHER EXPRESS OR IMPLIED, FOR THE PROGRAM AND/OR DOCUMENTATION PROVIDED,
*  INCLUDING, WITHOUT LIMITATION, WARRANTY OF MERCHANTABILITY AND WARRANTY
*  OF FITNESS FOR A PARTICULAR PURPOSE.
*/
#ifndef lint
static char *SCCSid = "@(#)rssun.c	1.6	(NCSA)	8/31/87";
#endif lint
/*
 *
 *      Virtual Screen Kernel Sun Real Screen Interface
 *                          (rssun.c)
 *  
 *      c1986,1987, National Center for Supercomputing Applications
 *      by Gaige B. Paulsen
 *		Sun Version by Steve Alexander & Gaige B. Paulsen
 *
 *    This file contains the sun real screen calls for the NCSA
 *  Virtual Screen Kernel.
 *
 *      RSbell(w)                   - Ring window w's bell
 *      RScursoff(w)                - Turn the cursor off in w
 *      RScurson(w,x,y)             - Turn the cursor on in w at x,y
 *      RSdraw(w,x,y,a,len,ptr)     - Draw @x,y in w string@ptr for length len
 *      RSdelchars(w,x,y,n)         - Delete n chars in w from x,y
 *      RSdellines(w,t,b,n)         - Delete n lines in region t->b in w
 *      RSerase(w,x1,y1,x2,y2)      - Erase from x1,y1 to x2,y2 in w
 *      RSinitall()                 - Initialize the world if necessary
 *      RSinslines(w,t,b,n)         - Insert n lines in region t->b in w
 *      RSinsstring(w,x,y,a,len,ptr)- Insert len chars @x,y in w attrib a
 *      RSsendstring(w,ptr,len)     - Send string @ptr length len from window w
 *		RSbufinfo(w, total, current) - Tells you the total/current lines
 *									  in buffer
 *		RSmargininfo(w, total, current) - Tells you the total/current cols
 *									  in buffer
 *		RSdelcols(w,n)				- deletes n columns left of n
 *		RSinscols(w,n)				- inserts n columns left of n
 *
 *		Sun Only routines
 *		-----------------
 *      RSattach(w, pw)				- attach the pixwin to this window
 *		RSgetwin(canvas)			- return the window # for canvas
 *		RSgetnet(canvas)			- return the socket for canvas
 *
 *      Version Date    Notes
 *      ------- ------  ---------------------------------------------------
 *      0.01    861102  Initial coding -GBP
 *      0.25    861106  Added code from screen.c -GBP
 *      0.50    861113  First compiled edition -GBP
 *      1.01    870608  Hacked for SunView -SCA
 */

#include	<stdio.h>
#include	<sys/types.h>
#include	<sys/time.h>
#include	"vskeys.h"
#include	"vsdata.h"
#include	<suntool/sunview.h>
#include	<suntool/window.h>
#include	<suntool/scrollbar.h>
#include	<suntool/canvas.h>
#include	<pixrect/pixrect.h>
#include	<sunwindow/pixwin.h>

#define Fheight 16
#define Fwidth 8
#define Fright (Fwidth * RSlocal[w].columns)

extern struct pixfont *zzbold;
extern struct pixfont *zzgrph;

struct RSdata {
	Frame		frame;
	Canvas		canvas;
	Pixwin		*window;
	Scrollbar	scrollx, scrolly;
	int			port;
	int			selected;
	int			sessnum;
	int			cursx, cursy;
	long		last, anchor;
	int			rows;
	int			columns;
	int			w, h;			/* in pixels */
	int 		xcur, xtotal, ycur, ybot, ytotal;
	};

typedef struct RSdata RSdata;

extern int scrn,numwindows,del;
extern char *VSgetline();

RSdata RSlocal[20];
struct pixrect	*RScur;				/* cursor rectangle */
int RSw= -1,         /* last window used */
    RSa=0;          /* last attrib used */

RSinitall()
{	
	int i;

	for (i = 0; i < 20; i++) {
		RSlocal[i].frame = (Canvas) 0;
		RSlocal[i].canvas = (Canvas) 0;
		RSlocal[i].window = (Pixwin *) 0;
		RSlocal[i].scrollx = (Scrollbar) 0;
		RSlocal[i].scrolly = (Scrollbar) 0;
		RSlocal[i].port = -1;
		RSlocal[i].selected = FALSE;
		RSlocal[i].last = 0L;
		RSlocal[i].anchor = 0L;
		RSlocal[i].sessnum = -1;
		RSlocal[i].cursx = 0;
		RSlocal[i].cursy = 0;
		RSlocal[i].rows = 24;
		RSlocal[i].columns = 80;
	}

}

/*
** beep
*/

RSbell(w)
int w;
{
	struct timeval tv;
	Pixwin *pw = RSlocal[w].window;
	Canvas cw = RSlocal[w].canvas;

	tv.tv_sec = 0;
	tv.tv_usec = 45500;			/* microseconds */
	win_bell(window_get(cw, WIN_FD), tv, pw);
}

/*
** turn cursor on and off
*/

RScursoff(w)
int w;
{
	Pixwin *pw = RSlocal[w].window;
	pw_copy(pw, RSlocal[w].cursx * Fwidth, RSlocal[w].cursy * Fheight,
			 Fwidth, Fheight, PIX_NOT(PIX_DST), pw, RSlocal[w].cursx * Fwidth,
			 RSlocal[w].cursy * Fheight);
}

RScurson(w,x,y)
int w,x,y;
{
	Pixwin *pw = RSlocal[w].window;
    pw_copy(pw, x * Fwidth, y * Fheight,
			 Fwidth, Fheight, PIX_NOT(PIX_DST), pw, x * Fwidth,
			 y * Fheight);
	RSlocal[w].cursx = x;
	RSlocal[w].cursy = y;
}

/*
** draw text on the screen -- handle attributes
*/

RSdraw(w, x, y, a, len, ptr)
int w, x, y, a, len;
unsigned char *ptr;
{
	struct pixfont *font = (struct pixfont *)0;
	int mode = PIX_SRC;

    Pixwin *pw = RSlocal[w].window;

	pw_batch_on(pw);
	/*
	** switch to bold if needed
	*/

	if (VSisbold(a))
		font = zzbold;

	/*
	** or maybe graph
	*/

	else if (VSisgrph(a))
		font = zzgrph;

	/*
	** handle reverse video
	*/

	if (VSisrev(a))
		mode = PIX_NOT(PIX_SRC);

	for (; len > 0; len--) {
		if (*ptr <128) {
			pw_char(pw, x * Fwidth, y * Fheight+11, mode, font, *ptr++);

			/*
			** draw the underline
			*/

			if (VSisundl(a)) {
				pw_vector(pw, x * Fwidth, y * Fheight+12,
						  (x * Fwidth) + Fwidth, y * Fheight + 12, mode,1);
			}
			x++;
		}
	}

	pw_batch_off(pw);
}

RSdelchars(w,x,y,n)
int w,x,y,n;
{
	Pixwin *pw = RSlocal[w].window;
	int left, top, width;

	left = x * Fwidth;
	width = n * Fwidth;

	top = y * Fheight;

	pw_copy(pw, (x * Fwidth),top,Fright - ((x + n) * Fwidth), Fheight, PIX_SRC, 
			pw, ((x + n) * Fwidth), top);
	pw_copy(pw, Fright - (left+(n*Fwidth)),top, (n * Fwidth), Fheight, PIX_SRC, 
			pw, Fright - (left + (n * Fwidth)), top );

}

RSdellines(w,t,b,n,scrolled)
int w,t,b,n,scrolled;
{
	Pixwin *pw = RSlocal[w].window;
	int left, right, top, length;

	left = 0;
	right = Fright;
	top =(t+n) * Fheight;
	length = ((b - (t + n))*Fheight)+Fheight;

	pw_batch_on(pw);

	pw_copy(pw, left, t*Fheight, right, length, PIX_SRC, pw, left, top);

    pw_copy(pw, left, t*Fheight + length, right, n * Fheight, 
			PIX_NOT(PIX_SRC) & PIX_DST, pw, left, t*Fheight + length);
	pw_batch_off(pw);
}
	
/*
** handle scrolling left & right
*/

RSinscols(w,n)
int w;
int n;
{
	Pixwin *pw = RSlocal[w].window;
	int left, right, top, bottom, width;

	top = 0;
	left = 0;
	right = n * Fwidth;
	bottom = RSlocal[w].rows * 16;
	width = RSlocal[w].columns * 8;
	width -= right;

	pw_batch_on(pw);
	pw_copy(pw, right, top, width, bottom,
		PIX_SRC, pw, left, top);

	pw_copy(pw, left, top, right, bottom,
		PIX_NOT(PIX_SRC) & PIX_DST, pw, left, top);

	pw_batch_off(pw);

}

RSdelcols(w,n)
int w;
int n;
{
	Pixwin *pw = RSlocal[w].window;
	int left, right, top, bottom, width;

	top = 0;
	left = 0;
	right = n * Fwidth;
	bottom = RSlocal[w].rows * 16;
	width = RSlocal[w].columns * 8;
	width -= right;

	pw_batch_on(pw);
	pw_copy(pw, left, top, width, bottom,
		PIX_SRC, pw, right, top);

	pw_copy(pw, width, top, right, bottom,
		PIX_NOT(PIX_SRC) & PIX_DST, pw, width, top);

	pw_batch_off(pw);

}

/*
** insert a string
*/

RSinsstring(w,x,y,a,len,ptr)
int w,x,y,a,len;
char *ptr;
{
	Pixwin *pw = RSlocal[w].window;
	int left, right, top, width;

	pw_batch_on(pw);
	left = x * Fwidth;
	top = y * Fheight;

	pw_copy(pw, left + (len * Fwidth), top, Fright - ((x + len) * Fwidth),
			Fheight, PIX_SRC, pw, left, top);

	pw_batch_off(pw);
	RSdraw(w, x, y, a, len, ptr);

}

/*
** insert lines
*/

RSinslines(w,t,b,n,scrolled)
int w,t,b,n,scrolled;
{
	Pixwin *pw = RSlocal[w].window;
	int left, right, top, length;

	left = 0;
	right = Fright;
	top = (t + n) * Fheight;
	length = ((b - (t + n))*Fheight)+Fheight;

	pw_batch_on(pw);
	pw_copy(pw, left, top, right, length,
			PIX_SRC, pw, left, t*Fheight);
	pw_batch_off(pw);

	length = (n - 1) * Fheight + Fheight;

	pw_batch_on(pw);
    pw_copy(pw, left, t*Fheight, right, length, PIX_NOT(PIX_SRC) & PIX_DST,
			pw, left, t*Fheight);
	pw_batch_off(pw);
			
}

RSerase(w,x1,y1,x2,y2)
int w,x1,y1,x2,y2;
{
	Pixwin *pw = RSlocal[w].window;

	int left, dx, top, dy;

    left = x1*Fwidth;
	top = y1*Fheight;
	dx = (x2+1)*Fwidth-1 - left;
	dy = (y2+1)*Fheight - top;
	pw_batch_on(pw);
    pw_copy(pw, left, top, dx, dy, PIX_NOT(PIX_SRC) & PIX_DST,
			pw, left, top);
	pw_batch_off(pw);

}

RSsendstring(w,ptr,len)
int w, len;
char *ptr;
{
    netwrite(w,ptr,len);
}

/*
** attach the pixwin to this window
*/

RSattach(w, f, s, c, n, x, y)
Frame f;
int w;
int s;
Canvas c;
int n;
Scrollbar x,y;
{
	RSinitmenu();
	RSlocal[w].sessnum = s;
	RSlocal[w].frame = f;
	RSlocal[w].canvas = c;
	RSlocal[w].window = canvas_pixwin(c);
	RSlocal[w].port = n;
	RSlocal[w].scrollx = x;
	RSlocal[w].scrolly = y;
}

/*
** re-init vars after session ends
*/

RSdetach(w)
int w;
{

	RSlocal[w].sessnum = -1;
	RSlocal[w].frame = (Frame) 0;
	RSlocal[w].canvas = (Canvas) 0;
	RSlocal[w].window = (Pixwin *) 0;
	RSlocal[w].port = -1;
	RSlocal[w].selected = FALSE;
	RSlocal[w].last = 0L;
	RSlocal[w].anchor = 0L;
	RSlocal[w].scrollx = (Scrollbar) 0;
	RSlocal[w].scrolly = (Scrollbar) 0;
}

/*
** return the window value
*/

int RSgetwin(c)
Canvas c;
{
	int i;

	for (i = 0; i < 20; i++)
		if (c == RSlocal[i].canvas)
			return i;

}

/*
** return session number value
*/

int RSgetnum(c)
Canvas c;
{
	int i;

	for (i = 0; i < 20; i++) {
		if (c == RSlocal[i].canvas)
			return RSlocal[i].sessnum;
	}
}

/*
** RSbufinfo
*/

RSbufinfo(w, total, current, bottom)
int w, total, current, bottom;
{
	int t;

	t = findbyVS(w);
	if (t < 0)
		return -1;

	RSlocal[t].ycur = current;
	RSlocal[t].ytotal = total;
	RSlocal[t].ybot = bottom;

	scrollbar_set(RSlocal[t].scrolly, SCROLL_VIEW_START, current + total, 0);
	scrollbar_set(RSlocal[t].scrolly, SCROLL_VIEW_LENGTH, bottom - current, 0);
	scrollbar_set(RSlocal[t].scrolly, SCROLL_OBJECT_LENGTH, 
					total + bottom - current, 0);
	scrollbar_paint(RSlocal[t].scrolly);
}

/*
** update the X scrolling (horizontal)
*/

RSmargininfo(w, total, current)
int w, total, current;
{
	int t;

	t = findbyVS(w);
	if (t < 0)
		return -1;

	RSlocal[t].xcur = current;
	RSlocal[t].xtotal = total;

	scrollbar_set(RSlocal[t].scrollx, SCROLL_VIEW_START, current, 0);
	scrollbar_set(RSlocal[t].scrollx, SCROLL_VIEW_LENGTH, 
		RSlocal[w].columns, 0);
	scrollbar_set(RSlocal[t].scrollx, SCROLL_OBJECT_LENGTH, 132, 0);
	scrollbar_paint(RSlocal[t].scrollx);
}

/*
** lookup based on session #
*/

findbyVS(w)
int w;
{
	
	int i;

	for (i = 0; i < 20; i++)
		if (w == RSlocal[i].sessnum)
			return i;
	return -1;

}

/*
** return network socket value
*/

int RSgetnet(c)
Canvas c;
{
	int i;

	for (i = 0; i < 20; i++) {
		if (c == RSlocal[i].canvas)
			return RSlocal[i].port;
	}
}

/*
** resize events
*/

RSresize(canvas, width, height)
Canvas canvas;
int width;
int height;
{

	char buf[60];
	int w;
	int x1, x2, y1, y2;
	int lines, cols;

	w = RSgetwin(canvas);
	if (w < 0)
		return;

	/*
	** clear the window
	*/

	pw_writebackground(RSlocal[w].window, 0, 0, width, height, PIX_SRC);

	/*
	** save the pixel size for the separator, and the lines/cols
	** for everything else.
	*/

	RSlocal[w].w = width;
	RSlocal[w].h = height;

	lines = height / 16;
	cols = width / 8;

	RSlocal[w].rows = lines;
	RSlocal[w].columns = cols;

	/*
	** adjust the VS region
	*/

	VSgetrgn(RSlocal[w].sessnum, &x1, &y1, &x2, &y2);
	VSsetrgn(RSlocal[w].sessnum, x1, y1, x1 + cols - 1, y1 + lines - 1);

	/*
	** draw the screen
	*/

	VSredraw(RSlocal[w].sessnum, 0, 0, cols, lines);
}

/*
** draw a page separator
*/

RSdrawsep(w, y1, dflag)
int w, y1, dflag;
{
	int t;

	return;			/* no one likes the line */
/*NOTREACHED*/
	t = findbyVS(w);
	if (t < 0)
		return -1;

	/*
	** draw separator or erase, depending
	*/

	if (dflag)
		pw_vector(RSlocal[w].window, 0, y1 * Fheight - 1,
				  RSlocal[w].w, y1 * Fheight - 1, PIX_SRC,1);
	else
		pw_vector(RSlocal[w].window, 0, y1 * Fheight - 1,
				  RSlocal[w].w, y1 * Fheight - 1,PIX_NOT(PIX_SRC) & PIX_DST,1);

}

/*
** menu for canvas
*/

static Menu RSmen;
static int current;

RSmenu(w,event)
int w;
Event *event;
{
	int t;

	t = findbyVS(w);
	if (t < 0)
		return -1;

	current = t;

	if (event_id(event) == MS_RIGHT && !event_is_up(event))
		menu_show(RSmen, RSlocal[t].canvas, event, 0);
}

/*
** initialize the menu
*/

RSinitmenu()
{

	Menu_item zgen();
	caddr_t uz_proc();
	Menu_item z132gen();
	caddr_t uz132_proc();

	RSmen = menu_create(MENU_FONT,zzbold,
			MENU_ITEM, MENU_STRING,
			"80 x 24",
			MENU_GEN_PROC, zgen,
			MENU_INACTIVE, TRUE,
			MENU_ACTION_PROC, uz_proc,0,
			MENU_ITEM, MENU_STRING,
			"132 x 24",
			MENU_GEN_PROC, z132gen,
			MENU_INACTIVE, TRUE,
			MENU_ACTION_PROC, uz132_proc,0,
			0);

}

/*
** generate for unzoom
*/

Menu_item zgen(mi, op)
Menu_item mi;
Menu_generate op;
{
	switch (op) {
	
		case MENU_DISPLAY:
			if (RSlocal[current].rows == 24 &&
				RSlocal[current].columns == 80)
				menu_set(mi, MENU_INACTIVE, TRUE,0);
			else
				menu_set(mi, MENU_INACTIVE, FALSE,0);
			break;
		case MENU_DISPLAY_DONE:
		case MENU_NOTIFY:
			break;
	}
	return mi;
}

/*
** generate for unzoom
*/

Menu_item z132gen(mi, op)
Menu_item mi;
Menu_generate op;
{
	switch (op) {
	
		case MENU_DISPLAY:
			if (RSlocal[current].rows == 24 &&
				RSlocal[current].columns == 132)
				menu_set(mi, MENU_INACTIVE, TRUE,0);
			else
				menu_set(mi, MENU_INACTIVE, FALSE,0);
			break;
		case MENU_DISPLAY_DONE:
		case MENU_NOTIFY:
		case MENU_NOTIFY_DONE:
			break;
	}
	return mi;
}

/*
** action for unzoom
*/

caddr_t uz_proc(m, mi)
Menu m;
Menu_item mi;
{
	window_set(RSlocal[current].canvas, WIN_WIDTH,654,
				WIN_HEIGHT,398, CANVAS_HEIGHT,384,CANVAS_WIDTH,640,0);

	window_set(RSlocal[current].frame, WIN_HEIGHT,450, WIN_WIDTH,664,0);
	return mi;
}

/*
** action for unzoom
*/

caddr_t uz132_proc(m, mi)
Menu m;
Menu_item mi;
{
	window_set(RSlocal[current].canvas, WIN_WIDTH,1070,
				WIN_HEIGHT,398, CANVAS_HEIGHT,384,CANVAS_WIDTH,1056,0);

	window_set(RSlocal[current].frame, WIN_HEIGHT,450, WIN_WIDTH,1080,0);
	return mi;
}

/*
** process scroll events
*/

Notify_value RSscroll(client, event, arg, type)
Canvas	client;
Event	*event;
Notify_arg	arg;
Notify_event_type type;
{
	
	int w, vw;
	int sh, sw;
	int motion, offset;
	float diff;

	sw = (int)scrollbar_get(arg, SCROLL_WIDTH);
	sh = (int)scrollbar_get(arg, SCROLL_HEIGHT);

	w = RSgetwin(client);			/* RS number */
	vw = RSlocal[w].sessnum;		/* VS number */

	if (w < 0)
		return NOTIFY_DONE;

	if (vw < 0)
		return NOTIFY_DONE;

	switch (event_id(event)) {

		case SCROLL_EXIT:
			return;

		case SCROLL_ENTER:

			if (arg == RSlocal[w].scrollx) {
				scrollbar_set(RSlocal[w].scrollx, SCROLL_VIEW_START,
					RSlocal[w].xcur, 0);
				scrollbar_set(RSlocal[w].scrollx, SCROLL_VIEW_LENGTH,
					RSlocal[w].columns, 0);
				scrollbar_set(RSlocal[w].scrollx, SCROLL_OBJECT_LENGTH, 132, 0);
			}
			else {
				scrollbar_set(RSlocal[w].scrolly, SCROLL_VIEW_START,
					RSlocal[w].ycur + RSlocal[w].ytotal, 0);
				scrollbar_set(RSlocal[w].scrolly, SCROLL_VIEW_LENGTH,
					RSlocal[w].ybot - RSlocal[w].ycur, 0);
				scrollbar_set(RSlocal[w].scrolly, SCROLL_OBJECT_LENGTH, 
					RSlocal[w].ytotal + RSlocal[w].ybot - 
						RSlocal[w].ycur, 0);
			}

			return;

		case SCROLL_REQUEST:

			/*
			** figure out which one's moving
			*/

			motion = (int)scrollbar_get(arg,SCROLL_REQUEST_MOTION);
			offset = (int)scrollbar_get(arg,SCROLL_REQUEST_OFFSET);
			switch ((int)scrollbar_get(arg, SCROLL_DIRECTION)) {

				/*
				** y direction
				*/

				case SCROLL_VERTICAL:
					switch (motion) {
						case SCROLL_POINT_TO_MIN:
						case SCROLL_LINE_FORWARD:
							VSscrolback(vw, 1);
							break;

						case SCROLL_MIN_TO_POINT:
						case SCROLL_LINE_BACKWARD:
							VSscrolforward(vw, 1);
							break;

						case SCROLL_MAX_TO_POINT:
						case SCROLL_PAGE_BACKWARD:
							VSscrolback(vw, RSlocal[w].rows - 1);
							break;

						case SCROLL_POINT_TO_MAX:
						case SCROLL_PAGE_FORWARD:
							VSscrolforward(vw, RSlocal[w].rows - 1);
							break;

						case SCROLL_ABSOLUTE:
							diff = (float) offset / (float) sh;
							diff *= (float)
								(RSlocal[w].ybot + RSlocal[w].ytotal
								 - RSlocal[w].ycur);
							diff = (float)(RSlocal[w].ycur + RSlocal[w].ytotal)
									- diff;
							if (diff < 0.0)
								VSscrolforward(vw, (int)(-diff));
							else
								VSscrolback(vw, (int)diff);

							break;
							
						default:
							break;
					}

					break;

				/*
				** x direction
				*/

				case SCROLL_HORIZONTAL:
					switch (motion) {
						case SCROLL_POINT_TO_MIN:
						case SCROLL_LINE_FORWARD:
							VSscrolleft(w,1);
							break;

						case SCROLL_MIN_TO_POINT:
						case SCROLL_LINE_BACKWARD:
							VSscrolright(w,1);
							break;

						case SCROLL_MAX_TO_POINT:
						case SCROLL_PAGE_BACKWARD:
							VSscrolleft(w,RSlocal[w].columns);
							break;

						case SCROLL_POINT_TO_MAX:
						case SCROLL_PAGE_FORWARD:
							VSscrolright(w,RSlocal[w].columns);
							break;

						case SCROLL_ABSOLUTE:
							diff = (float) offset / (float) sw;
							diff *= 132.0;
							diff = (float)RSlocal[w].xcur - diff;
							if (diff < 0.0)
								VSscrolright(vw, (int)-diff);
							else
								VSscrolleft(vw, (int)diff);

							break;
							
						default:
							break;
					}

					break;

				/*
				** huh?
				*/

				default:
					break;
			}

			default:
				break;
	}

	if (arg == RSlocal[w].scrollx) {
		scrollbar_set(RSlocal[w].scrollx, SCROLL_VIEW_START,
			RSlocal[w].xcur, 0);
		scrollbar_set(RSlocal[w].scrollx, SCROLL_VIEW_LENGTH,
			RSlocal[w].columns, 0);
		scrollbar_set(RSlocal[w].scrollx, SCROLL_OBJECT_LENGTH, 132, 0);
	}
	else {
		scrollbar_set(RSlocal[w].scrolly, SCROLL_VIEW_START,
			RSlocal[w].ycur + RSlocal[w].ytotal, 0);
		scrollbar_set(RSlocal[w].scrolly, SCROLL_VIEW_LENGTH,
			RSlocal[w].ybot - RSlocal[w].ycur, 0);
		scrollbar_set(RSlocal[w].scrolly, SCROLL_OBJECT_LENGTH, 
			RSlocal[w].ytotal + RSlocal[w].ybot - 
				RSlocal[w].ycur, 0);
	}

	scrollbar_paint(RSlocal[w].scrollx);
	scrollbar_paint(RSlocal[w].scrolly);
}
