
/*
*  NCSA Telnet source code
*  National Center for Supercomputing Applications
*  November 1, 1987
*  (C) Copyright 1987 The Board of Trustees of the University of Illinois
*
*  Permission is granted to any individual or institution to use, copy,
*  modify, or redistribute this software and its documentation provided
*  this notice and the copyright notices are retained.  This software
*  may not be distributed for profit, either in original form or in
*  derivative works.  The University of Illinois makes no representations
*  about the suitability of this software for any purpose.  
*  THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY,
*  EITHER EXPRESS OR IMPLIED, FOR THE PROGRAM AND/OR DOCUMENTATION PROVIDED,
*  INCLUDING, WITHOUT LIMITATION, WARRANTY OF MERCHANTABILITY AND WARRANTY
*  OF FITNESS FOR A PARTICULAR PURPOSE.
*/
/*
** @(#)session.h	1.5	(NCSA)	8/10/87
**
** format of a session
*/

struct session {
	Canvas	s_canvas;			/* canvas where output is drawn	*/
	int		s_fd;				/* network file descriptor		*/
	int		s_winval;			/* VS window handle				*/
	int		s_tekwin;			/* VG window handle				*/
	int		s_valid;			/* whether session is active	*/
	char	s_hostn[256];		/* hostname connected to 		*/
	int		s_telstate;			/* telnet state					*/
	int		s_telbinary;		/* telnet binary mode			*/
	int		s_echo;				/* echo state					*/
	int		s_lock;				/* scroll lock state			*/
	int		s_termstate;		/* terminal state				*/
	int		s_tekgin;			/* GIN mode for tek				*/
	char	s_linemode[80];		/* line mode buffer				*/
	char	s_spcflag;			/* special telnet chars	active	*/
	char	s_special[6];		/* special telnet chars			*/
	int		s_scroll;			/* lines of scroll back 		*/
} Session;
