/* raw8tori8.c
 * Convert a raw raster file to an HDF image.  No palette information in the
 * file, so make up a nice gray scale.
 *
 */

#include <stdio.h>

/* Package-wide include files */

#include "reformat.h"
#include "extern.h"
#include "types.h"
#include "error.h"

ErrorCode Raw8ToRI8(fname, info)
     char *fname;
     FileInfo *info;
{
  FILE *fp;
  int i;

#ifndef XGUI

/* Check for the dimensions.  If not yet specified, ask for them. */

  if (Width <= 0 || Height <= 0)
    {
      printf("Enter the width of the image: ");
      scanf("%ld", &Width);

      printf("Enter the height of the image: ");
      scanf("%ld", &Height);
    }

#else

  if (Width <= 0 || Height <= 0)
    {
      Width = GetDimWidth();
      Height = GetDimHeight();
    }

#endif

  if (Width <= 0 || Height <= 0)
    return(err_msg(Raw82RI8, ZeroSizeImage));

/* OK, open up the raw file */

  fp = fopen(fname, "r");
  if (fp == NULL) return(err_msg(Raw82RI8, InputOpenFailed));

/* Allocate some space for the image */

  info->image = (byte *)malloc(Width * Height);

/* Read that puppy in */

  if (fread(info->image, sizeof(byte), Width*Height, fp) != Width * Height)
    {
      free(info->image);
      return(err_msg(Raw82RI8, BadFileData));
    }

/* Make a nice gray scale palette */

  for (i=0; i<(MAX_PAL/3); i++)
    info->palette[i*3] = info->palette[i*3+1] =
      info->palette[i*3+2] = (unsigned char) 255 - i;

  info->width = Width;
  info->height = Height;
  info->values = (BitMask)(CvtImage | CvtPalette);

  return(AllOk);
}
