#ifdef RCSID
static char RcsId[] = "@(#)$Revision: 1.1 $";
#endif
/*
$Header: /pita/work/HDF/dev/RCS/test/annotations/putSDS_RISan.c,v 1.1 90/04/19 11:16:15 mfolk beta $

$Log:	putSDS_RISan.c,v $
 * Revision 1.1  90/04/19  11:16:15  mfolk
 * Initial revision
 * 
*/
/***********************************************************
*
* Example program: Illustrates storing annotations in a file
* Writes several SDSs and corresponding RISs to a file. 
* Writes labels and descriptions for all but the first three SDSs.
* Writes labels and descriptions for all RISs.
*
************************************************************ */

#include <stdio.h>
#include <math.h>
#include "df.h"
#define EXPAND 1
#define TRUE   1
#define FALSE  0

char *malloc();

main(argc,argv)
int argc;
char *argv[];
{
    int i, j, k, l, height, width, reps, 
        increment, imax;
	int dimsizes[2];
	float *pdata,*data,*hscale, *wscale, max, min;
    char s[500], s1[200], label[50], outfile[50];
	
    if (argc != 5) {
        printf("Usage: %s outfile height width reps\n", argv[0]);
        exit(1);
    }

    strcpy(outfile, argv[1]);
    height = atoi(argv[2]);
    width =  atoi(argv[3]);
    reps = atoi(argv[4]);

    data = (float *) malloc(height*width*sizeof(float));
    hscale = (float *) malloc(height*sizeof(float));
    wscale = (float *) malloc(width*sizeof(float));

    gen2Dfloat(height, width, data, &max, &min);

    for (i=0; i< height; i++) hscale[i] = i+1;
    for (i=0; i< width; i++)  wscale[i] = i+1;

	dimsizes[0]=width;
	dimsizes[1]=height;

    i = DFSDsetdims(2,dimsizes);
    i = DFSDsetmaxmin((float) max, min);
    i = DFSDsetdimscale(1,height,hscale);
    i = DFSDsetdimscale(2,width,wscale);

    for (j=0; j<reps; j++) {

        /* write out scientific data set */
    	DFSDadddata(outfile, 2,dimsizes,data);

        if ((j%3) != 0) {      /* write out annotations for 2 out of every 3 */
            i = DFSDlastref();
            sprintf(label,"Array #%d",j);
        	DFANputlabel(outfile, DFTAG_SDG, i, label);
       	    sprintf(s,"2-D fp array #%d. Produces spectrum with grid.\n",j);
       	    sprintf(s1,"\tDimensions:\n\t\theight = %d\n\t\twidth = %d", 
                                                              height, width);
       	    strcat(s,s1);
    	    DFANputdesc(outfile, DFTAG_SDG, i, s, strlen(s));
        } 

        /* convert data to image; write out image and its annotations */
        DFUfptoimage(width,height, max, min, wscale,hscale,data,NULL,
                                     outfile, EXPAND, width*5,height*5,FALSE);
        i = DFR8lastref();
        sprintf(label,"Image #%d",j);
      	DFANputlabel(outfile, DFTAG_RIG, i, label);
        sprintf(s ,"Image #%d. Spectrum with grid.\n",j);
       	sprintf(s1,"\tDimensions:\n\t\theight = %d\n\t\twidth = %d", 
                                                          height*5, width*5);
       	strcat(s ,s1);
    	DFANputdesc(outfile, DFTAG_RIG, i, s, strlen(s));
         
        pdata = data;       /* increment all data values by 2 */
        increment = max/10;
        imax = (float) max;
        for (k=0; k< height; k++)    
           for (l=0; l< width; l++) { 
               *pdata = ( increment + (int) *pdata) % imax;
               pdata++;
           }
    }
    printf("\n\n\n");
}

