/*--------------------------------------------------------------------------*
 *
 * Usage :
 *
 *   hdf2tiff hdf_file [index] tiff_file [-append]
 *
 * Compile :
 *
 *   cc hdf2tiff.c tiffutils.o utils.o -o hdf2tiff -ltiff -ldf
 *
 * 				NO WARRANTY
 *  
 *  This software is distributed free of charge and is in the public domain.
 *  Anyone may use, duplicate or modify this program.  Thinking Machines
 *  Corporation does not restrict in any way the use of this software by
 *  anyone.
 *  
 *  Thinking Machines Corporation provides absolutely no warranty of any kind.
 *  The entire risk as to the quality and performance of this program is with
 *  you.  In no event will Thinking Machines Corporation be liable to you for
 *  damages, including any lost profits, lost monies, or other special,
 *  incidental or consequential damages arising out of the use of this program.
 * 
 * Jim Salem 9/26/89
 * Please keep this notice with the file.
 *
 * RCS: $Id: hdf2tiff.c,v 2.0 90/08/01 11:04:05 salem Exp $
 *  $Log:	hdf2tiff.c,v $
 * Revision 2.0  90/08/01  11:04:05  salem
 * Bump to next release, no changes
 * 
 * Revision 1.1  90/07/30  18:36:55  salem
 * Initial revision
 * 
 *
 *--------------------------------------------------------------------------*/

#include "utils.h"
#include <tiff/tiffio.h>

/*--------------------------------------------------------------------------*
 * Global Vars.
 *--------------------------------------------------------------------------*/

static
  char *progname;		/* argv[0] */

/*--------------------------------------------------------------------------*
 * Utilities
 *--------------------------------------------------------------------------*/

extern void signal_hdf_error();
extern long strtol();

static
  int parse_uint (string)
char *string;
/* Returns -1 if error otherwise the integer */
{
  long ret;
  char *ptr;

  ret = strtol(string, &ptr, 10);
  if (ret < 0 || ptr != string + strlen(string))
    return -1;
  else
    return ret;
}

static
  void bad_usage ()
{
  fprintf(stderr,"Usage: %s hdf_file [index] tiff_file [-append]\n\
  index identifies the particular image within the file (default 0)\n\
  If -append is present, the TIFF file is appended.\n", progname);
  exit (1);
}

/*--------------------------------------------------------------------------*
 * Main
 *--------------------------------------------------------------------------*/

void
  main (argc, argv)
int argc;
char **argv;
{
  int index = 0;
  char *hdf_filename;
  char *tiff_filename;
  Boolean append_p, index_required;

  progname = argv[0];

  /* argument parsing */
  hdf_filename = argv[1];
  switch (argc)
    {case 5:
       if (strcmp(argv[4],"-append")) bad_usage();
       append_p = True;
       tiff_filename = argv[3];
       index_required = True;
       break;
     case 4:
       if (strcmp(argv[3],"-append")) {
	 append_p = False;
	 index_required = True;
	 tiff_filename = argv[3];
       }
       else {
	 append_p = True;
	 index_required = False;
	 tiff_filename = argv[2];
       }
       break;
     case 3:
       append_p = False;
       index_required = False;
       tiff_filename = argv[2];
       break;
     default:
       bad_usage();
       break;
     }

  if (index_required) {
    index = parse_uint (argv[2]);
    if (index < 0) bad_usage();
  }

  if (! hdf_to_tiff_file (hdf_filename, index, tiff_filename, append_p, NULL))
    signal_hdf_error(progname);

  exit(0);
}

    
