C     ****************
      SUBROUTINE MKTBL(NVH,ORDEXP,SIGMA,TBL,WK1,WK2,WK3,WK4)
C     ****************
C
C
      DOUBLE PRECISION TBL(NVH,2,18),
     >                 WK1(NVH,18),WK2(NVH,18),WK3(NVH,18),WK4(NVH,18),
     >                 RGAUSS(8),
     >                 DRAND,
     >                 SQRT3I,TWO,ONE,HALF,ZERO,SIX,
     >                 SIGMA,FAKUL
C
      INTEGER          ORDEXP
C
      PARAMETER( SQRT3I = 0.57735026918962576E0 )
      PARAMETER( TWO    = 2.E0                  )
      PARAMETER( ONE    = 1.E0                  )
      PARAMETER( HALF   = 0.5E0                 )
      PARAMETER( ZERO   = 0.E0                  )
      PARAMETER( SIX    = 6.0E0                 )
C
C
C     LOOP OVER THE TABLE SIZE
C
C
      DO 10 I=1,NVH
C
C
C     GENERATING EIGHT GAUSSIAN RANDOM NUMBERS WITH VARIANCE SIGMA;
C     THE FACTOR ONE HALF APPEARS BY THE REPRESENTATION OF THE SU3
C     MATRICES
C
C
      DO 20 J=1,8
C
      RGAUSS(J) = - SIX
C
      DO 30 IDU=1,12
      RGAUSS(J) = RGAUSS(J) + DRAND(0)
   30 CONTINUE
C
      RGAUSS(J) = RGAUSS(J) * SIGMA * HALF
C
   20 CONTINUE
C
      WK1(I, 1) =   RGAUSS(3) + RGAUSS(8) * SQRT3I
      WK1(I, 2) =   RGAUSS(1)
      WK1(I, 3) =   RGAUSS(4)
      WK1(I, 4) =   RGAUSS(1)
      WK1(I, 5) = - RGAUSS(3) + RGAUSS(8) * SQRT3I
      WK1(I, 6) =   RGAUSS(6)
      WK1(I, 7) =   RGAUSS(4)
      WK1(I, 8) =   RGAUSS(6)
      WK1(I, 9) = -             RGAUSS(8) * SQRT3I * TWO
      WK1(I,10) =   ZERO
      WK1(I,11) =   RGAUSS(2)
      WK1(I,12) =   RGAUSS(5)
      WK1(I,13) = - RGAUSS(2)
      WK1(I,14) =   ZERO
      WK1(I,15) =   RGAUSS(7)
      WK1(I,16) = - RGAUSS(5)
      WK1(I,17) = - RGAUSS(7)
      WK1(I,18) =   ZERO
C
   10 CONTINUE
C
C
C     EXPANDING THE EXPONENTIAL FUNCTION TO ORDER ORDEXP
C
C
C     INITIALIZATION
C
C
      DO 40 IC=1,18
      DO 40 I =1,NVH
      WK2(I,IC) = WK1(I,IC)
   40 CONTINUE
C
      DO 50 I=1,NVH
C
      WK4(I, 1) = ONE
      WK4(I, 2) = ZERO
      WK4(I, 3) = ZERO
      WK4(I, 4) = ZERO
      WK4(I, 5) = ONE
      WK4(I, 6) = ZERO
      WK4(I, 7) = ZERO
      WK4(I, 8) = ZERO
      WK4(I, 9) = ONE
      WK4(I,10) = ZERO
      WK4(I,11) = ZERO
      WK4(I,12) = ZERO
      WK4(I,13) = ZERO
      WK4(I,14) = ZERO
      WK4(I,15) = ZERO
      WK4(I,16) = ZERO
      WK4(I,17) = ZERO
      WK4(I,18) = ZERO
C
   50 CONTINUE
C
      IPM = 1
C
C
C     ********
      CALL ADD(NVH,NVH,IPM,WK4,WK4,WK1)
C     ********
C
C
      DO 60 IO = 2,ORDEXP
C
      IPM = 1
C
C
C     ********
      CALL PRO(NVH,NVH,IPM,WK3,WK2,WK1)
C     ********
C
C
      FAKUL = ONE / DBLE( IO )
C
      DO 70 IC=1,18
      DO 70 I =1,NVH
      WK2(I,IC) = WK3(I,IC) * FAKUL
   70 CONTINUE
C
      IPM = MOD(IO,4)
      IF( IPM .EQ. 0 ) IPM = 4
C
C
C     ********
      CALL ADD(NVH,NVH,IPM,WK4,WK4,WK2)
C     ********
C
C
   60 CONTINUE
C
C
C     RENORMILIZATION OF WK4
C
C
C     ***********
      CALL RENORM( NVH, WK4 )
C     ***********
C
C
C     FILL UP THE LOWER HALF OF TBL WITH WK4
C
C
      DO 90 ISM =1,18
      DO 90 ILP=1,NVH
      TBL(ILP,1,ISM) = WK4(ILP,ISM)
   90 CONTINUE
C
      DO 110 ILP = 1,NVH
C
      TBL(ILP,2, 1) =   WK4(ILP, 1)
      TBL(ILP,2, 2) =   WK4(ILP, 4)
      TBL(ILP,2, 3) =   WK4(ILP, 7)
      TBL(ILP,2, 4) =   WK4(ILP, 2)
      TBL(ILP,2, 5) =   WK4(ILP, 5)
      TBL(ILP,2, 6) =   WK4(ILP, 8)
      TBL(ILP,2, 7) =   WK4(ILP, 3)
      TBL(ILP,2, 8) =   WK4(ILP, 6)
      TBL(ILP,2, 9) =   WK4(ILP, 9)
C
      TBL(ILP,2,10) = - WK4(ILP,10)
      TBL(ILP,2,11) = - WK4(ILP,13)
      TBL(ILP,2,12) = - WK4(ILP,16)
      TBL(ILP,2,13) = - WK4(ILP,11)
      TBL(ILP,2,14) = - WK4(ILP,14)
      TBL(ILP,2,15) = - WK4(ILP,17)
      TBL(ILP,2,16) = - WK4(ILP,12)
      TBL(ILP,2,17) = - WK4(ILP,15)
      TBL(ILP,2,18) = - WK4(ILP,18)
C
 110  CONTINUE
C
C
      RETURN
      END
C
C
